/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mplayer;

import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.MediaPlayer;
import com.frostwire.mplayer.MetaDataListener;
import com.frostwire.mplayer.PlayerPreferences;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.frostwire.mplayer.TaskListener;
import com.frostwire.mplayer.VolumeListener;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseMediaPlayer
implements MediaPlayer,
MetaDataListener,
StateListener,
VolumeListener,
PositionListener,
TaskListener,
IcyInfoListener {
    private List<MetaDataListener> metaDataListeners;
    private List<StateListener> stateListeners;
    private List<VolumeListener> volumeListeners;
    private List<PositionListener> positionListeners;
    private List<TaskListener> taskListeners;
    private List<IcyInfoListener> icyInfoListeners;
    private MediaPlaybackState currentState;
    private int currentVolume;
    private int videoWidth;
    private int videoHeight;
    private int displayWidth;
    private int displayHeight;
    private float currentPositionInSecs;
    private float durationInSecs;
    private boolean durationInSecsSet;
    private List<Language> audioTracks;
    private List<Language> subtitles;
    private String activeAudioTrackId = "0";
    private LanguageSource activeSubtitleSource = null;
    private String activeSubtitleId = null;
    private String openedFile;
    protected PlayerPreferences preferences;

    public BaseMediaPlayer() {
        this(null);
    }

    public BaseMediaPlayer(PlayerPreferences playerPreferences) {
        this.preferences = playerPreferences;
        this.metaDataListeners = new ArrayList<MetaDataListener>(1);
        this.stateListeners = new ArrayList<StateListener>(1);
        this.volumeListeners = new ArrayList<VolumeListener>(1);
        this.positionListeners = new ArrayList<PositionListener>(1);
        this.taskListeners = new ArrayList<TaskListener>(1);
        this.icyInfoListeners = new ArrayList<IcyInfoListener>(1);
        this.initialize();
        this.setMetaDataListener(this);
        this.setStateListener(this);
        this.setVolumeListener(this);
        this.setPositionListener(this);
        this.setIcyInfoListener(this);
    }

    private void initialize() {
        this.openedFile = null;
        this.audioTracks = new ArrayList<Language>();
        this.subtitles = new ArrayList<Language>();
        this.activeAudioTrackId = "0";
        this.activeSubtitleId = null;
        this.activeSubtitleSource = null;
        this.durationInSecs = 0.0f;
        this.durationInSecsSet = false;
        this.currentPositionInSecs = 0.0f;
        this.currentState = MediaPlaybackState.Uninitialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMetaDataListener(MetaDataListener metaDataListener) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            this.metaDataListeners.add(metaDataListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(StateListener stateListener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            this.stateListeners.add(stateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addVolumeListener(VolumeListener volumeListener) {
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            this.volumeListeners.add(volumeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPositionListener(PositionListener positionListener) {
        List<PositionListener> list = this.positionListeners;
        synchronized (list) {
            this.positionListeners.add(positionListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIcyInfoListener(IcyInfoListener icyInfoListener) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            this.icyInfoListeners.add(icyInfoListener);
        }
    }

    public abstract void setStateListener(StateListener var1);

    public abstract void setVolumeListener(VolumeListener var1);

    public abstract void setMetaDataListener(MetaDataListener var1);

    public abstract void setPositionListener(PositionListener var1);

    public abstract void setIcyInfoListener(IcyInfoListener var1);

    public abstract void doOpen(String var1);

    public abstract void doPause();

    public abstract void doResume();

    public abstract void doStop();

    public abstract void doSeek(float var1);

    public abstract void doSetVolume(int var1);

    public abstract void doLoadSubtitlesFile(String var1, boolean var2);

    public void doLoadSubtitlesFile(String string) {
        this.doLoadSubtitlesFile(string, true);
    }

    @Override
    public void open(String string) {
        if (this.currentState == MediaPlaybackState.Uninitialized || this.currentState == MediaPlaybackState.Stopped) {
            this.openedFile = string;
            this.doOpen(string);
        } else {
            this.doStop();
            this.initialize();
            this.openedFile = string;
            this.doOpen(string);
        }
    }

    @Override
    public String getOpenedFile() {
        return this.openedFile;
    }

    public void loadSubtitlesFile(String string) {
        this.doLoadSubtitlesFile(string);
    }

    @Override
    public void pause() {
        if (this.currentState == MediaPlaybackState.Playing) {
            this.doPause();
        }
    }

    @Override
    public void play() {
        if (this.currentState == MediaPlaybackState.Paused) {
            this.doResume();
        }
    }

    @Override
    public void togglePause() {
        if (this.currentState == MediaPlaybackState.Paused) {
            this.doResume();
        } else if (this.currentState == MediaPlaybackState.Playing) {
            this.doPause();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMetaDataListener(MetaDataListener metaDataListener) {
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            while (this.metaDataListeners.contains(metaDataListener)) {
                this.metaDataListeners.remove(metaDataListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(StateListener stateListener) {
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            while (this.stateListeners.contains(stateListener)) {
                this.stateListeners.remove(stateListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeVolumeListener(VolumeListener volumeListener) {
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            while (this.volumeListeners.contains(volumeListener)) {
                this.volumeListeners.remove(volumeListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePositionListener(PositionListener positionListener) {
        List<PositionListener> list = this.positionListeners;
        synchronized (list) {
            while (this.positionListeners.contains(positionListener)) {
                this.positionListeners.remove(positionListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIcyInfoListener(IcyInfoListener icyInfoListener) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            while (this.icyInfoListeners.contains(icyInfoListener)) {
                this.icyInfoListeners.remove(icyInfoListener);
            }
        }
    }

    @Override
    public synchronized void seek(float f) {
        if (f < 0.0f) {
            f = 0.0f;
        }
        if (f > this.durationInSecs) {
            f = this.durationInSecs;
        }
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doSeek(f);
        }
    }

    @Override
    public void setVolume(int n) {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doSetVolume(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedDisplayResolution(int n, int n2) {
        this.displayWidth = n;
        this.displayHeight = n2;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.receivedDisplayResolution(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedDuration(float f) {
        this.durationInSecsSet = true;
        this.durationInSecs = f;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.receivedDuration(f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receivedVideoResolution(int n, int n2) {
        this.videoWidth = n;
        this.videoHeight = n2;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.receivedVideoResolution(n, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foundAudioTrack(Language language) {
        List<Object> list = this.audioTracks;
        synchronized (list) {
            this.audioTracks.add(language);
        }
        list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.foundAudioTrack(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void foundSubtitle(Language language) {
        List<Object> list = this.subtitles;
        synchronized (list) {
            this.subtitles.add(language);
        }
        list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.foundSubtitle(language);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeAudioTrackChanged(String string) {
        this.activeAudioTrackId = string;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.activeAudioTrackChanged(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeSubtitleChanged(String string, LanguageSource languageSource) {
        this.activeSubtitleId = string;
        this.activeSubtitleSource = languageSource;
        List<MetaDataListener> list = this.metaDataListeners;
        synchronized (list) {
            for (MetaDataListener metaDataListener : this.metaDataListeners) {
                metaDataListener.activeSubtitleChanged(string, languageSource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language getSubtitleByIdAndSource(String string, LanguageSource languageSource) {
        if (string == null) {
            return null;
        }
        List<Language> list = this.subtitles;
        synchronized (list) {
            for (Language language : this.subtitles) {
                if (language.id == null || !language.id.equals(string) || language.source != languageSource) continue;
                return language;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stateChanged(MediaPlaybackState mediaPlaybackState) {
        this.currentState = mediaPlaybackState;
        List<StateListener> list = this.stateListeners;
        synchronized (list) {
            for (StateListener stateListener : this.stateListeners) {
                stateListener.stateChanged(mediaPlaybackState);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void volumeChanged(int n) {
        this.currentVolume = n;
        List<VolumeListener> list = this.volumeListeners;
        synchronized (list) {
            for (VolumeListener volumeListener : this.volumeListeners) {
                volumeListener.volumeChanged(n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void positionChanged(float f) {
        if (this.currentPositionInSecs != f) {
            this.currentPositionInSecs = f;
            List<PositionListener> list = this.positionListeners;
            synchronized (list) {
                for (PositionListener positionListener : this.positionListeners) {
                    positionListener.positionChanged(f);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newIcyInfoData(String string) {
        List<IcyInfoListener> list = this.icyInfoListeners;
        synchronized (list) {
            for (IcyInfoListener icyInfoListener : this.icyInfoListeners) {
                icyInfoListener.newIcyInfoData(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaskListener(TaskListener taskListener) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            this.taskListeners.add(taskListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTaskListener(TaskListener taskListener) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            while (this.taskListeners.contains(taskListener)) {
                this.taskListeners.remove(taskListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskStarted(String string) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener taskListener : this.taskListeners) {
                taskListener.taskStarted(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskProgress(String string, int n) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener taskListener : this.taskListeners) {
                taskListener.taskProgress(string, n);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void taskEnded(String string) {
        List<TaskListener> list = this.taskListeners;
        synchronized (list) {
            for (TaskListener taskListener : this.taskListeners) {
                taskListener.taskEnded(string);
            }
        }
    }

    @Override
    public void stop() {
        if (this.currentState == MediaPlaybackState.Playing || this.currentState == MediaPlaybackState.Paused) {
            this.doStop();
        }
    }

    @Override
    public MediaPlaybackState getCurrentState() {
        return this.currentState;
    }

    @Override
    public int getVolume() {
        return this.currentVolume;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    @Override
    public float getPositionInSecs() {
        return this.currentPositionInSecs;
    }

    public void clearDurationInSecs() {
        this.durationInSecs = 0.0f;
        this.durationInSecsSet = false;
    }

    public void setDurationInSecs(float f) {
        if (!this.durationInSecsSet) {
            this.durationInSecs = f;
        }
    }

    @Override
    public float getDurationInSecs() {
        return this.durationInSecs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language[] getAudioTracks() {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        List<Language> list = this.audioTracks;
        synchronized (list) {
            for (Language language : this.audioTracks) {
                arrayList.add(language);
            }
        }
        return arrayList.toArray(new Language[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Language[] getSubtitles() {
        ArrayList<Language> arrayList = new ArrayList<Language>();
        List<Language> list = this.subtitles;
        synchronized (list) {
            for (Language language : this.subtitles) {
                arrayList.add(language);
            }
        }
        return arrayList.toArray(new Language[arrayList.size()]);
    }

    public String getActiveAudioTrackId() {
        return this.activeAudioTrackId;
    }

    public String getActiveSubtitleId() {
        return this.activeSubtitleId;
    }

    public Language getActiveSubtitle() {
        return this.getSubtitleByIdAndSource(this.activeSubtitleId, this.activeSubtitleSource);
    }
}

