/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mplayer;

import com.frostwire.mplayer.BaseMediaPlayer;
import com.frostwire.mplayer.IcyInfoListener;
import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.MPlayerInstance;
import com.frostwire.mplayer.MediaPlaybackState;
import com.frostwire.mplayer.MetaDataListener;
import com.frostwire.mplayer.PlayerPreferences;
import com.frostwire.mplayer.PositionListener;
import com.frostwire.mplayer.StateListener;
import com.frostwire.mplayer.VolumeListener;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;

public class MPlayer
extends BaseMediaPlayer {
    private List<String> output = new LinkedList<String>();
    private volatile boolean disposed = false;
    private Thread outputParser = new Thread("MPlayer output parser"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block7: while (true) {
                try {
                    while (!MPlayer.this.disposed) {
                        String string = null;
                        List list = MPlayer.this.output;
                        synchronized (list) {
                            if (!MPlayer.this.output.isEmpty()) {
                                string = (String)MPlayer.this.output.remove(0);
                            } else {
                                MPlayer.this.output.wait();
                            }
                        }
                        if (string == null) continue;
                        try {
                            MPlayer.this.parseOutput(string);
                            continue block7;
                        }
                        catch (Throwable throwable) {
                            Debug.out(throwable);
                        }
                    }
                    break;
                }
                catch (Throwable throwable) {
                    Debug.out(throwable);
                    break;
                }
            }
        }
    };
    private boolean firstLengthReceived = false;
    private boolean firstVolumeReceived = false;
    private static final String ANS_LENGTH = "ANS_LENGTH=";
    private static final String ANS_POSITION = "ANS_TIME_POSITION=";
    private static final String ANS_VOLUME = "ANS_VOLUME=";
    private static final String ANS_SUB = "ANS_SUB=";
    private static final String ANS_WIDTH = "ANS_WIDTH=";
    private static final String ANS_HEIGHT = "ANS_HEIGHT=";
    private static final String ANS_ASPECT = "ANS_ASPECT=";
    private static final String ID_VIDEO_ASPECT = "ID_VIDEO_ASPECT=";
    private static final String ID_AUDIO_ID = "ID_AUDIO_ID=";
    private static final String ID_SUBTITLE_ID = "ID_SUBTITLE_ID=";
    private static final String ID_AUDIO_TRACK = "ID_AUDIO_TRACK=";
    private static final String ID_SUBTITLE_TRACK = "ID_SUBTITLE_TRACK=";
    private static final String ID_FILE_SUB_ID = "ID_FILE_SUB_ID=";
    private static final String ID_FILE_SUB_FILENAME = "ID_FILE_SUB_FILENAME=";
    private static final String ID_EXIT = "ID_EXIT=";
    private static final String ICY_INFO = "ICY Info:";
    private static final Pattern v_timeInfo = Pattern.compile("A:\\s*([0-9\\.]+) V:\\s*[0-9\\.]* .*");
    private static final Pattern a_timeInfo = Pattern.compile("A:\\s*([0-9\\.]+) .*");
    private MPlayerInstance current_instance;
    private boolean parsingLanguage;
    private boolean isAudioTrack;
    private Language language;
    private int width;
    private float aspect;
    private MetaDataListener metaDataListener;
    private StateListener stateListener;
    private VolumeListener volumeListener;
    private PositionListener positionListener;
    private IcyInfoListener icyInfoListener;

    public static void initialise(File file) {
        MPlayerInstance.initialise(file);
    }

    public MPlayer() {
        this(null);
    }

    public MPlayer(PlayerPreferences playerPreferences) {
        super(playerPreferences);
        this.outputParser.setDaemon(true);
        this.outputParser.start();
    }

    private void parseOutput(String string) {
        boolean bl;
        block86: {
            bl = false;
            Matcher matcher = v_timeInfo.matcher(string);
            Matcher matcher2 = a_timeInfo.matcher(string);
            if (matcher.matches()) {
                float f = Float.parseFloat(matcher.group(1));
                MPlayerInstance mPlayerInstance = this.getCurrentInstance();
                if (mPlayerInstance != null) {
                    mPlayerInstance.positioned(f);
                }
                this.reportPosition(f);
            } else if (matcher2.matches()) {
                float f = Float.parseFloat(matcher2.group(1));
                MPlayerInstance mPlayerInstance = this.getCurrentInstance();
                if (mPlayerInstance != null) {
                    mPlayerInstance.positioned(f);
                }
                this.reportPosition(f);
            } else if (!string.startsWith("VIDEO:")) {
                if (string.startsWith("Starting playback...")) {
                    this.stateListener.stateChanged(MediaPlaybackState.Playing);
                    MPlayerInstance mPlayerInstance = this.getCurrentInstance();
                    if (mPlayerInstance != null) {
                        mPlayerInstance.initialised();
                    }
                    this.reportNewState(MediaPlaybackState.Playing);
                } else if (string.startsWith(ANS_POSITION)) {
                    try {
                        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
                        if (mPlayerInstance != null) {
                            mPlayerInstance.positioned();
                        }
                        float f = Float.parseFloat(string.substring(ANS_POSITION.length()));
                        this.reportPosition(f);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (string.startsWith(ANS_LENGTH)) {
                    try {
                        float f = Float.parseFloat(string.substring(ANS_LENGTH.length()));
                        if (!this.firstLengthReceived) {
                            float f2;
                            this.firstLengthReceived = true;
                            if (this.preferences != null && (f2 = this.preferences.getPositionForFile(this.getOpenedFile()) - 2.0f) > 0.0f && (double)f2 < 0.99 * (double)f && f2 < f - 20.0f) {
                                this.doSeek(f2);
                            }
                        }
                        this.reportDuration(f);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (string.startsWith(ANS_VOLUME)) {
                    try {
                        int n = (int)Float.parseFloat(string.substring(ANS_VOLUME.length()));
                        this.reportVolume(n);
                        if (this.firstVolumeReceived) break block86;
                        this.firstVolumeReceived = true;
                        if (this.preferences != null && this.preferences.getVolume() != n) {
                            this.setVolume(this.preferences.getVolume());
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (!string.startsWith(ID_VIDEO_ASPECT)) {
                    if (string.startsWith(ANS_WIDTH)) {
                        try {
                            this.width = Integer.parseInt(string.substring(ANS_WIDTH.length()));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ANS_HEIGHT)) {
                        try {
                            int n = this.width;
                            int n2 = Integer.parseInt(string.substring(ANS_HEIGHT.length()));
                            int n3 = n;
                            int n4 = n2;
                            if (this.aspect > 0.0f && this.abs(this.aspect - (float)n / (float)n2) > 0.1) {
                                n3 = (int)((float)n4 * this.aspect);
                            }
                            if (this.metaDataListener != null) {
                                this.metaDataListener.receivedVideoResolution(n, n2);
                                this.metaDataListener.receivedDisplayResolution(n3, n4);
                            }
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ANS_ASPECT)) {
                        try {
                            this.aspect = Float.parseFloat(string.substring(ANS_ASPECT.length()));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ID_AUDIO_ID)) {
                        this.reportParsingDone();
                        try {
                            String string2 = string.substring(ID_AUDIO_ID.length());
                            this.language = new Language(LanguageSource.STREAM, "" + string2);
                            this.parsingLanguage = true;
                            this.isAudioTrack = true;
                            bl = true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ID_SUBTITLE_ID)) {
                        this.reportParsingDone();
                        try {
                            String string3 = string.substring(ID_SUBTITLE_ID.length());
                            this.language = new Language(LanguageSource.STREAM, "" + string3);
                            this.parsingLanguage = true;
                            this.isAudioTrack = false;
                            bl = true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ID_FILE_SUB_ID)) {
                        this.reportParsingDone();
                        try {
                            String string4 = string.substring(ID_FILE_SUB_ID.length());
                            this.language = new Language(LanguageSource.FILE, "" + string4);
                            this.parsingLanguage = true;
                            this.isAudioTrack = false;
                            bl = true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (this.parsingLanguage && string.startsWith(ID_FILE_SUB_FILENAME)) {
                        try {
                            String string5 = string.substring(ID_FILE_SUB_FILENAME.length());
                            try {
                                File file = new File(string5);
                                this.language.setSourceInfo(file.getAbsolutePath());
                                string5 = file.getName();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                            this.language.setName(string5);
                            bl = false;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (this.parsingLanguage && (string.startsWith("ID_AID_" + this.language.getId() + "_NAME=") || string.startsWith("ID_SID_" + this.language.getId() + "_NAME="))) {
                        String string6 = "ID_AID_" + this.language.getId() + "_NAME=";
                        String string7 = string.substring(string6.length());
                        this.language.setName(string7);
                        bl = true;
                    } else if (this.parsingLanguage && (string.startsWith("ID_AID_" + this.language.getId() + "_LANG=") || string.startsWith("ID_SID_" + this.language.getId() + "_LANG="))) {
                        String string8 = "ID_AID_" + this.language.getId() + "_LANG=";
                        String string9 = string.substring(string8.length());
                        this.language.setLanguage(string9);
                        bl = true;
                    } else if (this.parsingLanguage && (string.startsWith("ID_AID_" + this.language.getId()) || string.startsWith("ID_SID_" + this.language.getId()))) {
                        bl = true;
                    } else if (string.startsWith(ID_AUDIO_TRACK)) {
                        try {
                            String string10 = string.substring(ID_AUDIO_TRACK.length());
                            this.reportAudioTrackChanged(string10);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ID_SUBTITLE_TRACK)) {
                        try {
                            String string11 = string.substring(ID_SUBTITLE_TRACK.length());
                            this.reportSubtitleChanged(string11, LanguageSource.STREAM);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith(ANS_SUB)) {
                        try {
                            String string12 = string.substring(ANS_SUB.length());
                            this.reportSubtitleChanged(string12, LanguageSource.STREAM);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (string.startsWith("VDecoder init failed")) {
                        MediaPlaybackState.Failed.setDetails(MessageText.getString("azemp.failed.nocodec"));
                        this.reportNewState(MediaPlaybackState.Failed);
                    } else if (string.startsWith("<vo_direct3d>Reading display capabilities failed")) {
                        MediaPlaybackState.Failed.setDetails(MessageText.getString("azemp.failed.d3dbad"));
                        this.reportNewState(MediaPlaybackState.Failed);
                    } else if (string.startsWith(ID_EXIT)) {
                        this.reportNewState(MediaPlaybackState.Closed);
                    } else if (string.startsWith(ICY_INFO)) {
                        String string13 = string.substring(ICY_INFO.length()).trim();
                        this.reportIcyInfo(string13);
                    }
                }
            }
        }
        if (this.parsingLanguage && !bl) {
            Language language = this.language;
            this.reportParsingDone();
            MPlayerInstance mPlayerInstance = this.getCurrentInstance();
            if (mPlayerInstance != null && mPlayerInstance.activateNextSubtitleLoaded) {
                mPlayerInstance.activateNextSubtitleLoaded = false;
                this.setSubtitles(language);
            }
        }
    }

    private double abs(float f) {
        return f > 0.0f ? (double)f : (double)(-f);
    }

    @Override
    public void doLoadSubtitlesFile(String string, boolean bl) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doLoadSubtitlesFile(string, bl);
        }
    }

    public void showMessage(String string, int n) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.sendCommand("osd_show_text \"" + string + "\" " + n + " " + 0);
        }
    }

    private void reportSubtitleChanged(String string, LanguageSource languageSource) {
        if (this.metaDataListener != null) {
            this.metaDataListener.activeSubtitleChanged(string, languageSource);
        }
    }

    private void reportAudioTrackChanged(String string) {
        if (this.metaDataListener != null) {
            this.metaDataListener.activeAudioTrackChanged(string);
        }
    }

    private void reportParsingDone() {
        if (this.parsingLanguage) {
            if (this.isAudioTrack) {
                this.reportFoundAudioTrack(this.language);
            } else {
                this.reportFoundSubtitle(this.language);
            }
            this.language = null;
            this.parsingLanguage = false;
            this.isAudioTrack = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doOpen(String string) {
        MPlayerInstance mPlayerInstance;
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            this.doStop(false);
            mPlayerInstance = this.current_instance = new MPlayerInstance(this.preferences);
        }
        this.reportNewState(MediaPlaybackState.Opening);
        this.firstLengthReceived = false;
        this.firstVolumeReceived = false;
        mPlayerInstance.doOpen(string, new MPlayerInstance.OutputConsumer(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void consume(String string) {
                List list = MPlayer.this.output;
                synchronized (list) {
                    MPlayer.this.output.add(string);
                    MPlayer.this.output.notifyAll();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MPlayerInstance getCurrentInstance() {
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            return this.current_instance;
        }
    }

    @Override
    public void doPause() {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doPause();
        }
        this.reportNewState(MediaPlaybackState.Paused);
    }

    @Override
    public void doResume() {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doResume();
        }
        this.reportNewState(MediaPlaybackState.Playing);
    }

    @Override
    public void doSeek(float f) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doSeek(f);
        }
    }

    @Override
    public void doSetVolume(int n) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doSetVolume(n);
        }
        this.reportVolume(n);
    }

    @Override
    public void mute(boolean bl) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doMute(bl);
        }
    }

    public void doRedraw() {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.doRedraw();
        }
    }

    public void setAudioTrack(Language language) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            mPlayerInstance.setAudioTrack(language);
        }
    }

    public void setSubtitles(Language language) {
        MPlayerInstance mPlayerInstance = this.getCurrentInstance();
        if (mPlayerInstance != null) {
            this.reportSubtitleChanged(mPlayerInstance.setSubtitles(language), language != null ? language.getSource() : null);
        }
    }

    @Override
    public void doStop() {
        this.doStop(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop(boolean bl) {
        MPlayer mPlayer = this;
        synchronized (mPlayer) {
            if (this.current_instance != null) {
                if (this.preferences != null) {
                    this.preferences.setPositionForFile(this.getOpenedFile(), this.getPositionInSecs());
                }
                this.current_instance.doStop();
                this.current_instance = null;
            }
            List<String> list = this.output;
            synchronized (list) {
                this.output.clear();
                this.output.notifyAll();
            }
        }
        if (bl) {
            this.reportNewState(MediaPlaybackState.Stopped);
        }
    }

    @Override
    public void setMetaDataListener(MetaDataListener metaDataListener) {
        this.metaDataListener = metaDataListener;
    }

    @Override
    public void setStateListener(StateListener stateListener) {
        this.stateListener = stateListener;
    }

    @Override
    public void setVolumeListener(VolumeListener volumeListener) {
        this.volumeListener = volumeListener;
    }

    @Override
    public void setPositionListener(PositionListener positionListener) {
        this.positionListener = positionListener;
    }

    @Override
    public void setIcyInfoListener(IcyInfoListener icyInfoListener) {
        this.icyInfoListener = icyInfoListener;
    }

    private void reportPosition(float f) {
        if (this.positionListener != null) {
            this.positionListener.positionChanged(f);
        }
    }

    private void reportVolume(int n) {
        if (this.volumeListener != null) {
            this.volumeListener.volumeChanged(n);
        }
    }

    private void reportDuration(float f) {
        if (this.metaDataListener != null) {
            this.metaDataListener.receivedDuration(f);
        }
    }

    private void reportFoundAudioTrack(Language language) {
        if (this.metaDataListener != null) {
            this.metaDataListener.foundAudioTrack(language);
        }
    }

    private void reportFoundSubtitle(Language language) {
        if (this.metaDataListener != null) {
            this.metaDataListener.foundSubtitle(language);
        }
    }

    private void reportNewState(MediaPlaybackState mediaPlaybackState) {
        if (this.stateListener != null) {
            this.stateListener.stateChanged(mediaPlaybackState);
        }
    }

    private void reportIcyInfo(String string) {
        if (this.icyInfoListener != null) {
            this.icyInfoListener.newIcyInfoData(string);
        }
    }

    public void dispose() {
        this.disposed = true;
        this.doStop();
    }

    @Override
    public Map<String, String> getProperties(String string) {
        MPlayerInstance mPlayerInstance = new MPlayerInstance(null);
        final HashMap<String, String> hashMap = new HashMap<String, String>();
        mPlayerInstance.doGetProperties(string, new MPlayerInstance.OutputConsumer(){
            private String lastKey = null;

            @Override
            public void consume(String string) {
                if (string.split("=").length < 2) {
                    return;
                }
                if (string.startsWith("ID_CLIP_INFO_NAME")) {
                    this.lastKey = string.split("=")[1];
                } else if (string.startsWith("ID_CLIP_INFO_VALUE")) {
                    if (this.lastKey != null) {
                        hashMap.put(this.lastKey, string.split("=")[1]);
                        this.lastKey = null;
                    }
                } else if (string.startsWith("ID_")) {
                    String[] stringArray = string.split("=");
                    hashMap.put(stringArray[0], stringArray[1]);
                }
            }
        });
        return hashMap;
    }
}

