/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.mplayer;

import com.frostwire.mplayer.Language;
import com.frostwire.mplayer.LanguageSource;
import com.frostwire.mplayer.PlayerPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.gudy.azureus2.core3.util.AESemaphore;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;

public class MPlayerInstance {
    private static final boolean LOG = false;
    private static File BINARY_PATH;
    private volatile Process mPlayerProcess;
    private boolean starting;
    private boolean started;
    private boolean stop_pending;
    private boolean stopped;
    private AESemaphore stop_sem = new AESemaphore("EMP:S");
    private boolean paused;
    private List<String> commands = new LinkedList<String>();
    private AESemaphore command_sem = new AESemaphore("EMP:C");
    private boolean isSeeking;
    private int seekingTo;
    private volatile long seekingSendTime;
    private float nextSeek = -1.0f;
    private int pause_change_id_next;
    private boolean pause_reported;
    private long pause_reported_time = -1L;
    private int pending_sleeps;
    private int mute_count;
    private boolean redrawing;
    private long redraw_completion;
    private long redraw_last_frame;
    public volatile boolean activateNextSubtitleLoaded = false;

    public static void initialise(File file) {
        BINARY_PATH = file;
        MPlayerInstance.killProcesses(false);
    }

    public MPlayerInstance(PlayerPreferences playerPreferences) {
    }

    public static void setBinaryPath(String string) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doOpen(String string, final OutputConsumer outputConsumer) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            if (this.starting || this.started) {
                throw new RuntimeException("no can do");
            }
            this.starting = true;
        }
        object2 = new OutputConsumer(){
            boolean latest = false;

            @Override
            public void consume(String string) {
                boolean bl = string.startsWith("ID_PAUSED");
                if (bl != this.latest) {
                    MPlayerInstance.this.updateObservedPaused(bl);
                    this.latest = bl;
                }
                outputConsumer.consume(string);
            }
        };
        try {
            object = new ArrayList<String>();
            object.add(BINARY_PATH.getAbsolutePath());
            object.add("-slave");
            object.add("-identify");
            object.add("-prefer-ipv4");
            object.add("-osdlevel");
            object.add("0");
            object.add("-noautosub");
            object.add(string);
            String[] stringArray = object.toArray(new String[object.size()]);
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                this.mPlayerProcess = processBuilder.start();
                InputStream inputStream = this.mPlayerProcess.getInputStream();
                InputStream inputStream2 = this.mPlayerProcess.getErrorStream();
                OutputStream outputStream = this.mPlayerProcess.getOutputStream();
                final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
                final BufferedReader bufferedReader2 = new BufferedReader(new InputStreamReader(inputStream2));
                final PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
                Thread thread = new Thread("Player Console Out Reader", (OutputConsumer)object2){
                    final /* synthetic */ OutputConsumer val$output_consumer;
                    {
                        this.val$output_consumer = outputConsumer;
                        super(string);
                    }

                    @Override
                    public void run() {
                        try {
                            String string;
                            while ((string = bufferedReader.readLine()) != null) {
                                this.val$output_consumer.consume(string);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                thread.setDaemon(true);
                thread.start();
                Thread thread2 = new Thread("Player Console Err Reader", (OutputConsumer)object2){
                    final /* synthetic */ OutputConsumer val$output_consumer;
                    {
                        this.val$output_consumer = outputConsumer;
                        super(string);
                    }

                    @Override
                    public void run() {
                        try {
                            String string;
                            while ((string = bufferedReader2.readLine()) != null) {
                                this.val$output_consumer.consume(string);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
                thread2.setDaemon(true);
                thread2.start();
                Thread thread3 = new Thread("Player Console In Writer"){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            while (true) {
                                String string;
                                MPlayerInstance.this.command_sem.reserve();
                                MPlayerInstance mPlayerInstance = MPlayerInstance.this;
                                synchronized (mPlayerInstance) {
                                    if (MPlayerInstance.this.commands.isEmpty()) {
                                        break;
                                    }
                                    string = (String)MPlayerInstance.this.commands.remove(0);
                                }
                                if (string.startsWith("sleep ") || string.startsWith("pausing_keep_force sleep ")) {
                                    int n = Integer.parseInt(string.substring(string.startsWith("p") ? 25 : 6));
                                    try {
                                        Thread.sleep(n);
                                    }
                                    catch (Throwable throwable) {
                                        // empty catch block
                                    }
                                    MPlayerInstance mPlayerInstance2 = MPlayerInstance.this;
                                    synchronized (mPlayerInstance2) {
                                        MPlayerInstance.this.pending_sleeps -= n;
                                    }
                                }
                                if (string.startsWith("seek") || string.startsWith("pausing_keep_force seek")) {
                                    MPlayerInstance.this.seekingSendTime = SystemTime.getMonotonousTime();
                                }
                                string = string.replaceAll("\\\\", "\\\\\\\\");
                                printWriter.write(string + "\n");
                                printWriter.flush();
                            }
                        }
                        catch (Throwable throwable) {
                            throwable.printStackTrace();
                        }
                        finally {
                            MPlayerInstance.this.stop_sem.releaseForever();
                        }
                    }
                };
                thread3.setDaemon(true);
                thread3.start();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                this.stop_sem.releaseForever();
            }
        }
        finally {
            object = this;
            synchronized (object) {
                this.starting = false;
                this.started = true;
                if (this.stop_pending) {
                    this.doStop();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendCommand(String string, boolean bl) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.stopped) {
                return;
            }
            this.commands.add((bl && this.paused ? "pausing_keep_force " : "") + string);
            this.command_sem.release();
        }
    }

    protected void sendCommand(String string) {
        this.sendCommand(string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialised() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.sendCommand("get_property LENGTH");
            this.sendCommand("get_property SUB");
            this.sendCommand("get_property ASPECT");
            this.sendCommand("get_property WIDTH");
            this.sendCommand("get_property HEIGHT");
            this.sendCommand("get_property VOLUME");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateObservedPaused(boolean bl) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.pause_reported = bl;
            this.pause_reported_time = SystemTime.getMonotonousTime();
        }
    }

    private void pausedStateChanging() {
        this.pause_reported_time = -1L;
        final int n = ++this.pause_change_id_next;
        SimpleTimer.addEvent("MP:PO", SystemTime.getOffsetTime(333 + this.pending_sleeps), new TimerEventPerformer(){
            int level = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform(TimerEvent timerEvent) {
                MPlayerInstance mPlayerInstance = MPlayerInstance.this;
                synchronized (mPlayerInstance) {
                    if (!MPlayerInstance.this.stopped && n == MPlayerInstance.this.pause_change_id_next && this.level < 20) {
                        ++this.level;
                        if (MPlayerInstance.this.pause_reported_time >= 0L && MPlayerInstance.this.pause_reported == MPlayerInstance.this.paused) {
                            return;
                        }
                        MPlayerInstance.this.sendCommand("pause", false);
                        SimpleTimer.addEvent("MP:PO2", SystemTime.getOffsetTime(333 + MPlayerInstance.this.pending_sleeps), this);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doPause() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.paused) {
                return false;
            }
            this.paused = true;
            this.pausedStateChanging();
            this.sendCommand("pause", false);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doResume() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (!this.paused) {
                return false;
            }
            this.paused = false;
            this.pausedStateChanging();
            this.sendCommand("pause", false);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSeek(float f) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.isSeeking) {
                this.nextSeek = f;
            } else {
                int n;
                this.isSeeking = true;
                this.nextSeek = -1.0f;
                this.seekingTo = n = (int)f;
                this.seekingSendTime = -1L;
                this.sendCommand("seek " + n + " 2");
                if (this.paused) {
                    this.sendCommand("frame_step", false);
                }
                this.sendCommand("get_time_pos");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void positioned(float f) {
        long l = SystemTime.getMonotonousTime();
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.seekingSendTime == -1L) {
                return;
            }
            if (this.isSeeking && f >= (float)this.seekingTo && (l - this.seekingSendTime > 1000L || f - (float)this.seekingTo <= 2.0f)) {
                this.positioned();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void positioned() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.isSeeking) {
                this.isSeeking = false;
                this.seekingSendTime = -1L;
                if (this.nextSeek != -1.0f) {
                    this.doSeek(this.nextSeek);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSetVolume(int n) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.sendCommand("volume " + n + " 1");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doMute(boolean bl) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (bl) {
                ++this.mute_count;
                if (this.mute_count == 1) {
                    this.sendCommand("mute 1");
                }
            } else {
                --this.mute_count;
                if (this.mute_count == 0) {
                    if (this.paused) {
                        this.nextSeek = -1.0f;
                        this.pending_sleeps += 100;
                        this.sendCommand("sleep 100");
                    }
                    this.sendCommand("mute 0");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAudioTrack(Language language) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (language != null) {
                this.sendCommand("switch_audio " + language.getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRedraw() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            long l = SystemTime.getMonotonousTime();
            this.redraw_completion = l + 250L;
            if (this.redrawing) {
                if (l - this.redraw_last_frame > 250L) {
                    this.redraw_last_frame = l;
                    this.sendCommand("frame_step", false);
                }
            } else {
                this.doMute(true);
                this.redraw_last_frame = l;
                this.sendCommand("frame_step", false);
                this.redrawing = true;
                SimpleTimer.addEvent("MP:RD", SystemTime.getOffsetTime(250L), new TimerEventPerformer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void perform(TimerEvent timerEvent) {
                        MPlayerInstance mPlayerInstance = MPlayerInstance.this;
                        synchronized (mPlayerInstance) {
                            long l = SystemTime.getMonotonousTime();
                            long l2 = MPlayerInstance.this.redraw_completion - l;
                            if (l2 < 0L || Math.abs(l2) <= 25L) {
                                MPlayerInstance.this.redrawing = false;
                                MPlayerInstance.this.doMute(false);
                            } else {
                                SimpleTimer.addEvent("MP:RD", SystemTime.getOffsetTime(l2), this);
                            }
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String setSubtitles(Language language) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            String string;
            String string2 = "sub_demux ";
            if (language != null) {
                string = language.getId();
                if (language.getSource() == LanguageSource.FILE) {
                    string2 = "sub_file ";
                }
            } else {
                this.sendCommand("set_property sub_visibility 0");
                return null;
            }
            this.sendCommand("set_property sub_visibility 1");
            this.sendCommand(string2 + string);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLoadSubtitlesFile(String string, boolean bl) {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            this.activateNextSubtitleLoaded = bl;
            this.sendCommand("sub_load \"" + string + "\"");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doStop() {
        MPlayerInstance mPlayerInstance = this;
        synchronized (mPlayerInstance) {
            if (this.starting) {
                this.stop_pending = true;
                return;
            }
            if (this.stopped) {
                return;
            }
            this.sendCommand("stop");
            this.sendCommand("quit 0");
            this.stopped = true;
        }
        this.command_sem.release();
        if (this.mPlayerProcess != null) {
            this.mPlayerProcess.destroy();
        }
        MPlayerInstance.killProcesses(true);
        this.stop_sem.reserve();
    }

    private static void killProcesses(boolean bl) {
        if (Constants.isOSX) {
            String string = BINARY_PATH.getName();
            if (bl) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            MPlayerInstance.runCommand(new String[]{"killall", "-9", string});
        } else if (Constants.isWindows) {
            String string = BINARY_PATH.getName();
            int n = string.lastIndexOf(".");
            if (n != -1) {
                string = string.substring(0, n);
            }
            if (bl) {
                try {
                    Thread.sleep(250L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            MPlayerInstance.runCommand(new String[]{"cmd", "/C", "tskill", string});
        }
    }

    private static void runCommand(String[] stringArray) {
        try {
            if (!Constants.isWindows) {
                stringArray[0] = MPlayerInstance.findCommand(stringArray[0]);
            }
            Runtime.getRuntime().exec(stringArray).waitFor();
        }
        catch (Throwable throwable) {
            Debug.out(throwable);
        }
    }

    private static String findCommand(String string) {
        String[] stringArray;
        for (String string2 : stringArray = new String[]{"/bin", "/usr/bin"}) {
            File file = new File(string2, string);
            if (!file.exists() || !file.canRead()) continue;
            return file.getAbsolutePath();
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGetProperties(String string, final OutputConsumer outputConsumer) {
        final OutputConsumer outputConsumer2 = new OutputConsumer(){

            @Override
            public void consume(String string) {
                outputConsumer.consume(string);
            }
        };
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(BINARY_PATH.getAbsolutePath());
        arrayList.add("-slave");
        arrayList.add("-identify");
        arrayList.add("-prefer-ipv4");
        arrayList.add("-osdlevel");
        arrayList.add("0");
        arrayList.add("-noautosub");
        arrayList.add("-vo");
        arrayList.add("null");
        arrayList.add("-ao");
        arrayList.add("null");
        arrayList.add("-frames");
        arrayList.add("0");
        arrayList.add(string);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        try {
            InputStream inputStream = Runtime.getRuntime().exec(stringArray).getInputStream();
            final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            Thread thread = new Thread("Player Console Out Reader"){

                @Override
                public void run() {
                    try {
                        String string;
                        while ((string = bufferedReader.readLine()) != null) {
                            if (string.startsWith("ID_EXIT")) {
                                countDownLatch.countDown();
                                break;
                            }
                            outputConsumer2.consume(string);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
            countDownLatch.await(5L, TimeUnit.SECONDS);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void printCommand(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].contains(" ")) {
                System.out.print("\"");
            }
            System.out.print(stringArray[i]);
            if (stringArray[i].contains(" ")) {
                System.out.print("\"");
            }
            System.out.print(" ");
        }
        System.out.println("\n");
    }

    protected static interface OutputConsumer {
        public void consume(String var1);
    }
}

