/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.websearch.youtube;

import com.frostwire.HttpFetcher;
import com.frostwire.JsonEngine;
import com.frostwire.bittorrent.websearch.WebSearchPerformer;
import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.websearch.youtube.YouTubeEntry;
import com.frostwire.websearch.youtube.YouTubeResponse;
import com.frostwire.websearch.youtube.YouTubeSearchResult;
import com.limegroup.gnutella.settings.SearchEnginesSettings;
import com.limegroup.gnutella.util.UrlUtils;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;

public class YouTubeSearchPerformer
implements WebSearchPerformer {
    @Override
    public List<WebSearchResult> search(String string) {
        ArrayList<WebSearchResult> arrayList = new ArrayList<WebSearchResult>();
        YouTubeResponse youTubeResponse = this.searchYouTube(string);
        if (youTubeResponse != null && youTubeResponse.feed != null && youTubeResponse.feed.entry != null) {
            for (YouTubeEntry youTubeEntry : youTubeResponse.feed.entry) {
                YouTubeSearchResult youTubeSearchResult = new YouTubeSearchResult(youTubeEntry);
                arrayList.add(youTubeSearchResult);
            }
        }
        return arrayList;
    }

    private YouTubeResponse searchYouTube(String string) {
        String string2 = UrlUtils.encode(string);
        int n = SearchEnginesSettings.YOUTUBE_WEBSEARCHPERFORMER_MAX_RESULTS.getValue();
        String string3 = String.format("https://gdata.youtube.com/feeds/api/videos?q=%s&orderby=relevance&start-index=1&max-results=%d&alt=json&prettyprint=true&v=2", string2, n);
        HttpFetcher httpFetcher = new HttpFetcher(string3, 5000);
        byte[] byArray = httpFetcher.fetch();
        if (byArray == null) {
            return null;
        }
        String string4 = null;
        try {
            string4 = new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string4 = new String(byArray);
        }
        string4 = this.fixJson(string4);
        JsonEngine jsonEngine = new JsonEngine();
        YouTubeResponse youTubeResponse = null;
        try {
            youTubeResponse = jsonEngine.toObject(string4, YouTubeResponse.class);
        }
        catch (Exception exception) {
            return null;
        }
        return youTubeResponse;
    }

    private String fixJson(String string) {
        return string.replace("\"$t\"", "\"title\"").replace("\"yt$userId\"", "\"ytuserId\"");
    }
}

