/*
 * Decompiled with CFR 0.152.
 */
package com.frostwire.websearch.youtube;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.websearch.youtube.YouTubeEntry;
import com.frostwire.websearch.youtube.YouTubeEntryLink;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.limewire.util.FilenameUtils;

public class YouTubeSearchResult
implements WebSearchResult {
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    private final YouTubeEntry entry;
    private final String filename;
    private final long creationTime;
    private final String videoUrl;

    public YouTubeSearchResult(YouTubeEntry youTubeEntry) {
        this.entry = youTubeEntry;
        this.filename = youTubeEntry.title.title + ".youtube";
        this.creationTime = this.readCreationTime(youTubeEntry);
        this.videoUrl = this.readVideoUrl(youTubeEntry);
    }

    public YouTubeEntry getYouTubeEntry() {
        return this.entry;
    }

    @Override
    public String getFileName() {
        return this.filename;
    }

    @Override
    public long getSize() {
        return -1L;
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getSource() {
        if (this.entry.author != null && this.entry.author.size() > 0 && this.entry.author.get((int)0).name != null && this.entry.author.get((int)0).name.title != null) {
            return "YouTube - " + this.entry.author.get((int)0).name.title;
        }
        return "YouTube";
    }

    @Override
    public String getHash() {
        return null;
    }

    @Override
    public String getTorrentURI() {
        return this.videoUrl;
    }

    @Override
    public int getSeeds() {
        return -1;
    }

    @Override
    public String getDetailsUrl() {
        return this.videoUrl;
    }

    private long readCreationTime(YouTubeEntry youTubeEntry) {
        try {
            return DATE_FORMAT.parse(youTubeEntry.published.title.replace("000Z", "")).getTime();
        }
        catch (ParseException parseException) {
            return System.currentTimeMillis();
        }
    }

    private String readVideoUrl(YouTubeEntry youTubeEntry) {
        String string = null;
        for (YouTubeEntryLink youTubeEntryLink : youTubeEntry.link) {
            if (!youTubeEntryLink.rel.equals("alternate")) continue;
            string = youTubeEntryLink.href;
        }
        string = string.replace("https://", "http://").replace("&feature=youtube_gdata", "");
        return string;
    }

    @Override
    public String getDisplayName() {
        return FilenameUtils.getBaseName(this.getFileName());
    }
}

