/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.HttpFetcher;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.MagnetOptions;
import com.limegroup.gnutella.util.UrlUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public class ExternalControl {
    private static final Log LOG = LogFactory.getLog(ExternalControl.class);
    private static ExternalControl INSTANCE;
    private static final String NL = "\r\n";
    private static final String LOCALHOST_IP = "127.0.0.1";
    private static final String LOCALHOST_NAME = "localhost";
    private static final int SERVER_PORT = 45099;
    private boolean initialized = false;
    private volatile String enqueuedRequest = null;
    private final ActivityCallback activityCallback;

    public static ExternalControl instance(ActivityCallback activityCallback) {
        if (INSTANCE == null) {
            INSTANCE = new ExternalControl(activityCallback);
        }
        return INSTANCE;
    }

    private ExternalControl(ActivityCallback activityCallback) {
        this.activityCallback = activityCallback;
    }

    public void startServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServerSocket serverSocket = new ServerSocket(45099, 50, InetAddress.getByName(ExternalControl.LOCALHOST_IP));
                    while (true) {
                        final Socket socket = serverSocket.accept();
                        new Thread(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                boolean bl = true;
                                try {
                                    BufferedReader bufferedReader;
                                    String string;
                                    String string2 = socket.getInetAddress().getHostAddress();
                                    if ((string2.equals(ExternalControl.LOCALHOST_NAME) || string2.equals(ExternalControl.LOCALHOST_IP)) && (string = (bufferedReader = new BufferedReader(new InputStreamReader(socket.getInputStream(), "UTF8"))).readLine()) != null && string.toUpperCase().startsWith("GET ")) {
                                        string = string.substring(4);
                                        int n = string.lastIndexOf(32);
                                        string = string.substring(0, n);
                                        bl = ExternalControl.this.process(string, bufferedReader, socket.getOutputStream());
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                finally {
                                    if (bl) {
                                        try {
                                            socket.close();
                                        }
                                        catch (Exception exception) {}
                                    }
                                }
                            }
                        }).start();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return;
                }
            }
        }).start();
    }

    private boolean process(String string, BufferedReader bufferedReader, OutputStream outputStream) throws IOException {
        String string2;
        Object object;
        String string3;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = string.indexOf(63);
        if (n == -1) {
            string3 = "";
        } else {
            string3 = string.substring(n + 1);
            if ((n = string3.lastIndexOf(32)) >= 0) {
                string3 = string3.substring(0, n).trim();
            }
            object = new StringTokenizer(string3, "&");
            while (((StringTokenizer)object).hasMoreTokens()) {
                String string4;
                string2 = ((StringTokenizer)object).nextToken();
                n = string2.indexOf(61);
                if (n == -1) {
                    string4 = string2.trim();
                    hashMap.put(string4, "");
                    hashMap2.put(string4.toLowerCase(MessageText.LOCALE_ENGLISH), "");
                    continue;
                }
                try {
                    string4 = string2.substring(0, n).trim();
                    String string5 = string4.toLowerCase(MessageText.LOCALE_ENGLISH);
                    String string6 = URLDecoder.decode(string2.substring(n + 1).trim(), "UTF8");
                    hashMap.put(string4, string6);
                    hashMap2.put(string5, string6);
                    if (!string5.equals("xsource")) continue;
                    arrayList.add(string6);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Debug.printStackTrace(unsupportedEncodingException);
                }
            }
        }
        if (string.startsWith("/download")) {
            object = (String)hashMap2.get("info_hash");
            if (object != null) {
                if (this.activityCallback.isRemoteDownloadsAllowed()) {
                    this.writeJSReply(outputStream, "checkResult(1);");
                    this.handleTorrentMagnetRequest("magnet:?xt=urn:btih:" + (String)object + '&' + string3);
                } else {
                    this.writeJSReply(outputStream, "checkResult(0);");
                }
                return true;
            }
            string2 = org.gudy.azureus2.core3.util.UrlUtils.decode((String)hashMap2.get("url"));
            if (!StringUtils.isNullOrEmpty(string2) && this.activityCallback.isRemoteDownloadsAllowed()) {
                if (string2.startsWith("magnet:?")) {
                    this.handleTorrentMagnetRequest(string2);
                } else if (string2.startsWith("file://") || string2.endsWith(".torrent")) {
                    this.handleTorrentRequest(string2);
                }
            }
            this.writeHTTPReply(outputStream, "Running");
            return true;
        }
        if (string.startsWith("/show")) {
            this.writeHTTPReply(outputStream, "Running");
            this.restoreApplication();
            return true;
        }
        this.writeNotFound(outputStream);
        return true;
    }

    protected void writeNotFound(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.0 404 Not Found\r\n\r\n");
        printWriter.flush();
    }

    private void writeJSReply(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.1 200 OK\r\n");
        printWriter.print("Cache-Control: no-cache\r\n");
        printWriter.print("Pragma: no-cache\r\n");
        printWriter.print("Content-Type: text/javascript\r\n");
        printWriter.print("Content-Length: " + string.length() + NL + NL);
        printWriter.write(string);
        printWriter.flush();
    }

    private void writeHTTPReply(OutputStream outputStream, String string) {
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(outputStream));
        printWriter.print("HTTP/1.1 200 OK\r\n");
        printWriter.print("Cache-Control: no-cache\r\n");
        printWriter.print("Pragma: no-cache\r\n");
        printWriter.print("Content-Type: text/plain\r\n");
        printWriter.print("Content-Length: " + string.length() + NL + NL);
        printWriter.write(string);
        printWriter.flush();
    }

    public String preprocessArgs(String[] stringArray) {
        LOG.trace("enter proprocessArgs");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    public void checkForActiveFrostWire() {
        if (this.testForFrostWire(null)) {
            System.exit(0);
        }
    }

    public void checkForActiveFrostWire(String string) {
        if ((OSUtils.isWindows() || OSUtils.isLinux()) && this.testForFrostWire(string)) {
            System.exit(0);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void enqueueControlRequest(String string) {
        LOG.trace("enter enqueueControlRequest");
        this.enqueuedRequest = string;
    }

    public void runQueuedControlRequest() {
        this.initialized = true;
        if (this.enqueuedRequest != null) {
            String string = this.enqueuedRequest;
            this.enqueuedRequest = null;
            if (this.isTorrentMagnetRequest(string)) {
                System.out.println("ExternalControl.runQueuedControlRequest() handleTorrentMagnetRequest() - " + string);
                this.handleTorrentMagnetRequest(string);
            } else if (this.isTorrentRequest(string)) {
                System.out.println("ExternalControl.runQueuedControlRequest() handleTorrentRequest() - " + string);
                this.handleTorrentRequest(string);
            } else {
                System.out.println("ExternalControl.runQueuedControlRequest() handleMagnetRequest() - " + string);
                this.handleMagnetRequest(string);
            }
        }
    }

    private boolean isTorrentMagnetRequest(String string) {
        return string.startsWith("magnet:?xt=urn:btih");
    }

    private void handleTorrentMagnetRequest(String string) {
        ActivityCallback activityCallback = this.restoreApplication();
        System.out.println("handleTorrentMagnetRequest restored application. About to callback.handleTorrentMagnet()");
        activityCallback.handleTorrentMagnet(string, true);
    }

    private boolean isTorrentRequest(String string) {
        if (string == null) {
            return false;
        }
        return (string = string.trim().toLowerCase()).endsWith(".torrent") && !string.startsWith("magnet:");
    }

    public void handleMagnetRequest(String string) {
        LOG.trace("enter handleMagnetRequest");
        if (this.isTorrentMagnetRequest(string)) {
            System.out.println("ExternalControl.handleMagnetRequest(" + string + ") -> handleTorrentMagnetRequest()");
            this.handleTorrentMagnetRequest(string);
            return;
        }
        MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnet(string);
        if (magnetOptionsArray.length == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Invalid magnet, ignoring: " + string);
            }
            return;
        }
    }

    private ActivityCallback restoreApplication() {
        this.activityCallback.restoreApplication();
        this.activityCallback.showDownloads();
        return this.activityCallback;
    }

    private void handleTorrentRequest(String string) {
        LOG.trace("enter handleTorrentRequest");
        ActivityCallback activityCallback = this.restoreApplication();
        File file = new File(string.trim());
        activityCallback.handleTorrent(file);
    }

    private boolean testForFrostWire(String string) {
        try {
            System.out.println("testForFrostWire(arg = [" + string + "])");
            String string2 = null;
            string2 = string != null && (string.startsWith("http://") || string.startsWith("https://") || string.startsWith("magnet:?") || string.endsWith(".torrent")) ? "/download?url=" + UrlUtils.encode(string) : "/show";
            System.out.println("urlParameter = " + string2);
            HttpFetcher httpFetcher = new HttpFetcher(new URI("http://127.0.0.1:45099" + string2), 1000);
            if (httpFetcher.fetch() != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

