/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnSet;
import java.io.File;
import java.util.Collections;
import java.util.Set;
import org.limewire.util.I18NConvert;
import org.limewire.util.StringLookup;

public class FileDesc
implements StringLookup {
    private final int _index;
    private final String _path;
    private final String _name;
    private final long _size;
    private long _modTime;
    private volatile Set<URN> URNS;
    private final File FILE;
    private final URN SHA1_URN;
    private int _hits;
    private int _attemptedUploads;
    private long lastAttemptedUploadTime = System.currentTimeMillis();
    private int _completedUploads;

    protected FileDesc() {
        this.SHA1_URN = null;
        this._size = -1L;
        this._name = null;
        this.FILE = null;
        this._index = -1;
        this.URNS = null;
        this._path = null;
    }

    public FileDesc(File file, Set<? extends URN> set, int n) {
        if (file == null) {
            throw new NullPointerException("cannot create a FileDesc with a null File");
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("negative index (" + n + ") not permitted in FileDesc");
        }
        if (set == null) {
            throw new NullPointerException("cannot create a FileDesc with a null URN Set");
        }
        this.FILE = file;
        this._index = n;
        this._name = I18NConvert.instance().compose(this.FILE.getName());
        this._path = this.FILE.getAbsolutePath();
        this._size = this.FILE.length();
        assert (this._size >= 0L && this._size <= 0xFFFFFFFFFFL) : "invalid size " + this._size + " of file " + this.FILE;
        this._modTime = this.FILE.lastModified();
        this.URNS = Collections.unmodifiableSet(set);
        this.SHA1_URN = this.extractSHA1();
        if (this.SHA1_URN == null) {
            throw new IllegalArgumentException("no SHA1 URN");
        }
        this._hits = 0;
    }

    public boolean hasUrns() {
        return !this.URNS.isEmpty();
    }

    public int getIndex() {
        return this._index;
    }

    public long getFileSize() {
        return this._size;
    }

    public String getFileName() {
        return this._name;
    }

    public long lastModified() {
        return this._modTime;
    }

    private URN extractSHA1() {
        for (URN uRN : this.URNS) {
            if (!uRN.isSHA1()) continue;
            return uRN;
        }
        return null;
    }

    public URN getTTROOTUrn() {
        for (URN uRN : this.URNS) {
            if (!uRN.isTTRoot()) continue;
            return uRN;
        }
        return null;
    }

    public File getFile() {
        return this.FILE;
    }

    public URN getSHA1Urn() {
        return this.SHA1_URN;
    }

    public boolean setTTRoot(URN uRN) {
        boolean bl = !this.getUrns().contains(uRN);
        UrnSet urnSet = new UrnSet();
        urnSet.add(this.SHA1_URN);
        urnSet.add(uRN);
        this.URNS = Collections.unmodifiableSet(urnSet);
        return bl;
    }

    public Set<URN> getUrns() {
        return this.URNS;
    }

    public String getPath() {
        return this.FILE.getAbsolutePath();
    }

    public boolean containsUrn(URN uRN) {
        return this.URNS.contains(uRN);
    }

    public int incrementHitCount() {
        return ++this._hits;
    }

    public int getHitCount() {
        return this._hits;
    }

    public synchronized int incrementAttemptedUploads() {
        this.lastAttemptedUploadTime = System.currentTimeMillis();
        return ++this._attemptedUploads;
    }

    public synchronized int getAttemptedUploads() {
        return this._attemptedUploads;
    }

    public synchronized long getLastAttemptedUploadTime() {
        return this.lastAttemptedUploadTime;
    }

    public int incrementCompletedUploads() {
        return ++this._completedUploads;
    }

    public int getCompletedUploads() {
        return this._completedUploads;
    }

    public String toString() {
        return "FileDesc:\r\nname:     " + this._name + "\r\n" + "index:    " + this._index + "\r\n" + "path:     " + this._path + "\r\n" + "size:     " + this._size + "\r\n" + "modTime:  " + this._modTime + "\r\n" + "File:     " + this.FILE + "\r\n" + "urns:     " + this.URNS + "\r\n";
    }

    @Override
    public String lookup(String string) {
        return null;
    }
}

