/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.frostwire.AzureusStarter;
import com.limegroup.gnutella.LifecycleManager;
import com.limegroup.gnutella.LimeCoreGlue;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.lifecycle.ServiceRegistry;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.service.ErrorService;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class LifecycleManagerImpl
implements LifecycleManager {
    private static final Log LOG = LogFactory.getLog(LifecycleManagerImpl.class);
    private final AtomicBoolean preinitializeBegin = new AtomicBoolean(false);
    private final AtomicBoolean preinitializeDone = new AtomicBoolean(false);
    private final AtomicBoolean backgroundBegin = new AtomicBoolean(false);
    private final AtomicBoolean backgroundDone = new AtomicBoolean(false);
    private final AtomicBoolean startBegin = new AtomicBoolean(false);
    private final AtomicBoolean startDone = new AtomicBoolean(false);
    private final AtomicBoolean shutdownBegin = new AtomicBoolean(false);
    private final AtomicBoolean shutdownDone = new AtomicBoolean(false);
    private final CountDownLatch startLatch = new CountDownLatch(1);
    private final LimeCoreGlue limeCoreGlue;
    private final List<Thread> SHUTDOWN_ITEMS = Collections.synchronizedList(new LinkedList());
    private long startFinishedTime;
    private final EventListenerList<LifeCycleEvent> listenerList;
    private final ServiceRegistry serviceRegistry;

    public LifecycleManagerImpl(LimeCoreGlue limeCoreGlue, ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
        this.listenerList = new EventListenerList();
        this.limeCoreGlue = limeCoreGlue;
    }

    @Override
    public boolean isLoaded() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STARTING;
    }

    @Override
    public boolean isStarted() {
        State state = this.getCurrentState();
        return state == State.STARTED || state == State.STOPPED;
    }

    @Override
    public boolean isShutdown() {
        return this.getCurrentState() == State.STOPPED;
    }

    @Override
    public void installListeners() {
        if (this.preinitializeBegin.getAndSet(true)) {
            return;
        }
        LimeCoreGlue.preinstall();
        this.serviceRegistry.initialize();
        this.preinitializeDone.set(true);
        this.installAzureusCoreListeners();
    }

    private void installAzureusCoreListeners() {
        this.addListener(new EventListener<LifeCycleEvent>(){

            @Override
            public void handleEvent(LifeCycleEvent lifeCycleEvent) {
                if (lifeCycleEvent == LifeCycleEvent.SHUTINGDOWN && AzureusStarter.isAzureusCoreStarted()) {
                    LOG.debug("LifecycleManagerImpl.handleEvent - SHUTINGDOWN - Azureus core pauseDownloads()!");
                    AzureusStarter.getAzureusCore().getGlobalManager().pauseDownloads();
                    AzureusStarter.getAzureusCore().stop();
                }
            }
        });
    }

    @Override
    public void loadBackgroundTasks() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        ThreadExecutor.startThread(new Runnable(){

            @Override
            public void run() {
                LifecycleManagerImpl.this.doBackgroundTasks();
            }
        }, "BackgroundTasks");
    }

    private void loadBackgroundTasksBlocking() {
        if (this.backgroundBegin.getAndSet(true)) {
            return;
        }
        this.installListeners();
        this.doBackgroundTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.startBegin.getAndSet(true)) {
            return;
        }
        try {
            this.listenerList.broadcast(LifeCycleEvent.STARTING);
            this.doStart();
            this.listenerList.broadcast(LifeCycleEvent.STARTED);
        }
        finally {
            this.startLatch.countDown();
        }
    }

    private void doStart() {
        this.loadBackgroundTasksBlocking();
        LOG.trace("START DownloadManager.postGuiInit");
        LOG.trace("STOP DownloadManager.postGuiInit");
        if (ApplicationSettings.AUTOMATIC_MANUAL_GC.getValue()) {
            this.startManualGCThread();
        }
        this.startDone.set(true);
        this.startFinishedTime = System.currentTimeMillis();
    }

    @Override
    public void shutdown() {
        try {
            this.listenerList.broadcast(LifeCycleEvent.SHUTINGDOWN);
            this.doShutdown();
            this.listenerList.broadcast(LifeCycleEvent.SHUTDOWN);
        }
        catch (Throwable throwable) {
            ErrorService.error(throwable);
        }
    }

    private void doShutdown() {
        if (!this.startBegin.get() || this.shutdownBegin.getAndSet(true)) {
            return;
        }
        try {
            this.startLatch.await();
        }
        catch (InterruptedException interruptedException) {
            LOG.error("Interrupted while waiting to finish starting", interruptedException);
            return;
        }
        this.serviceRegistry.stop();
        SettingsGroupManager.instance().save();
        if (AzureusStarter.isAzureusCoreStarted()) {
            AzureusStarter.getAzureusCore().stop();
        }
        this.shutdownDone.set(true);
    }

    private static String parseCommand(String string) {
        if (string.startsWith("\"")) {
            int n = string.indexOf("\"", 1);
            if (n > -1) {
                return string.substring(0, n + 1);
            }
            return string + "\"";
        }
        int n = string.indexOf(" ");
        if (n > -1) {
            return string.substring(0, n);
        }
        return string;
    }

    @Override
    public void shutdown(String string) {
        this.shutdown();
        if (string != null) {
            try {
                if (OSUtils.isWindowsVista()) {
                    String string2 = LifecycleManagerImpl.parseCommand(string).trim();
                    String string3 = string.substring(string2.length()).trim();
                    SystemUtils.openFile(string2, string3);
                } else {
                    Runtime.getRuntime().exec(string);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public long getStartFinishedTime() {
        return this.startFinishedTime;
    }

    @Override
    public boolean addShutdownItem(Thread thread) {
        if (this.shutdownBegin.get()) {
            return false;
        }
        this.SHUTDOWN_ITEMS.add(thread);
        return true;
    }

    private void doBackgroundTasks() {
        this.serviceRegistry.start("SuperEarly");
        this.serviceRegistry.start("EarlyBackground");
        this.limeCoreGlue.install();
        this.backgroundDone.set(true);
    }

    private State getCurrentState() {
        if (this.shutdownBegin.get()) {
            return State.STOPPED;
        }
        if (this.startDone.get()) {
            return State.STARTED;
        }
        if (this.startBegin.get()) {
            return State.STARTING;
        }
        return State.NONE;
    }

    private void startManualGCThread() {
        Thread thread = ThreadExecutor.newManagedThread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        Thread.sleep(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace("Running GC");
                    System.gc();
                    LOG.trace("GC finished, running finalizers");
                    System.runFinalization();
                    LOG.trace("Finalizers finished.");
                }
            }
        }, "ManualGC");
        thread.setDaemon(true);
        thread.start();
        LOG.trace("Started manual GC thread.");
    }

    public void addListener(EventListener<LifeCycleEvent> eventListener) {
        this.listenerList.addListener(eventListener);
    }

    public boolean removeListener(EventListener<LifeCycleEvent> eventListener) {
        return this.listenerList.removeListener(eventListener);
    }

    public static enum LifeCycleEvent {
        STARTING,
        STARTED,
        SHUTINGDOWN,
        SHUTDOWN;

    }

    private static enum State {
        NONE,
        STARTING,
        STARTED,
        STOPPED;

    }
}

