/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.limewire.util.CommonUtils;

public class LimeCoreGlue {
    private static AtomicBoolean preinstalled = new AtomicBoolean(false);
    private AtomicBoolean installed = new AtomicBoolean(false);
    private static LimeCoreGlue INSTANCE;

    public static LimeCoreGlue instance() {
        if (INSTANCE == null) {
            INSTANCE = new LimeCoreGlue();
        }
        return INSTANCE;
    }

    private LimeCoreGlue() {
    }

    public static void preinstall() throws InstallFailedException {
        LimeCoreGlue.preinstall(CommonUtils.getUserSettingsDir());
    }

    public static void preinstall(File file) throws InstallFailedException {
        if (!preinstalled.compareAndSet(false, true)) {
            return;
        }
        try {
            CommonUtils.setUserSettingsDir(file);
        }
        catch (Exception exception) {
            throw new InstallFailedException("Settings Directory Failure", exception);
        }
    }

    public void install() {
        if (!this.installed.compareAndSet(false, true)) {
            return;
        }
        LimeCoreGlue.preinstall();
    }

    public static class InstallFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 3989727284459714644L;

        public InstallFailedException() {
        }

        public InstallFailedException(String string, Throwable throwable) {
            super(string, throwable);
        }

        public InstallFailedException(String string) {
            super(string);
        }

        public InstallFailedException(Throwable throwable) {
            super(throwable);
        }
    }
}

