/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.util.EncodingUtils;
import com.limegroup.gnutella.util.URIUtils;
import com.limegroup.gnutella.util.URLDecoder;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import org.limewire.util.FileUtils;

public class MagnetOptions
implements Serializable {
    private static final long serialVersionUID = 5612757489102667276L;
    public static final String MAGNET = "magnet:?";
    private static final String HTTP = "http://";
    private static final String DOWNLOAD_PREFIX = "MAGNET download from ";
    private final Map<Option, List<String>> optionsMap;
    private transient String[] defaultURLs;
    private transient String localizedErrorMessage;
    private transient URN urn;
    private transient String extractedFileName;
    private transient List<URN> guidUrns;

    public static MagnetOptions[] parseMagnets(String string) {
        ArrayList<MagnetOptions> arrayList = new ArrayList<MagnetOptions>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            MagnetOptions[] magnetOptionsArray = MagnetOptions.parseMagnet(string2);
            if (magnetOptionsArray.length <= 0) continue;
            arrayList.addAll(Arrays.asList(magnetOptionsArray));
        }
        return arrayList.toArray(new MagnetOptions[0]);
    }

    public static MagnetOptions[] parseMagnet(String string) {
        Object object;
        HashMap<Integer, MagnetOptions[]> hashMap = new HashMap<Integer, MagnetOptions[]>();
        if (string.startsWith("'")) {
            string = string.substring(1);
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.toLowerCase(Locale.US).startsWith(MAGNET)) {
            return new MagnetOptions[0];
        }
        string = string.substring(8);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "&");
        while (stringTokenizer.hasMoreTokens()) {
            Option option;
            int n;
            String string2;
            String string3;
            block11: {
                string3 = stringTokenizer.nextToken();
                int n2 = (string3 = string3.trim()).indexOf("=") + 1;
                if (n2 == 0) continue;
                string2 = string3.substring(n2);
                string3 = string3.substring(0, n2 - 1);
                try {
                    string2 = URLDecoder.decode(string2);
                }
                catch (IOException iOException) {
                    continue;
                }
                int n3 = string3.indexOf(".");
                if (n3 > 0) {
                    try {
                        n = Integer.parseInt(string3.substring(n3 + 1));
                        break block11;
                    }
                    catch (NumberFormatException numberFormatException) {
                        continue;
                    }
                }
                n = 0;
            }
            Integer n4 = new Integer(n);
            object = (Map)hashMap.get(n4);
            if (object == null) {
                object = new HashMap();
                hashMap.put(n4, (MagnetOptions[])object);
            }
            if ((option = Option.valueFor(string3)) == null) continue;
            MagnetOptions.addAppend((Map<Option, List<String>>)object, option, string2);
        }
        object = new MagnetOptions[hashMap.size()];
        int n = 0;
        for (Map map : hashMap.values()) {
            object[n++] = new MagnetOptions(map);
        }
        return object;
    }

    private static void addAppend(Map<Option, List<String>> map, Option option, String string) {
        List<String> list = map.get((Object)option);
        if (list == null) {
            list = new ArrayList<String>(1);
            map.put(option, list);
        }
        list.add(string);
    }

    private MagnetOptions(Map<Option, List<String>> map) {
        this.optionsMap = Collections.unmodifiableMap(map);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public String toExternalForm() {
        StringBuilder stringBuilder = new StringBuilder(MAGNET);
        for (String string : this.getExactTopics()) {
            stringBuilder.append("&xt=").append(string);
        }
        if (this.getDisplayName() != null) {
            stringBuilder.append("&dn=").append(EncodingUtils.encode(this.getDisplayName()));
        }
        if (this.getKeywordTopic() != null) {
            stringBuilder.append("&kt=").append(EncodingUtils.encode(this.getKeywordTopic()));
        }
        for (String string : this.getXS()) {
            stringBuilder.append("&xs=").append(string);
        }
        for (String string : this.getAS()) {
            stringBuilder.append("&as=").append(string);
        }
        for (String string : this.getTR()) {
            stringBuilder.append("&tr=").append(string);
        }
        return stringBuilder.toString();
    }

    public URN getSHA1Urn() {
        if (this.urn == null) {
            this.urn = this.extractSHA1URNFromList(this.getExactTopics());
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getXS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromList(this.getAS());
            }
            if (this.urn == null) {
                this.urn = this.extractSHA1URNFromURLS(this.getDefaultURLs());
            }
            if (this.urn == null) {
                this.urn = URN.INVALID;
            }
        }
        if (this.urn == URN.INVALID) {
            return null;
        }
        return this.urn;
    }

    private URN extractSHA1URNFromURLS(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                URI uRI = URIUtils.toURI(stringArray[i]);
                String string = uRI.getQuery();
                if (string == null) continue;
                return URN.createSHA1Urn(uRI.getQuery());
            }
            catch (URISyntaxException uRISyntaxException) {
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean isDownloadable() {
        List<String> list = this.getExactTopics();
        for (String string : list) {
            if (!string.startsWith("urn:btih")) continue;
            return true;
        }
        if (this.getDefaultURLs().length > 0) {
            return true;
        }
        return this.getSHA1Urn() != null && this.getQueryString() != null;
    }

    public boolean isHashOnly() {
        String string = this.getKeywordTopic();
        String string2 = this.getDisplayName();
        return !(string != null && string.length() <= 0 || string2 != null && string2.length() <= 0 || !this.getAS().isEmpty() || !this.getXS().isEmpty() || this.getExactTopics().isEmpty());
    }

    public String getQueryString() {
        String string = this.getKeywordTopic();
        if (string != null && string.length() > 0) {
            return string;
        }
        String string2 = this.getDisplayName();
        if (string2 != null && string2.length() > 0) {
            return string2;
        }
        return null;
    }

    public boolean isKeywordTopicOnly() {
        String string = this.getKeywordTopic();
        String string2 = this.getDisplayName();
        return string != null && string.length() > 0 && (string2 == null || string2.length() > 0) && this.getAS().isEmpty() && this.getXS().isEmpty() && this.getExactTopics().isEmpty();
    }

    private URN extractSHA1URNFromList(List<String> list) {
        for (String string : list) {
            try {
                return URN.createSHA1Urn(string);
            }
            catch (IOException iOException) {
            }
        }
        return null;
    }

    private List<String> getPotentialURLs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getPotentialURLs(this.getExactTopics()));
        arrayList.addAll(this.getPotentialURLs(this.getXS()));
        arrayList.addAll(this.getPotentialURLs(this.getAS()));
        return arrayList;
    }

    private List<String> getPotentialURNs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(this.getPotentialURNs(this.getExactTopics()));
        arrayList.addAll(this.getPotentialURNs(this.getXS()));
        arrayList.addAll(this.getPotentialURNs(this.getAS()));
        return arrayList;
    }

    private List<String> getPotentialURNs(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!string.toLowerCase(Locale.US).startsWith("urn:")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private List<String> getPotentialURLs(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : list) {
            if (!string.toLowerCase(Locale.US).startsWith(HTTP)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public String[] getDefaultURLs() {
        if (this.defaultURLs == null) {
            List<String> list = this.getPotentialURLs();
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                try {
                    String string = iterator.next();
                    URIUtils.toURI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    iterator.remove();
                    this.localizedErrorMessage = uRISyntaxException.getLocalizedMessage();
                }
            }
            this.defaultURLs = list.toArray(new String[list.size()]);
        }
        return this.defaultURLs;
    }

    public List<URN> getGUIDUrns() {
        if (this.guidUrns != null) {
            return this.guidUrns;
        }
        List<URN> list = null;
        List<String> list2 = this.getPotentialURNs();
        for (String string : list2) {
            try {
                URN uRN = URN.createGUIDUrn(string);
                if (list == null) {
                    list = new ArrayList<URN>(2);
                }
                list.add(uRN);
            }
            catch (IOException iOException) {}
        }
        list = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.guidUrns = list;
        return list;
    }

    public String getDisplayName() {
        List<String> list = this.optionsMap.get((Object)Option.DN);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public String getFileNameForSaving() {
        if (this.extractedFileName != null) {
            return this.extractedFileName;
        }
        String string = this.getRawNameForSaving();
        while (string.startsWith(".") || string.startsWith("\\") || string.startsWith("/")) {
            string = string.substring(1);
        }
        this.extractedFileName = string;
        return this.extractedFileName;
    }

    private String getRawNameForSaving() {
        Comparable<File> comparable;
        String string = this.getDisplayName();
        if (string != null && string.length() > 0) {
            return string;
        }
        string = this.getKeywordTopic();
        if (string != null && string.length() > 0) {
            return string;
        }
        URN uRN = this.getSHA1Urn();
        if (uRN != null) {
            string = uRN.toString();
            return string;
        }
        String[] stringArray = this.getDefaultURLs();
        if (stringArray.length > 0) {
            try {
                comparable = URIUtils.toURI(stringArray[0]);
                string = MagnetOptions.extractFileName(comparable);
                if (string != null && string.length() > 0) {
                    return string;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        try {
            comparable = FileUtils.createTempFile("magnet", "");
            ((File)comparable).deleteOnExit();
            string = ((File)comparable).getName();
            return string;
        }
        catch (IOException iOException) {
            string = DOWNLOAD_PREFIX;
            return string;
        }
    }

    public String getKeywordTopic() {
        List<String> list = this.optionsMap.get((Object)Option.KT);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public List<String> getExactTopics() {
        return this.getList(Option.XT);
    }

    public List<String> getXS() {
        return this.getList(Option.XS);
    }

    public List<String> getAS() {
        return this.getList(Option.AS);
    }

    public List<String> getTR() {
        return this.getList(Option.TR);
    }

    private List<String> getList(Option option) {
        List<String> list = this.optionsMap.get((Object)option);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public String getErrorMessage() {
        return this.localizedErrorMessage;
    }

    public static String extractFileName(URI uRI) {
        String string = null;
        String string2 = null;
        string = uRI.getPath();
        string2 = uRI.getHost();
        if (string != null && string.length() > 0) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                return string;
            }
            if (n >= 0 && n < string.length() - 1) {
                return string.substring(n + 1);
            }
        }
        if (string2 != null) {
            return DOWNLOAD_PREFIX + string2;
        }
        return DOWNLOAD_PREFIX;
    }

    private static enum Option {
        XS,
        XT,
        AS,
        DN,
        KT,
        TR;


        public static Option valueFor(String string) {
            for (Option option : Option.values()) {
                if (!string.toUpperCase(Locale.US).startsWith(option.toString())) continue;
                return option;
            }
            return null;
        }
    }
}

