/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import java.security.DigestException;
import java.security.MessageDigest;
import java.util.ArrayList;

public class MerkleTree
extends MessageDigest {
    private static final int BLOCKSIZE = 1024;
    public static final int HASHSIZE = 24;
    private static final byte[] MARKER = new byte[0];
    private final byte[] buffer = new byte[1024];
    private int bufferOffset = 0;
    private long byteCount = 0L;
    private final MessageDigest internalDigest;
    private final ArrayList<byte[]> nodes = new ArrayList();

    public MerkleTree(MessageDigest messageDigest) {
        super("merkletree");
        this.internalDigest = messageDigest;
    }

    @Override
    protected int engineGetDigestLength() {
        return 24;
    }

    @Override
    protected void engineUpdate(byte by) {
        ++this.byteCount;
        this.buffer[this.bufferOffset++] = by;
        if (this.bufferOffset == 1024) {
            this.blockUpdate();
            this.bufferOffset = 0;
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) {
        this.byteCount += (long)n2;
        this.nodes.ensureCapacity(MerkleTree.log2Ceil(this.byteCount / 1024L));
        if (this.bufferOffset > 0) {
            int n3 = 1024 - this.bufferOffset;
            System.arraycopy(byArray, n, this.buffer, this.bufferOffset, n3);
            this.blockUpdate();
            this.bufferOffset = 0;
            n2 -= n3;
            n += n3;
        }
        while (n2 >= 1024) {
            this.blockUpdate(byArray, n, 1024);
            n2 -= 1024;
            n += 1024;
        }
        if (n2 > 0) {
            System.arraycopy(byArray, n, this.buffer, 0, n2);
            this.bufferOffset = n2;
        }
    }

    @Override
    protected byte[] engineDigest() {
        byte[] byArray = new byte[24];
        try {
            this.engineDigest(byArray, 0, 24);
        }
        catch (DigestException digestException) {
            return null;
        }
        return byArray;
    }

    @Override
    protected int engineDigest(byte[] byArray, int n, int n2) throws DigestException {
        if (n2 < 24) {
            throw new DigestException();
        }
        this.blockUpdate();
        byte[] byArray2 = this.collapse();
        assert (byArray2 != MARKER);
        System.arraycopy(byArray2, 0, byArray, n, 24);
        this.engineReset();
        return 24;
    }

    private byte[] collapse() {
        byte[] byArray = null;
        for (int i = 0; i < this.nodes.size(); ++i) {
            byte[] byArray2 = this.nodes.get(i);
            if (byArray2 == MARKER) continue;
            if (byArray == null) {
                byArray = byArray2;
            } else {
                this.internalDigest.reset();
                this.internalDigest.update((byte)1);
                this.internalDigest.update(byArray2);
                this.internalDigest.update(byArray);
                byArray = this.internalDigest.digest();
            }
            this.nodes.set(i, MARKER);
        }
        assert (byArray != null);
        return byArray;
    }

    @Override
    protected void engineReset() {
        this.bufferOffset = 0;
        this.byteCount = 0L;
        this.nodes.clear();
        this.internalDigest.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected void blockUpdate() {
        this.blockUpdate(this.buffer, 0, this.bufferOffset);
    }

    protected void blockUpdate(byte[] byArray, int n, int n2) {
        this.internalDigest.reset();
        this.internalDigest.update((byte)0);
        this.internalDigest.update(byArray, n, n2);
        if (n2 == 0 && this.nodes.size() > 0) {
            return;
        }
        byte[] byArray2 = this.internalDigest.digest();
        this.push(byArray2);
    }

    private void push(byte[] byArray) {
        if (!this.nodes.isEmpty()) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                byte[] byArray2 = this.nodes.get(i);
                if (byArray2 == MARKER) {
                    this.nodes.set(i, byArray);
                    return;
                }
                this.internalDigest.reset();
                this.internalDigest.update((byte)1);
                this.internalDigest.update(byArray2);
                this.internalDigest.update(byArray);
                byArray = this.internalDigest.digest();
                this.nodes.set(i, MARKER);
            }
        }
        this.nodes.add(byArray);
    }

    public static int log2Ceil(long l) {
        int n = 0;
        while (l > 1L) {
            ++l;
            l >>>= 1;
            ++n;
        }
        return n;
    }
}

