/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.UrnType;
import java.io.File;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.limewire.collection.IntWrapper;
import org.limewire.util.Base32;

public final class URN
implements Serializable {
    private static final long serialVersionUID = -6053855548211564799L;
    public static final Set<URN> NO_URN_SET = Collections.emptySet();
    public static final URN INVALID = new URN("bad:bad", Type.INVALID);
    public static final int MIN_IDLE_TIME = 300000;
    private static final String DOT = ".";
    private transient String _urnString;
    private transient Type _urnType;
    private volatile transient int hashCode = 0;
    private static final Map<File, IntWrapper> progressMap = Collections.synchronizedMap(new HashMap());

    public static int getHashingProgress(File file) {
        IntWrapper intWrapper = progressMap.get(file);
        if (intWrapper == null) {
            return -1;
        }
        return intWrapper.getInt();
    }

    public static URN createSHA1Urn(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf(Type.SHA1.getDescriptor()) == 4) {
            return URN.createUrnFromString(string);
        }
        if (string2.indexOf(Type.BITPRINT.getDescriptor()) == 4) {
            return URN.createSHA1UrnFromBitprint(string);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createGUIDUrn(String string) throws IOException {
        URN uRN = URN.createUrnFromString(string);
        if (uRN.getUrnType() != Type.GUID) {
            throw new IOException("Not a GUID urn: " + string);
        }
        return uRN;
    }

    public static URN createGUIDUrn(GUID gUID) {
        return new URN("urn:" + Type.GUID.getDescriptor() + gUID.toHexString(), Type.GUID);
    }

    public static URN createTTRootUrn(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf(Type.TTROOT.getDescriptor()) == 4) {
            return new URN(string, Type.TTROOT);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static String getTigerTreeRoot(String string) throws IOException {
        String string2 = URN.getTypeString(string).toLowerCase(Locale.US);
        if (string2.indexOf(Type.BITPRINT.getDescriptor()) == 4) {
            return URN.getTTRootFromBitprint(string);
        }
        throw new IOException("unsupported or malformed URN");
    }

    public static URN createSHA1UrnFromURL(URL uRL) throws IOException {
        return URN.createSHA1UrnFromUriRes(uRL.getFile());
    }

    public static URN createSHA1UrnFromUriRes(String string) throws IOException {
        string.trim();
        if (URN.isValidUriResSHA1Format(string)) {
            return URN.createUrnFromString(string.substring(13));
        }
        throw new IOException("could not parse string format: " + string);
    }

    public static URN createSHA1UrnFromBytes(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 20) {
            throw new IOException("invalid bytes!");
        }
        String string = Base32.encode(byArray);
        return URN.createUrnFromString("urn:sha1:" + string);
    }

    public static URN createTTRootFromBytes(byte[] byArray) throws IOException {
        if (byArray == null || byArray.length != 24) {
            throw new IOException("invalid bytes!");
        }
        String string = Base32.encode(byArray);
        return new URN("urn:" + Type.TTROOT.getDescriptor() + string, Type.TTROOT);
    }

    private static URN createUrnFromString(String string) throws IOException {
        if (!URN.isValidUrn(string)) {
            throw new IOException("invalid urn string: " + string);
        }
        String string2 = URN.getTypeString(string);
        Type type = Type.createUrnType(string2);
        if (type == null) {
            throw new IOException("urn type not recognized: " + string2);
        }
        return new URN(string, type);
    }

    private static URN createSHA1UrnFromBitprint(String string) throws IOException {
        int n = string.indexOf(DOT);
        if (n == -1) {
            throw new IOException("invalid bitprint: " + string);
        }
        String string2 = string.substring(string.indexOf(58, 4) + 1, n);
        return URN.createUrnFromString("urn:" + Type.SHA1.getDescriptor() + string2);
    }

    private static String getTTRootFromBitprint(String string) throws IOException {
        int n = string.indexOf(DOT);
        if (n == -1 || n == string.length() - 1) {
            throw new IOException("invalid bitprint: " + string);
        }
        String string2 = string.substring(n + 1);
        if (string2.length() != 39) {
            throw new IOException("wrong length: " + string2.length());
        }
        return string2;
    }

    private URN(String string, Type type) {
        int n = string.lastIndexOf(":");
        String string2 = string.substring(0, n + 1);
        String string3 = string.substring(n + 1);
        this._urnString = string2.toLowerCase(Locale.US) + string3.toUpperCase(Locale.US);
        this._urnType = type;
    }

    public byte[] getBytes() {
        return Base32.decode(this.getNamespaceSpecificString());
    }

    public String getNamespaceSpecificString() {
        return this._urnString.substring(this._urnString.lastIndexOf(58) + 1);
    }

    public Type getUrnType() {
        return this._urnType;
    }

    public String httpStringValue() {
        return this._urnString;
    }

    public static boolean isUrn(String string) {
        return URN.isValidUrn(string);
    }

    public boolean isSHA1() {
        return this._urnType == Type.SHA1;
    }

    public boolean isTTRoot() {
        return this._urnType == Type.TTROOT;
    }

    public boolean isGUID() {
        return this._urnType == Type.GUID;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof URN)) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        URN uRN = (URN)object;
        return this._urnString.equals(uRN._urnString) && this._urnType.equals((Object)uRN._urnType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n = 17;
            n = 37 * n + this._urnString.hashCode();
            this.hashCode = n = 37 * n + this._urnType.hashCode();
        }
        return this.hashCode;
    }

    public String toString() {
        return this._urnString;
    }

    private static boolean isValidUriResSHA1Format(String string) {
        String string2 = string.toLowerCase(Locale.US);
        if (string2.startsWith("/uri-res/n2r?urn:sha1:")) {
            return string.length() == 54;
        }
        return false;
    }

    private static String getTypeString(String string) throws IOException {
        String string2 = string.trim();
        if (string2.length() <= 4) {
            throw new IOException("no type string");
        }
        return string2.substring(0, string2.indexOf(58, 4) + 1);
    }

    private static boolean isValidUrn(String string) {
        int n = string.indexOf(":");
        if (n == -1 || n + 1 > string.length()) {
            return false;
        }
        int n2 = n - 3;
        int n3 = n + 1;
        if (n2 < 0 || n3 < 0) {
            return false;
        }
        int n4 = string.indexOf(":", n + 1);
        if (n4 == -1 || n4 + 1 > string.length()) {
            return false;
        }
        String string2 = string.substring(0, n4 + 1);
        Type type = Type.createUrnType(string2);
        if (type == null) {
            return false;
        }
        return type.getLength() == string.substring(n4 + 1).length();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeUTF(this._urnString);
        objectOutputStream.writeObject((Object)this._urnType);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this._urnString = objectInputStream.readUTF();
        Object object = objectInputStream.readObject();
        if (object instanceof UrnType) {
            object = Type.createFromDescriptor(((UrnType)object).getType());
        }
        this._urnType = (Type)((Object)object);
        if (this._urnType != Type.SHA1 && this._urnType != Type.TTROOT) {
            throw new InvalidObjectException("invalid urn type: " + object);
        }
        if (!URN.isValidUrn(this._urnString)) {
            throw new InvalidObjectException("invalid urn: " + this._urnString);
        }
    }

    public static enum Type {
        SHA1("sha1:", 32),
        BITPRINT("bitprint:", 72),
        TTROOT("ttroot:", 39),
        ANY_TYPE("", -1),
        INVALID("Invalid", -1),
        GUID("guid:", 32);

        private final String descriptor;
        private final int length;
        public static final Set<Type> SHA1_SET;
        public static final Set<Type> ANY_TYPE_SET;
        public static final Set<Type> NO_TYPE_SET;
        public static final String URN_NAMESPACE_ID = "urn:";

        private Type(String string2, int n2) {
            this.descriptor = string2;
            this.length = n2;
        }

        public String getDescriptor() {
            return this.descriptor;
        }

        public int getLength() {
            return this.length;
        }

        public String toString() {
            return URN_NAMESPACE_ID + this.descriptor;
        }

        static Type createFromDescriptor(String string) {
            string = string.toLowerCase(Locale.US).trim();
            for (Type type : Type.values()) {
                if (!type.descriptor.equals(string)) continue;
                return type;
            }
            return null;
        }

        public static Type createUrnType(String string) {
            string = string.toLowerCase(Locale.US).trim();
            for (Type type : Type.values()) {
                if (!type.toString().equals(string)) continue;
                return type;
            }
            return null;
        }

        public static boolean isSupportedUrnType(String string) {
            return Type.createUrnType(string) != null;
        }

        static {
            SHA1_SET = EnumSet.of(SHA1);
            ANY_TYPE_SET = EnumSet.of(ANY_TYPE);
            NO_TYPE_SET = EnumSet.noneOf(Type.class);
        }
    }
}

