/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.player.AudioPlayerComponent;
import com.frostwire.gui.tabs.Tab;
import com.frostwire.gui.updates.UpdateMediator;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.ImageManipulator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.callback.TimelineCallbackAdapter;

public class ApplicationHeader
extends JPanel
implements ThemeObserver,
RefreshListener {
    private static final String SELECTED = "SELECTED_ICON";
    private static final String DESELECTED = "DESELECTED_ICON";
    private final MouseListener CLICK_FORWARDER = new Clicker();
    private final ItemListener HIGHLIGHTER = new Highlighter();
    private static final long serialVersionUID = 4800214468508213106L;
    private Image tile;
    private final Image headerButtonBackgroundSelected;
    private final Image headerButtonBackgroundUnselected;
    private LogoPanel logoPanel;
    private JLabel updateButton;
    private ImageIcon updateImageButtonOn;
    private ImageIcon updateImageButtonOff;
    private JPanel eastPanel;

    public ApplicationHeader(Map<GUIMediator.Tabs, Tab> map) {
        this.setLayout(new BorderLayout());
        this.tile = GUIMediator.getThemeImage("application_header_background").getImage();
        this.headerButtonBackgroundSelected = GUIMediator.getThemeImage("selected_header_button_background").getImage();
        this.headerButtonBackgroundUnselected = GUIMediator.getThemeImage("unselected_header_button_background").getImage();
        this.setSizes();
        this.initBackground();
        this.addTabButtons(map);
        this.addLogoPanel();
        this.addEastPanel();
        this.addUpdateButton();
        this.addAudioPlayerComponent();
        GUIMediator.addRefreshListener(this);
    }

    private void addEastPanel() {
        this.eastPanel = new JPanel(new FlowLayout(0, 10, 0));
        this.eastPanel.setOpaque(false);
        this.add((Component)this.eastPanel, "After");
    }

    private void initBackground() {
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        for (int i = 0; i < this.getWidth(); i += 16) {
            graphics.drawImage(this.tile, i, 0, null);
        }
    }

    private void setSizes() {
        this.setMinimumSize(new Dimension(1, 54));
        this.setPreferredSize(new Dimension(Integer.MAX_VALUE, 54));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 54));
    }

    private void addAudioPlayerComponent() {
        final JPanel jPanel = new AudioPlayerComponent().getMediaPanel(true);
        jPanel.setMinimumSize(new Dimension(300, 45));
        jPanel.setPreferredSize(new Dimension(300, 45));
        jPanel.setBorder(BorderFactory.createEmptyBorder(2, 1, 6, 11));
        final Image image = GUIMediator.getThemeImage("audio_player_background").getImage();
        JPanel jPanel2 = new JPanel(){

            @Override
            protected void paintComponent(Graphics graphics) {
                graphics.drawImage(image, 0, (this.getHeight() - jPanel.getHeight()) / 2, null);
                super.paintComponent(graphics);
            }
        };
        jPanel2.setOpaque(false);
        jPanel2.add(jPanel);
        this.eastPanel.add(jPanel2);
    }

    private void addUpdateButton() {
        this.updateImageButtonOn = GUIMediator.getThemeImage("update_button_on");
        this.updateImageButtonOff = GUIMediator.getThemeImage("update_button_off");
        this.updateButton = new JLabel(this.updateImageButtonOn);
        this.updateButton.setToolTipText(I18n.tr("A new update has been downloaded."));
        Dimension dimension = new Dimension(32, 32);
        this.updateButton.setVisible(false);
        this.updateButton.setSize(dimension);
        this.updateButton.setPreferredSize(dimension);
        this.updateButton.setMinimumSize(dimension);
        this.updateButton.setMaximumSize(dimension);
        this.updateButton.setBorder(null);
        this.updateButton.setOpaque(false);
        this.updateButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UpdateMediator.instance().showUpdateMessage();
            }
        });
        this.eastPanel.add(this.updateButton);
    }

    private void addLogoPanel() {
        this.logoPanel = new LogoPanel();
        this.add((Component)this.logoPanel, "Center");
    }

    public LogoPanel getLogoPanel() {
        return this.logoPanel;
    }

    private void addTabButtons(Map<GUIMediator.Tabs, Tab> map) {
        GridLayout gridLayout = new GridLayout(1, GUIMediator.Tabs.values().length);
        gridLayout.setHgap(8);
        JPanel jPanel = new JPanel(gridLayout);
        jPanel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 32));
        jPanel.setOpaque(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        Font font = new Font("Helvetica", 1, 14);
        GUIMediator.Tabs[] tabsArray = GUIMediator.Tabs.values();
        int n = tabsArray.length;
        for (int i = 0; i < n; ++i) {
            GUIMediator.Tabs tabs;
            final GUIMediator.Tabs tabs2 = tabs = tabsArray[i];
            AbstractButton abstractButton = this.createTabButton(map.get((Object)tabs));
            abstractButton.setFont(font);
            abstractButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GUIMediator.instance().setWindow(tabs2);
                }
            });
            buttonGroup.add(abstractButton);
            jPanel.add(abstractButton);
            abstractButton.setSelected(tabs.equals((Object)GUIMediator.Tabs.SEARCH));
        }
        this.add((Component)jPanel, "Before");
    }

    public void selectTab(Tab tab) {
        Component[] componentArray;
        Component[] componentArray2 = this.getComponents();
        JPanel jPanel = (JPanel)componentArray2[0];
        for (Component component : componentArray = jPanel.getComponents()) {
            AbstractButton abstractButton;
            if (!(component instanceof AbstractButton) || !(abstractButton = (AbstractButton)component).getClientProperty("tab").equals(tab)) continue;
            abstractButton.setSelected(true);
            return;
        }
    }

    private AbstractButton createTabButton(Tab tab) {
        Icon icon = tab.getIcon();
        Icon icon2 = null;
        Icon icon3 = null;
        JRadioButton jRadioButton = new JRadioButton(I18n.tr(tab.getTitle())){

            @Override
            protected void paintComponent(Graphics graphics) {
                if (this.isSelected()) {
                    graphics.drawImage(ApplicationHeader.this.headerButtonBackgroundSelected, 0, 0, null);
                } else {
                    graphics.drawImage(ApplicationHeader.this.headerButtonBackgroundUnselected, 0, 0, null);
                }
                super.paintComponent(graphics);
            }
        };
        jRadioButton.putClientProperty("tab", tab);
        jRadioButton.putClientProperty(SELECTED, icon);
        if (icon != null) {
            icon2 = ImageManipulator.darken(icon);
            icon3 = ImageManipulator.brighten(icon);
        }
        jRadioButton.putClientProperty(DESELECTED, icon2);
        jRadioButton.setIcon(icon2);
        jRadioButton.setRolloverIcon(icon3);
        jRadioButton.addItemListener(this.HIGHLIGHTER);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 7, 5, 0));
        jRadioButton.setFocusPainted(false);
        jRadioButton.setContentAreaFilled(false);
        jRadioButton.setOpaque(false);
        jRadioButton.addMouseListener(this.CLICK_FORWARDER);
        jRadioButton.setToolTipText(tab.getToolTip());
        jRadioButton.putClientProperty("substancelaf.internal.textUtilities.enforceFgColor", Boolean.TRUE);
        jRadioButton.setForeground(ThemeMediator.CURRENT_THEME.getCustomUI().getTabButtonForegroundColor());
        Dimension dimension = new Dimension(107, 34);
        jRadioButton.setPreferredSize(dimension);
        jRadioButton.setMinimumSize(dimension);
        jRadioButton.setMaximumSize(dimension);
        jRadioButton.setSelected(false);
        return jRadioButton;
    }

    @Override
    public void updateTheme() {
        Component[] componentArray;
        System.out.println("ApplicationHeader.updateTheme");
        for (Component component : componentArray = this.getComponents()) {
            component.repaint();
        }
    }

    @Override
    public void refresh() {
        this.showUpdateButton(!UpdateMediator.instance().isUpdated() && UpdateMediator.instance().isUpdateDownloaded());
    }

    private void showUpdateButton(boolean bl) {
        if (this.updateButton.isVisible() == bl) {
            return;
        }
        this.updateButton.setVisible(bl);
        if (bl) {
            final Timeline timeline = new Timeline(new IntermittentButton(this.updateButton, this.updateImageButtonOn, this.updateImageButtonOff));
            timeline.addCallback(new TimelineCallbackAdapter(){
                private long lastChange = 0L;
                private boolean lastState = false;

                @Override
                public void onTimelinePulse(float f, float f2) {
                    int n = (int)(f * (float)timeline.getDuration() / 1000.0f);
                    if ((long)n != this.lastChange) {
                        this.lastChange = n;
                        ApplicationHeader.this.updateButton.setIcon(this.lastState ? ApplicationHeader.this.updateImageButtonOn : ApplicationHeader.this.updateImageButtonOff);
                        this.lastState = !this.lastState;
                    }
                }

                @Override
                public void onTimelineStateChanged(Timeline.TimelineState timelineState, Timeline.TimelineState timelineState2, float f, float f2) {
                    if (timelineState2 == Timeline.TimelineState.DONE) {
                        ApplicationHeader.this.updateButton.setIcon(ApplicationHeader.this.updateImageButtonOn);
                    }
                }
            });
            timeline.setDuration(30000L);
            timeline.play();
        }
    }

    public static class IntermittentButton {
        private JLabel buttonReference;
        private ImageIcon imgOn;
        private ImageIcon imgOff;

        public IntermittentButton(JLabel jLabel, ImageIcon imageIcon, ImageIcon imageIcon2) {
            this.buttonReference = jLabel;
            this.imgOn = imageIcon;
            this.imgOff = imageIcon2;
        }

        public void setImage(final boolean bl) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    IntermittentButton.this.buttonReference.setIcon(bl ? IntermittentButton.this.imgOn : IntermittentButton.this.imgOff);
                }
            });
        }
    }

    private static class Clicker
    implements MouseListener {
        private Clicker() {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (!(jComponent instanceof AbstractButton)) {
                AbstractButton abstractButton = (AbstractButton)jComponent.getComponent(0);
                abstractButton.doClick();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private static class Highlighter
    implements ItemListener {
        private Highlighter() {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            AbstractButton abstractButton = (AbstractButton)itemEvent.getSource();
            if (itemEvent.getStateChange() == 1) {
                abstractButton.setIcon((Icon)abstractButton.getClientProperty(ApplicationHeader.SELECTED));
            } else {
                abstractButton.setIcon((Icon)abstractButton.getClientProperty(ApplicationHeader.DESELECTED));
            }
        }
    }
}

