/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonRow
extends JPanel {
    private static final long serialVersionUID = 2171794172705055068L;
    private JButton[] _buttons;
    public static final int BUTTON_SEP = 6;
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int TOP_GLUE = 10;
    public static final int BOTTOM_GLUE = 11;
    public static final int LEFT_GLUE = 12;
    public static final int RIGHT_GLUE = 13;
    public static final int NO_GLUE = 14;

    public ButtonRow(String[] stringArray, String[] stringArray2, EventListener[] eventListenerArray) {
        this(stringArray, stringArray2, eventListenerArray, null, 0, 14);
    }

    public ButtonRow(String[] stringArray, String[] stringArray2, EventListener[] eventListenerArray, String[] stringArray3) {
        this(stringArray, stringArray2, eventListenerArray, stringArray3, 0, 14);
    }

    public ButtonRow(String[] stringArray, String[] stringArray2, EventListener[] eventListenerArray, int n, int n2) {
        this(stringArray, stringArray2, eventListenerArray, null, n, n2);
    }

    public ButtonRow(String[] stringArray, String[] stringArray2, EventListener[] eventListenerArray, String[] stringArray3, int n, int n2) {
        Object object;
        int n3;
        if (stringArray.length != stringArray2.length || stringArray.length != eventListenerArray.length || stringArray2.length != eventListenerArray.length) {
            throw new IllegalArgumentException("invalid ButtonRow constructor: array lengths must be equal");
        }
        BoxLayout boxLayout = new BoxLayout(this, n);
        this.setLayout(boxLayout);
        int n4 = stringArray.length;
        int n5 = n4 - 1;
        this._buttons = new JButton[n4];
        Component[] componentArray = new Component[n5];
        for (n3 = 0; n3 < n4; ++n3) {
            object = "";
            if (!"".equals(stringArray[n3])) {
                object = I18n.tr(stringArray[n3]);
            }
            this._buttons[n3] = stringArray3 != null && stringArray3[n3] != null ? new IconButton((String)object, stringArray3[n3]) : new JButton((String)object);
            if (stringArray2[n3] == null) continue;
            String string = I18n.tr(stringArray2[n3]);
            this._buttons[n3].setToolTipText(string);
        }
        this.setListeners(eventListenerArray);
        if (n == 0) {
            object = new Dimension(6, 0);
            for (n3 = 0; n3 < n5; ++n3) {
                componentArray[n3] = Box.createRigidArea((Dimension)object);
            }
        } else {
            object = new Dimension(0, 6);
            while (n3 < n5) {
                componentArray[n3] = Box.createRigidArea((Dimension)object);
                ++n3;
            }
        }
        n3 = 0;
        if (n2 == 10 && n == 1) {
            this.add(Box.createVerticalGlue());
        } else if (n2 == 12 && n == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (n2 == 14 && n == 0) {
            this.add(Box.createHorizontalGlue());
        }
        while (n3 < n4) {
            this.add(this._buttons[n3]);
            if (n3 < n5) {
                this.add(componentArray[n3]);
            }
            ++n3;
        }
        if (n2 == 11 && n == 1) {
            this.add(Box.createVerticalGlue());
        } else if (n2 == 13 && n == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (n2 == 14 && n == 0) {
            this.add(Box.createHorizontalGlue());
        }
    }

    public ButtonRow(Action[] actionArray, int n, int n2) {
        this(actionArray, n, n2, null);
    }

    public ButtonRow(Action[] actionArray, int n, int n2, JComponent jComponent) {
        Dimension dimension;
        int n3;
        BoxLayout boxLayout = new BoxLayout(this, n);
        this.setLayout(boxLayout);
        int n4 = actionArray.length - 1;
        this._buttons = new JButton[actionArray.length];
        Component[] componentArray = new Component[n4];
        for (n3 = 0; n3 < actionArray.length; ++n3) {
            this._buttons[n3] = actionArray[n3].getValue("LimeIconName") != null ? new IconButton(actionArray[n3]) : new JButton(actionArray[n3]);
        }
        if (n == 0) {
            dimension = new Dimension(6, 0);
            for (n3 = 0; n3 < n4; ++n3) {
                componentArray[n3] = Box.createRigidArea(dimension);
            }
        } else {
            dimension = new Dimension(0, 6);
            while (n3 < n4) {
                componentArray[n3] = Box.createRigidArea(dimension);
                ++n3;
            }
        }
        n3 = 0;
        if (n2 == 10 && n == 1) {
            this.add(Box.createVerticalGlue());
        } else if (n2 == 12 && n == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (n2 == 14 && n == 0) {
            this.add(Box.createHorizontalGlue());
        }
        while (n3 < actionArray.length) {
            this.add(this._buttons[n3]);
            if (n3 < n4) {
                this.add(componentArray[n3]);
            }
            ++n3;
        }
        if (n2 == 11 && n == 1) {
            this.add(Box.createVerticalGlue());
        } else if (n2 == 13 && n == 0) {
            this.add(Box.createHorizontalGlue());
        } else if (n2 == 14 && n == 0) {
            this.add(Box.createHorizontalGlue());
        }
        if (jComponent != null) {
            this.add(jComponent);
        }
    }

    private void setListeners(EventListener[] eventListenerArray) {
        int n = eventListenerArray.length;
        int n2 = this._buttons.length;
        if (n <= n2) {
            for (int i = 0; i < n2; ++i) {
                if (eventListenerArray[i] instanceof ActionListener) {
                    this._buttons[i].addActionListener((ActionListener)eventListenerArray[i]);
                    continue;
                }
                if (!(eventListenerArray[i] instanceof MouseAdapter)) continue;
                this._buttons[i].addMouseListener((MouseAdapter)eventListenerArray[i]);
            }
        }
    }

    public JButton getButtonAtIndex(int n) {
        if (n >= this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this._buttons[n];
    }

    public void setButtonEnabled(int n, boolean bl) {
        if (n >= this._buttons.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this._buttons[n].setEnabled(bl);
    }

    public void setButtonsEnabled(boolean bl) {
        for (int i = 0; i < this._buttons.length; ++i) {
            this._buttons[i].setEnabled(bl);
        }
    }

    public void transformButton(int n, String string, String string2) {
        JButton jButton = this.getButtonAtIndex(n);
        if (jButton != null) {
            jButton.setText(string);
            jButton.setToolTipText(string2);
        }
    }
}

