/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.CheckBoxList;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.SeperatorBorder;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;

public class CheckBoxList<E>
extends BoxPanel {
    private static final long serialVersionUID = 680881365220840255L;
    private String disabledTooltip = null;
    private boolean removeable = false;
    private boolean selectOff;
    private JScrollPane scrollPane;
    private JTable checkBoxList;
    private CheckBoxListSelectionListener selectionListener;
    private CheckBoxListCheckChangeListener<?> checkListener;
    private Object parent;
    private int highLightedRow = -1;
    private final Set<E> elements = new HashSet();
    private final Set<E> unchecked = new HashSet();
    private final Set<E> checked = new HashSet();
    private final Set<E> disabled = new HashSet();
    private final Set<E> bolded = new HashSet();
    private Object selected;
    public static final int SELECT_FIRST_ON = 0;
    public static final int SELECT_FIRST_OFF = 1;
    private static final int DEFAULT_ROW_HEIGHT = 22;
    private TextProvider<E> provider;
    private ExtrasProvider<E> extrasProvider;
    private List<E> items;
    private int visibleRowCount = -1;
    public static final String TEXT_PROVIDER_PROPERTY = "textProvider";
    private CheckBoxCellEditor editor;

    public CheckBoxList(Collection<E> collection, Collection<E> collection2, TextProvider<E> textProvider, ExtrasProvider<E> extrasProvider, int n) {
        this.provider = textProvider;
        this.extrasProvider = extrasProvider;
        if (textProvider == null) {
            throw new NullPointerException("provider must not be null");
        }
        this.parent = this;
        this.selectionListener = null;
        this.selectOff = n == 1;
        this.initialize();
        this.setElements(collection, collection2);
    }

    public CheckBoxList(Collection<E> collection, Collection<E> collection2, TextProvider<E> textProvider, int n) {
        this(collection, collection2, textProvider, null, n);
    }

    public CheckBoxList(Collection<E> hashSet, TextProvider<E> textProvider, boolean bl, int n) {
        this(hashSet, bl ? new HashSet() : hashSet, textProvider, null, n);
    }

    public CheckBoxList(Collection<E> collection, Collection<E> collection2, int n) {
        this(collection, collection2, new DefaultTextProvider(), null, n);
    }

    public CheckBoxList(Collection<E> collection, TextProvider<E> textProvider, int n) {
        this(collection, new HashSet(), textProvider, null, n);
    }

    public CheckBoxList(Collection<E> collection) {
        this(collection, new DefaultTextProvider(), 0);
    }

    public CheckBoxList(Collection<E> collection, TextProvider<E> textProvider) {
        this(collection, textProvider, 0);
    }

    public void setElements(Collection<E> collection) {
        this.setElements(collection, true);
    }

    public void setElements(Collection<E> collection, boolean bl) {
        if (bl) {
            this.setElements(collection, new HashSet());
        } else {
            this.setElements(collection, collection);
        }
    }

    public void setElements(Collection<E> collection, Collection<E> collection2) {
        this.items = new ArrayList<E>(collection);
        Object[][] objectArray = new Object[collection.size()][1];
        for (int i = 0; i < collection.size(); ++i) {
            objectArray[i][0] = this.items.get(i);
        }
        this.elements.clear();
        this.checked.clear();
        this.unchecked.clear();
        this.elements.addAll(collection);
        this.checked.addAll(collection);
        this.checked.removeAll(collection2);
        this.unchecked.addAll(collection2);
        if (objectArray.length > 0) {
            this.selected = objectArray[0];
        }
        this.checkBoxList.setModel(new DefaultTableModel(objectArray, new String[]{""}));
    }

    public void update() {
        ((DefaultTableModel)this.checkBoxList.getModel()).fireTableStructureChanged();
    }

    public void removeItem(Object object) {
        HashSet<E> hashSet = new HashSet<E>(this.elements);
        HashSet<E> hashSet2 = new HashSet<E>(this.unchecked);
        hashSet.remove(object);
        hashSet2.remove(object);
        this.setElements(hashSet, hashSet2);
    }

    public void setRemovable(boolean bl) {
        this.removeable = bl;
        this.update();
    }

    @Override
    public void setEnabled(boolean bl) {
        this.checkBoxList.setEnabled(bl);
    }

    public void setDisabledTooltip(String string) {
        this.disabledTooltip = string;
    }

    public String getDisabledTooltip() {
        return this.disabledTooltip;
    }

    private static void ensureRowVisible(JTable jTable, int n) {
        if (n != -1) {
            Rectangle rectangle = jTable.getCellRect(n, 0, false);
            Rectangle rectangle2 = jTable.getVisibleRect();
            if (!rectangle2.intersects(rectangle)) {
                jTable.scrollRectToVisible(rectangle);
            }
        }
    }

    public void ensureRowVisible(E e) {
        int n;
        if (e == null) {
            throw new IllegalArgumentException();
        }
        for (n = 0; n < this.checkBoxList.getModel().getRowCount(); ++n) {
            Object object = this.checkBoxList.getModel().getValueAt(n, 0);
            if (object == null) {
                return;
            }
            if (object.equals(e)) break;
        }
        CheckBoxList.ensureRowVisible(this.checkBoxList, n);
    }

    public void setItemSelected(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        this.selected = e;
        this.ensureRowVisible(e);
        this.editor.notifyChange();
        this.update();
    }

    public boolean setItemChecked(E e) {
        if (e == null) {
            throw new IllegalArgumentException();
        }
        if (!this.checked.contains(e)) {
            this.checked.add(e);
            this.unchecked.remove(e);
        }
        this.bolded.add(e);
        this.update();
        this.ensureRowVisible(e);
        new Timer(2000, new BoldRemoveListener(e)).start();
        return true;
    }

    public void setItemsEnabled(Set<E> set, boolean bl) {
        if (bl) {
            HashSet<E> hashSet = new HashSet<E>(this.checked);
            hashSet.retainAll(set);
            hashSet.retainAll(this.disabled);
            this.checked.removeAll(hashSet);
            this.unchecked.addAll(hashSet);
            this.disabled.removeAll(set);
        } else {
            this.disabled.addAll(set);
        }
        this.update();
    }

    public void setItemsChecked(Set<E> set, boolean bl) {
        if (bl) {
            this.unchecked.removeAll(set);
            this.checked.addAll(set);
        } else {
            this.unchecked.addAll(set);
            this.checked.removeAll(set);
        }
        this.update();
    }

    @Override
    public boolean isEnabled() {
        if (this.checkBoxList != null) {
            return this.checkBoxList.isEnabled();
        }
        return false;
    }

    public void setVisibleRowCount(int n) {
        this.visibleRowCount = n;
        this.setPreferredSize(this.getPreferredScrollableViewportSize());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.visibleRowCount > 0 && this.items.size() > 0 ? new Dimension(this.getPreferredSize().width, this.visibleRowCount * this.checkBoxList.getRowHeight()) : this.getPreferredSize();
    }

    public void setSelectionListener(CheckBoxListSelectionListener checkBoxListSelectionListener) {
        this.selectionListener = checkBoxListSelectionListener;
    }

    public void setCheckChangeListener(CheckBoxListCheckChangeListener<?> checkBoxListCheckChangeListener) {
        this.checkListener = checkBoxListCheckChangeListener;
    }

    public void setTextProvider(TextProvider<E> textProvider) {
        if (textProvider == null) {
            throw new NullPointerException("provider must not be null");
        }
        TextProvider<E> textProvider2 = this.provider;
        this.provider = textProvider;
        this.firePropertyChange(TEXT_PROVIDER_PROPERTY, textProvider2, this.provider);
    }

    public List<E> getCheckedElements() {
        if (this.checkBoxList.isEnabled() && this.checked.size() > 0) {
            HashSet<E> hashSet = new HashSet<E>(this.checked);
            hashSet.removeAll(this.disabled);
            return new LinkedList<E>(hashSet);
        }
        return Collections.emptyList();
    }

    public List<E> getUncheckedElements() {
        if (!this.checkBoxList.isEnabled()) {
            return new LinkedList<E>(this.elements);
        }
        HashSet<E> hashSet = new HashSet<E>(this.checked);
        hashSet.retainAll(this.disabled);
        if (this.unchecked.size() > 0) {
            HashSet<E> hashSet2 = new HashSet<E>(this.unchecked);
            hashSet2.addAll(hashSet);
            return new LinkedList<E>(hashSet2);
        }
        return new LinkedList<E>(hashSet);
    }

    public Set<E> getElements() {
        return new HashSet<E>(this.elements);
    }

    public Set<E> getRawUncheckedElementsAsSet() {
        return new HashSet<E>(this.unchecked);
    }

    public Action[] getActions() {
        return new Action[]{new SelectAllAction(), new DeselectAllAction()};
    }

    private void initialize() {
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.editor = new CheckBoxCellEditor();
        this.checkBoxList = new CustomJTable();
        this.checkBoxList.setDefaultRenderer(Object.class, new CheckBoxCellRenderer());
        this.checkBoxList.setDefaultEditor(Object.class, this.editor);
        this.checkBoxList.setRowHeight(22);
        this.checkBoxList.setTableHeader(new JTableHeader());
        this.checkBoxList.getTableHeader().setVisible(false);
        this.checkBoxList.getTableHeader().setSize(0, 0);
        this.scrollPane = new JScrollPane(this.checkBoxList);
        this.add(this.scrollPane);
        this.updateUI();
    }

    private void updateRowHeight() {
        int n = ThemeSettings.FONT_SIZE_INCREMENT.getValue();
        if (n != 0) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            this.checkBoxList.setRowHeight(Math.max(fontMetrics.getHeight() + 5, 24));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.checkBoxList == null) {
            return;
        }
        this.updateRowHeight();
        this.setBackground(UIManager.getColor("List.textBackground"));
        this.checkBoxList.setBackground(UIManager.getColor("List.background"));
        this.checkBoxList.setGridColor(UIManager.getColor("List.background"));
        this.scrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
    }

    private class IconDataCheckBox
    extends BoxPanel {
        private static final long serialVersionUID = 7370736947464891601L;
        private E obj;
        private JCheckBox checkBox;
        private JLabel label;
        private com.limegroup.gnutella.gui.CheckBoxList$IconDataCheckBox.DeleteButton button;
        private Border blankBorder;
        private SeperatorBorder sepBorder;
        private Font originalFont;
        private Font boldFont;

        public IconDataCheckBox() {
            super(0);
            this.sepBorder = new SeperatorBorder();
            this.blankBorder = BorderFactory.createMatteBorder(4, 4, 4, 4, (Icon)null);
            this.label = new JLabel();
            this.label.setBorder(this.blankBorder);
            this.checkBox = new JCheckBox("", true);
            this.button = new DeleteButton();
            this.add(Box.createHorizontalStrut(4));
            this.add(this.checkBox);
            this.add(this.label);
            this.add(Box.createHorizontalStrut(1));
            this.add(Box.createHorizontalGlue());
            this.add((Component)this.button);
            this.updateLook();
            this.originalFont = this.label.getFont();
            this.boldFont = this.originalFont.deriveFont(this.originalFont.getStyle() | 1 | 2);
        }

        public void setRemovable(boolean bl) {
            this.button.setVisible(bl);
        }

        public void setData(E e) {
            this.obj = e;
            String string = CheckBoxList.this.provider.getText(e);
            this.label.setIcon(CheckBoxList.this.provider.getIcon(e));
            if (CheckBoxList.this.extrasProvider != null) {
                this.label.setText(string + " " + CheckBoxList.this.extrasProvider.getComment(e));
                if (CheckBoxList.this.extrasProvider.isSeparated(e)) {
                    this.label.setBorder(this.sepBorder);
                } else {
                    this.label.setBorder(this.blankBorder);
                }
            } else {
                this.label.setText(string);
            }
            this.setToolTipText(CheckBoxList.this.provider.getToolTipText(e));
        }

        public void setHighlight(boolean bl) {
            this.button.setHighlight(bl);
            if (bl) {
                this.setToolTipText("Remove...");
            } else {
                this.setToolTipText(CheckBoxList.this.provider.getToolTipText(this.obj));
            }
        }

        public void setSelected(boolean bl) {
            this.checkBox.setSelected(bl);
        }

        @Override
        public void setEnabled(boolean bl) {
            this.checkBox.setEnabled(bl);
            this.label.setEnabled(bl);
        }

        @Override
        public void setForeground(Color color) {
            if (this.label != null) {
                this.label.setForeground(color);
            }
        }

        public void setBold(boolean bl) {
            if (bl) {
                this.label.setFont(this.boldFont);
            } else {
                this.label.setFont(this.originalFont);
            }
        }

        private void updateLook() {
            this.setOpaque(true);
            this.setForeground(UIManager.getColor("List.foreground"));
            this.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setBackground(UIManager.getColor("List.background"));
            this.checkBox.setForeground(UIManager.getColor("List.foreground"));
            this.checkBox.setFont(UIManager.getFont("Table.font"));
            this.checkBox.setOpaque(false);
            this.label.setBackground(UIManager.getColor("List.background"));
            this.label.setForeground(UIManager.getColor("List.foreground"));
            this.label.setFont(UIManager.getFont("Table.font"));
            this.label.setOpaque(false);
        }

        public void addActionListener(ActionListener actionListener2) {
            this.checkBox.addActionListener(actionListener2);
        }

        public void addTopMouseListener(MouseListener mouseListener) {
            this.addMouseListener(mouseListener);
            this.label.addMouseListener(mouseListener);
        }

        private class DeleteButton
        extends JButton {
            private static final long serialVersionUID = 2099563643830495610L;
            private Icon iconReg = GUIMediator.getThemeImage("delete_small");
            private Icon iconHi = GUIMediator.getThemeImage("delete_small_hi");

            public DeleteButton() {
                this.setIcon(this.iconReg);
                this.setMargin(new Insets(0, 0, 0, 0));
                this.setBorder(BorderFactory.createEmptyBorder());
                this.setContentAreaFilled(false);
                this.setVisible(false);
                this.addMouseListener(new MouseListener(){

                    @Override
                    public void mouseClicked(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mouseExited(MouseEvent mouseEvent) {
                    }

                    @Override
                    public void mousePressed(MouseEvent mouseEvent) {
                        CheckBoxList.this.removeItem(IconDataCheckBox.this.obj);
                    }

                    @Override
                    public void mouseReleased(MouseEvent mouseEvent) {
                    }
                });
            }

            public void setHighlight(boolean bl) {
                if (bl) {
                    this.setIcon(this.iconHi);
                } else {
                    this.setIcon(this.iconReg);
                }
            }
        }
    }

    public static interface TextProvider<E> {
        public String getText(E var1);

        public String getToolTipText(E var1);

        public Icon getIcon(E var1);
    }

    public static interface ExtrasProvider<E> {
        public boolean isSeparated(E var1);

        public String getComment(E var1);
    }

    public static interface CheckBoxListCheckChangeListener<E> {
        public void valueChanged(CheckBoxListCheckChangeEvent<E> var1);
    }

    public static interface CheckBoxListSelectionListener {
        public void valueChanged(CheckBoxListSelectionEvent var1);
    }

    public static class CheckBoxListCheckChangeEvent<E>
    extends EventObject {
        private static final long serialVersionUID = -2715339837857605924L;
        private E selected;
        private boolean checked;

        public CheckBoxListCheckChangeEvent(Object object, E e, boolean bl) {
            super(object);
            this.selected = e;
            this.checked = bl;
        }

        public E getSelected() {
            return this.selected;
        }

        public boolean getChecked() {
            return this.checked;
        }
    }

    public static class CheckBoxListSelectionEvent
    extends EventObject {
        private static final long serialVersionUID = 6985964072155472329L;
        private Object selected;

        public CheckBoxListSelectionEvent(Object object, Object object2) {
            super(object);
            this.selected = object2;
        }

        public Object getSelected() {
            return this.selected;
        }
    }

    private class CheckBoxCellEditor
    extends DefaultCellEditor {
        private static final long serialVersionUID = 8487646158995389360L;
        private com.limegroup.gnutella.gui.CheckBoxList$CheckBoxCellEditor.CustomEditorDelegate customDelegate;

        public CheckBoxCellEditor() {
            super(new JCheckBox());
            IconDataCheckBox iconDataCheckBox = new IconDataCheckBox();
            this.editorComponent = iconDataCheckBox;
            iconDataCheckBox.setRequestFocusEnabled(false);
            this.customDelegate = new CustomEditorDelegate();
            this.delegate = this.customDelegate;
            iconDataCheckBox.addActionListener((ActionListener)this.customDelegate);
            iconDataCheckBox.addTopMouseListener((MouseListener)this.customDelegate);
        }

        public void notifyChange() {
            this.customDelegate.notifyChange();
        }

        @Override
        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            this.delegate.setValue(object);
            return this.editorComponent;
        }

        private class CustomEditorDelegate
        extends DefaultCellEditor.EditorDelegate
        implements MouseListener {
            private static final long serialVersionUID = -7007164079207676831L;
            private Object lastValue;

            public CustomEditorDelegate() {
                super(CheckBoxCellEditor.this);
                this.lastValue = this.value;
            }

            public void notifyChange() {
                this.lastValue = null;
            }

            @Override
            public void setValue(Object object) {
                boolean bl;
                if (object == null) {
                    return;
                }
                IconDataCheckBox iconDataCheckBox = (IconDataCheckBox)CheckBoxCellEditor.this.editorComponent;
                iconDataCheckBox.setData(object);
                iconDataCheckBox.setRemovable(CheckBoxList.this.removeable);
                iconDataCheckBox.setEnabled(CheckBoxList.this.isEnabled());
                if (CheckBoxList.this.disabled.contains(object)) {
                    if (CheckBoxList.this.disabledTooltip != null) {
                        iconDataCheckBox.setToolTipText(CheckBoxList.this.disabledTooltip);
                    }
                    iconDataCheckBox.setEnabled(false);
                    iconDataCheckBox.setSelected(false);
                    this.value = object;
                    return;
                }
                CheckBoxList.this.selected = object;
                if (this.lastValue == object) {
                    bl = true;
                } else {
                    bl = false;
                    CheckBoxList.this.repaint();
                    if (CheckBoxList.this.selectionListener != null) {
                        CheckBoxList.this.selectionListener.valueChanged(new CheckBoxListSelectionEvent(CheckBoxList.this.parent, object));
                    }
                }
                if (CheckBoxList.this.selectOff || bl) {
                    boolean bl2 = CheckBoxList.this.unchecked.contains(object);
                    if (bl2) {
                        CheckBoxList.this.unchecked.remove(object);
                        CheckBoxList.this.checked.add(object);
                    } else {
                        CheckBoxList.this.unchecked.add(object);
                        CheckBoxList.this.checked.remove(object);
                    }
                    if (CheckBoxList.this.checkListener != null) {
                        CheckBoxList.this.checkListener.valueChanged(new CheckBoxListCheckChangeEvent<Object>(CheckBoxList.this.parent, object, bl2));
                    }
                }
                iconDataCheckBox.setSelected(CheckBoxList.this.checked.contains(object));
                this.lastValue = object;
                this.value = object;
            }

            @Override
            public Object getCellEditorValue() {
                return this.value;
            }

            @Override
            public boolean shouldSelectCell(EventObject eventObject) {
                return false;
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.stopCellEditing();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        }
    }

    private class CheckBoxCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = -8209871264709364379L;
        private IconDataCheckBox checkBox;

        private CheckBoxCellRenderer() {
            this.checkBox = new IconDataCheckBox();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object != null) {
                this.checkBox.setData(object);
            }
            this.checkBox.setRemovable(CheckBoxList.this.removeable);
            this.checkBox.setHighlight(n == CheckBoxList.this.highLightedRow);
            if (!CheckBoxList.this.selectOff && object != null && object.equals(CheckBoxList.this.selected)) {
                this.checkBox.setBackground(UIManager.getColor("List.selectionBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.selectionForeground"));
            } else {
                this.checkBox.setBackground(UIManager.getColor("List.textBackground"));
                this.checkBox.setForeground(UIManager.getColor("List.textForeground"));
            }
            if (CheckBoxList.this.bolded.contains(object)) {
                this.checkBox.setBold(true);
            } else {
                this.checkBox.setBold(false);
            }
            if (CheckBoxList.this.disabled.contains(object)) {
                if (CheckBoxList.this.disabledTooltip != null) {
                    this.checkBox.setToolTipText(CheckBoxList.this.disabledTooltip);
                }
                this.checkBox.setEnabled(false);
                this.checkBox.setSelected(false);
            } else {
                this.checkBox.setSelected(!CheckBoxList.this.unchecked.contains(object));
                this.checkBox.setEnabled(jTable.isEnabled());
            }
            return this.checkBox;
        }
    }

    private class CustomJTable
    extends JTable {
        private static final long serialVersionUID = 2839028569443961323L;

        private CustomJTable() {
        }

        private void shift(int n) {
            if (n != CheckBoxList.this.highLightedRow) {
                CheckBoxList.this.highLightedRow = n;
                CheckBoxList.this.repaint();
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            if (CheckBoxList.this.removeable) {
                int n = this.rowAtPoint(mouseEvent.getPoint());
                Rectangle rectangle = this.getCellRect(n, 0, false);
                Rectangle rectangle2 = this.getCellRect(n, this.getColumnCount() - 1, false);
                Rectangle rectangle3 = rectangle.union(rectangle2);
                if ((double)mouseEvent.getX() > rectangle3.getWidth() - 16.0) {
                    this.shift(n);
                } else {
                    this.shift(-1);
                }
            }
            super.processMouseMotionEvent(mouseEvent);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (CheckBoxList.this.removeable) {
                this.shift(-1);
            }
            super.processMouseEvent(mouseEvent);
        }
    }

    private class DeselectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -7666969710559350155L;

        public DeselectAllAction() {
            this.putValue("Name", I18n.tr("Deselect All"));
            this.putValue("ShortDescription", I18n.tr("Deselects all Items in the List"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CheckBoxList.this.unchecked.addAll(CheckBoxList.this.checked);
            CheckBoxList.this.checked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    private class SelectAllAction
    extends AbstractAction {
        private static final long serialVersionUID = -8173830762677196193L;

        public SelectAllAction() {
            this.putValue("Name", I18n.tr("Select All"));
            this.putValue("ShortDescription", I18n.tr("Marks all Items as Selected"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CheckBoxList.this.checked.addAll(CheckBoxList.this.unchecked);
            CheckBoxList.this.unchecked.clear();
            CheckBoxList.this.scrollPane.setVisible(false);
            CheckBoxList.this.scrollPane.setVisible(true);
        }
    }

    public static class DefaultTextProvider<E>
    implements TextProvider<E> {
        @Override
        public String getText(E e) {
            return e.toString();
        }

        @Override
        public String getToolTipText(E e) {
            return null;
        }

        @Override
        public Icon getIcon(E e) {
            return null;
        }
    }

    private class BoldRemoveListener
    implements ActionListener {
        private E key;

        public BoldRemoveListener(E e) {
            this.key = e;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CheckBoxList.this.bolded.remove(this.key);
            CheckBoxList.this.update();
        }
    }
}

