/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.CheckBoxList;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Box;
import javax.swing.JScrollPane;
import javax.swing.UIManager;

public class CheckBoxListPanel<E>
extends BoxPanel {
    private static final long serialVersionUID = 1989311176988471587L;
    private CheckBoxList<E> list;

    public CheckBoxListPanel(Collection<E> collection, CheckBoxList.TextProvider<E> textProvider, boolean bl) {
        this.list = new CheckBoxList<E>(collection, textProvider, bl, 1);
        this.initialize();
    }

    public CheckBoxListPanel(Collection<E> collection) {
        this.list = new CheckBoxList<E>(collection);
        this.initialize();
    }

    public CheckBoxListPanel() {
        this.list = new CheckBoxList(Collections.emptyList());
        this.initialize();
    }

    private void initialize() {
        InternalJScrollPane internalJScrollPane = new InternalJScrollPane(this.list);
        internalJScrollPane.getViewport().setBackground(UIManager.getColor("List.background"));
        this.add(internalJScrollPane);
        this.add(Box.createVerticalStrut(6));
        this.add(new ButtonRow(this.list.getActions(), 0, 12));
    }

    public List<E> getSelectedElements() {
        return this.list.getCheckedElements();
    }

    public CheckBoxList<E> getList() {
        return this.list;
    }

    private class InternalJScrollPane
    extends JScrollPane {
        private static final long serialVersionUID = 5346177338334373472L;

        public InternalJScrollPane(Component component) {
            super(component);
            this.getViewport().setBackground(UIManager.getColor("List.background"));
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.getViewport().setBackground(UIManager.getColor("List.background"));
        }
    }
}

