/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.UIManager;
import javax.swing.text.Document;
import org.limewire.util.OSUtils;

public class ClearableAutoCompleteTextField
extends AutoCompleteTextField {
    private static final long serialVersionUID = -8501269106544016677L;
    protected AutoCompleteList entryList;
    protected JPanel entryPanel;
    protected Popup popup;
    protected boolean showPending;

    public ClearableAutoCompleteTextField() {
        this.init();
    }

    public ClearableAutoCompleteTextField(Document document, String string, int n) {
        super(document, string, n);
        this.init();
    }

    public ClearableAutoCompleteTextField(int n) {
        super(n);
        this.init();
    }

    public ClearableAutoCompleteTextField(String string) {
        super(string);
        this.init();
    }

    public ClearableAutoCompleteTextField(String string, int n) {
        super(string, n);
        this.init();
    }

    private void init() {
        this.enableEvents(8L);
        this.enableEvents(32768L);
        this.enableEvents(4L);
    }

    @Override
    protected void fireActionPerformed() {
        if (this.popup != null) {
            String string = (String)this.entryList.getSelectedValue();
            this.hidePopup();
            if (string != null) {
                this.setText(string);
                return;
            }
        }
        super.fireActionPerformed();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) {
            keyEvent.consume();
        }
        super.processKeyEvent(keyEvent);
        if (this.dict != null) {
            block0 : switch (keyEvent.getID()) {
                case 401: {
                    switch (keyEvent.getKeyCode()) {
                        case 38: {
                            if (this.popup != null) {
                                this.entryList.decrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 40: {
                            if (this.popup != null) {
                                this.entryList.incrementSelection();
                                break;
                            }
                            this.showPopup(this.dict.iterator());
                            break;
                        }
                        case 27: {
                            if (this.popup == null) break;
                            this.hidePopup();
                            this.selectAll();
                        }
                    }
                    break;
                }
                case 400: {
                    switch (keyEvent.getKeyChar()) {
                        case '\n': {
                            break block0;
                        }
                    }
                    this.autoCompleteInput();
                }
            }
        }
    }

    @Override
    protected void processHierarchyEvent(HierarchyEvent hierarchyEvent) {
        super.processHierarchyEvent(hierarchyEvent);
        if ((hierarchyEvent.getChangeFlags() & 4L) == 4L) {
            boolean bl = this.isShowing();
            if (!bl && this.popup != null) {
                this.hidePopup();
            } else if (bl && this.popup == null && this.showPending) {
                this.autoCompleteInput();
            }
        }
    }

    @Override
    protected void processFocusEvent(FocusEvent focusEvent) {
        super.processFocusEvent(focusEvent);
        if (focusEvent.getID() == 1005 && this.popup != null) {
            this.hidePopup();
        }
    }

    @Override
    protected void setUp() {
    }

    protected JComponent getPopupComponent() {
        if (this.entryPanel != null) {
            return this.entryPanel;
        }
        this.entryPanel = new JPanel(new GridBagLayout());
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        this.entryList = new AutoCompleteList();
        JScrollPane jScrollPane = new JScrollPane(this.entryList);
        jScrollPane.setVerticalScrollBarPolicy(20);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)jScrollPane, gridBagConstraints);
        this.entryPanel.add((Component)new ClearHistory(), gridBagConstraints);
        return this.entryPanel;
    }

    protected void showPopup(Iterator<String> iterator) {
        this.getPopupComponent();
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        ListModel listModel = this.entryList.getModel();
        int n = 0;
        while (iterator.hasNext()) {
            String string = iterator.next();
            vector.add(string);
            if (!bl && n < listModel.getSize()) {
                bl |= !string.equals(listModel.getElementAt(n));
            }
            ++n;
        }
        if (bl |= listModel.getSize() != vector.size()) {
            this.entryList.setListData(vector);
            this.entryList.clearSelection();
        }
        this.entryList.setCurrentText(this.getText());
        this.showPopup();
    }

    public void showPopup() {
        if (this.popup == null && this.entryList.getModel().getSize() > 0) {
            if (this.isShowing()) {
                Point point = this.getLocationOnScreen();
                PopupFactory popupFactory = PopupFactory.getSharedInstance();
                JComponent jComponent = this;
                if (OSUtils.isMacOSX()) {
                    jComponent = new JPanel();
                    new MyPopup(this, jComponent, 0, 0);
                }
                this.popup = popupFactory.getPopup(jComponent, this.getPopupComponent(), point.x, point.y + this.getHeight() + 1);
                this.showPending = false;
                this.popup.show();
            } else {
                this.showPending = true;
            }
        }
    }

    public void hidePopup() {
        this.showPending = false;
        if (this.popup != null) {
            this.popup.hide();
            this.popup = null;
        }
    }

    @Override
    public void autoCompleteInput() {
        String string = this.getText();
        if (string != null && string.length() > 0) {
            Iterator<String> iterator = this.dict.iterator(string);
            if (iterator.hasNext()) {
                this.showPopup(iterator);
            } else {
                this.hidePopup();
            }
        } else {
            this.hidePopup();
        }
    }

    private static class MyPopup
    extends Popup {
        public MyPopup(Component component, Component component2, int n, int n2) {
            super(component, component2, n, n2);
        }
    }

    protected class AutoCompleteList
    extends JList {
        private static final long serialVersionUID = -7324769835640667828L;
        private String currentText;

        public AutoCompleteList() {
            this.enableEvents(16L);
            this.setSelectionMode(0);
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            int n;
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 500 && (n = this.locationToIndex(mouseEvent.getPoint())) != -1 && this.isSelectedIndex(n)) {
                String string = (String)this.getSelectedValue();
                ClearableAutoCompleteTextField.this.setText(string);
                ClearableAutoCompleteTextField.this.hidePopup();
            }
        }

        void setCurrentText(String string) {
            this.currentText = string;
        }

        void incrementSelection() {
            if (this.getSelectedIndex() == this.getModel().getSize() - 1) {
                ClearableAutoCompleteTextField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int n = this.getSelectedIndex() + 1;
                this.setSelectedIndex(n);
                this.ensureIndexIsVisible(n);
                ClearableAutoCompleteTextField.this.setText((String)this.getSelectedValue());
            }
        }

        void decrementSelection() {
            if (this.getSelectedIndex() == 0) {
                ClearableAutoCompleteTextField.this.setText(this.currentText);
                this.clearSelection();
            } else {
                int n = this.getSelectedIndex();
                n = n == -1 ? this.getModel().getSize() - 1 : --n;
                this.setSelectedIndex(n);
                this.ensureIndexIsVisible(n);
                ClearableAutoCompleteTextField.this.setText((String)this.getSelectedValue());
            }
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            int n = ClearableAutoCompleteTextField.this.getSize().width - 2;
            int n2 = Math.min(this.getModel().getSize(), 8);
            int n3 = n2 * this.getCellBounds((int)0, (int)0).height;
            return new Dimension(n, n3);
        }
    }

    private class ClearHistory
    extends JButton {
        private static final long serialVersionUID = 601999394867955024L;

        ClearHistory() {
            super(I18n.tr("Clear History"));
            this.enableEvents(16L);
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            super.processMouseEvent(mouseEvent);
            if (mouseEvent.getID() == 500) {
                ClearableAutoCompleteTextField.this.dict.clear();
                ClearableAutoCompleteTextField.this.hidePopup();
            }
        }
    }
}

