/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.alexandria.PlaylistItem;
import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.frostwire.gui.library.FileDescriptor;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioPlayerListener;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.DeviceAudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.frostwire.gui.player.StreamAudioSource;
import com.frostwire.mplayer.MediaPlaybackState;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MediaButton;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CurrentAudioStatusComponent
extends JPanel
implements AudioPlayerListener {
    private static final Log LOG = LogFactory.getLog(CurrentAudioStatusComponent.class);
    private static final int MAX_CHARS = 33;
    private static final int BOUND_CHARS = 12;
    private static final long serialVersionUID = 9206657876064353272L;
    private MediaButton shareButton;
    private Icon speakerIcon;
    private JLabel text;
    private MediaPlaybackState lastState;
    private Icon currentStatusIcon;
    private String currentStatusLabel;

    public CurrentAudioStatusComponent() {
        AudioPlayer.instance().addAudioPlayerListener(this);
        this.lastState = MediaPlaybackState.Uninitialized;
        this.initComponents();
    }

    private void initComponents() {
        Dimension dimension = new Dimension(220, 22);
        this.setPreferredSize(dimension);
        this.setMinimumSize(dimension);
        this.speakerIcon = GUIMediator.getThemeImage("speaker");
        this.text = new JLabel();
        Font font = new Font("DIALOG", 1, 10);
        this.text.setFont(font);
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (AudioPlayer.instance().getCurrentSong().getFile() != null || AudioPlayer.instance().getCurrentSong().getPlaylistItem() != null || AudioPlayer.instance().getCurrentSong() instanceof InternetRadioAudioSource || AudioPlayer.instance().getCurrentSong() instanceof DeviceAudioSource) {
                    CurrentAudioStatusComponent.this.showCurrentSong();
                } else if (AudioPlayer.instance().getCurrentSong() instanceof StreamAudioSource) {
                    StreamAudioSource streamAudioSource = (StreamAudioSource)AudioPlayer.instance().getCurrentSong();
                    if (streamAudioSource.getDetailsUrl() != null) {
                        GUIMediator.openURL(streamAudioSource.getDetailsUrl());
                    }
                } else if (AudioPlayer.instance().getCurrentSong().getURL() != null) {
                    GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
                }
            }
        });
        this.shareButton = new MediaButton(I18n.tr("Send this file to a friend"), "share", "share");
        this.shareButton.addActionListener(new SendToFriendActionListener());
        this.shareButton.setVisible(false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 3);
        this.add((Component)this.shareButton, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.text, gridBagConstraints);
    }

    public void showCurrentSong() {
        GUIMediator.instance().setWindow(GUIMediator.Tabs.LIBRARY);
        LibraryMediator.instance().selectCurrentSong();
    }

    @Override
    public void songOpened(AudioPlayer audioPlayer, AudioSource audioSource) {
        try {
            AudioSource audioSource2 = audioPlayer.getCurrentSong();
            PlaylistItem playlistItem = audioSource2.getPlaylistItem();
            String string = null;
            if (audioSource2 instanceof DeviceAudioSource) {
                FileDescriptor fileDescriptor = ((DeviceAudioSource)audioSource2).getFileDescriptor();
                String string2 = fileDescriptor.artist;
                String string3 = fileDescriptor.title;
                String string4 = fileDescriptor.album;
                String string5 = fileDescriptor.year;
                string = string2 + " - " + string3;
                this.text.setToolTipText(string2 + " - " + string3 + string4 + string5);
            } else if (audioSource2 != null && audioSource2 instanceof StreamAudioSource) {
                string = ((StreamAudioSource)audioSource2).getTitle();
            } else if (playlistItem != null) {
                String string6 = playlistItem.getTrackArtist();
                String string7 = playlistItem.getTrackTitle();
                String string8 = playlistItem.getTrackAlbum() != null && playlistItem.getTrackAlbum().length() > 0 ? " - " + playlistItem.getTrackAlbum() : "";
                String string9 = playlistItem.getTrackYear() != null && playlistItem.getTrackYear().length() > 0 ? " (" + playlistItem.getTrackYear() + ")" : "";
                string = string6 + " - " + string7;
                this.text.setToolTipText(string6 + " - " + string7 + string8 + string9);
            } else if (audioSource2 != null && audioSource2.getFile() != null) {
                string = audioSource2.getFile().getName();
                this.text.setToolTipText(audioSource2.getFile().getAbsolutePath());
            } else if (audioSource2 != null && audioSource2.getFile() == null && audioSource2.getURL() != null) {
                System.out.println("StreamURL: " + audioSource2.getURL().toString());
                string = "internet ";
            }
            this.currentStatusIcon = this.speakerIcon;
            this.currentStatusLabel = string;
        }
        catch (Throwable throwable) {
            LOG.error("Error doing UI updates", throwable);
        }
    }

    @Override
    public void progressChange(AudioPlayer audioPlayer, float f) {
    }

    @Override
    public void volumeChange(AudioPlayer audioPlayer, double d) {
    }

    @Override
    public void stateChange(AudioPlayer audioPlayer, MediaPlaybackState mediaPlaybackState) {
        if (this.lastState == mediaPlaybackState) {
            return;
        }
        this.lastState = mediaPlaybackState;
        if (mediaPlaybackState != MediaPlaybackState.Playing && mediaPlaybackState != MediaPlaybackState.Paused) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    CurrentAudioStatusComponent.this.text.setIcon(null);
                    CurrentAudioStatusComponent.this.text.setText("");
                    CurrentAudioStatusComponent.this.shareButton.setVisible(false);
                }
            });
        } else {
            this.setupIconAndText(this.currentStatusIcon, this.currentStatusLabel);
        }
    }

    private void setupIconAndText(Icon icon, String string) {
        if (string.length() > 33) {
            string = string.substring(0, 12) + " ... " + string.substring(string.length() - 12);
        }
        final String string2 = string;
        AudioSource audioSource = AudioPlayer.instance().getCurrentSong();
        this.shareButton.setVisible(audioSource != null && (audioSource.getFile() != null || audioSource.getPlaylistItem() != null && audioSource.getPlaylistItem().getFilePath() != null && new File(audioSource.getPlaylistItem().getFilePath()).exists()));
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                CurrentAudioStatusComponent.this.text.setIcon(CurrentAudioStatusComponent.this.speakerIcon);
                CurrentAudioStatusComponent.this.text.setText("<html><font color=\"496989\"><u>" + string2 + "</u></font></html>");
            }
        });
    }

    @Override
    public void icyInfo(AudioPlayer audioPlayer, String string) {
        for (String string2 : string.split(";")) {
            if (!string2.startsWith("StreamTitle=")) continue;
            try {
                String string3 = string2.substring(13, string2.length() - 1);
                this.currentStatusIcon = this.speakerIcon;
                this.currentStatusLabel = "radio " + string3;
                this.setupIconAndText(this.currentStatusIcon, this.currentStatusLabel);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            break;
        }
    }

    private final class SendToFriendActionListener
    implements ActionListener {
        private SendToFriendActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AudioSource audioSource = AudioPlayer.instance().getCurrentSong();
            if (audioSource == null) {
                return;
            }
            File file = null;
            if (audioSource.getFile() != null) {
                file = audioSource.getFile();
            } else if (audioSource.getPlaylistItem() != null && audioSource.getPlaylistItem().getFilePath() != null) {
                file = new File(audioSource.getPlaylistItem().getFilePath());
            }
            if (file == null) {
                return;
            }
            String string = file.isFile() ? I18n.tr("file") : I18n.tr("folder");
            int n = JOptionPane.showConfirmDialog(GUIMediator.getAppFrame(), I18n.tr("Do you want to send this {0} to a friend?", string) + "\n\n\"" + file.getName() + "\"", I18n.tr("Send files with FrostWire"), 0, 3);
            if (n == 0) {
                new SendFileProgressDialog(GUIMediator.getAppFrame(), file).setVisible(true);
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        }
    }
}

