/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.bugs.DeadlockBugManager;
import com.limegroup.gnutella.gui.bugs.DeadlockException;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.util.VersionUtils;

public class DeadlockSupport {
    private static Log LOG = LogFactory.getLog(DeadlockSupport.class);
    private static final int DEADLOCK_CHECK_INTERVAL = 3001;

    public static void startDeadlockMonitoring() {
        Thread thread = ThreadExecutor.newManagedThread(new Runnable(){

            @Override
            public void run() {
                long[] lArray;
                while (true) {
                    try {
                        Thread.sleep(3001L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    LOG.trace("deadlock check start");
                    lArray = DeadlockSupport.findDeadlockedThreads(ManagementFactory.getThreadMXBean());
                    if (lArray != null) break;
                    LOG.trace("no deadlocks found");
                }
                StringBuilder stringBuilder = new StringBuilder("Deadlock Report:\n");
                StackTraceElement[] stackTraceElementArray = null;
                ThreadInfo[] threadInfoArray = DeadlockSupport.getThreadInfo(lArray);
                for (ThreadInfo threadInfo : threadInfoArray) {
                    stringBuilder.append("\"" + threadInfo.getThreadName() + "\" (id=" + threadInfo.getThreadId() + ")");
                    stringBuilder.append(" " + (Object)((Object)threadInfo.getThreadState()) + " on " + threadInfo.getLockName() + " owned by ");
                    stringBuilder.append("\"" + threadInfo.getLockOwnerName() + "\" (id=" + threadInfo.getLockOwnerId() + ")");
                    if (threadInfo.isSuspended()) {
                        stringBuilder.append(" (suspended)");
                    }
                    if (threadInfo.isInNative()) {
                        stringBuilder.append(" (in native)");
                    }
                    stringBuilder.append("\n");
                    StackTraceElement[] stackTraceElementArray2 = threadInfo.getStackTrace();
                    if (stackTraceElementArray == null) {
                        stackTraceElementArray = stackTraceElementArray2;
                    }
                    for (int i = 0; i < stackTraceElementArray2.length; ++i) {
                        stringBuilder.append("\tat " + stackTraceElementArray2[i].toString() + "\n");
                        if (i == 0) {
                            DeadlockSupport.addLockInfo(threadInfo, stringBuilder);
                        }
                        DeadlockSupport.addMonitorInfo(threadInfo, stringBuilder, i);
                    }
                    DeadlockSupport.addLockedSynchronizers(threadInfo, stringBuilder);
                    stringBuilder.append("\n");
                }
                DeadlockException deadlockException = new DeadlockException();
                if (stackTraceElementArray != null) {
                    deadlockException.setStackTrace(stackTraceElementArray);
                }
                DeadlockBugManager.handleDeadlock(deadlockException, Thread.currentThread().getName(), stringBuilder.toString());
            }
        });
        thread.setDaemon(true);
        thread.setName("Deadlock Detection Thread");
        thread.start();
    }

    private static void addLockedSynchronizers(ThreadInfo threadInfo, StringBuilder stringBuilder) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                int n;
                Method method = ThreadInfo.class.getMethod("getLockedSynchronizers", new Class[0]);
                Object object = method.invoke((Object)threadInfo, new Object[0]);
                if (object != null && (n = Array.getLength(object)) > 0) {
                    stringBuilder.append("\n\tNumber of locked synchronizers = " + n + "\n");
                    for (int i = 0; i < n; ++i) {
                        stringBuilder.append("\t- " + Array.get(object, i) + "\n");
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.trace("Error retrieving locked synchronizers", throwable);
            }
        }
    }

    private static void addMonitorInfo(ThreadInfo threadInfo, StringBuilder stringBuilder, int n) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method method = ThreadInfo.class.getMethod("getLockedMonitors", new Class[0]);
                Object object = method.invoke((Object)threadInfo, new Object[0]);
                if (object != null) {
                    Class<?> clazz = Class.forName("java.lang.management.MonitorInfo");
                    int n2 = Array.getLength(object);
                    for (int i = 0; i < n2; ++i) {
                        Object object2 = Array.get(object, i);
                        Method method2 = clazz.getMethod("getLockedStackDepth", new Class[0]);
                        Object object3 = method2.invoke(object2, new Object[0]);
                        if (object3 == null || !object3.equals(n)) continue;
                        stringBuilder.append("\t-  locked " + object2 + "\n");
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.trace("Error retrieving monitor info", throwable);
            }
        }
    }

    private static void addLockInfo(ThreadInfo threadInfo, StringBuilder stringBuilder) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method method = ThreadInfo.class.getMethod("getLockInfo", new Class[0]);
                Object object = method.invoke((Object)threadInfo, new Object[0]);
                if (object != null) {
                    Thread.State state = threadInfo.getThreadState();
                    switch (state) {
                        case BLOCKED: {
                            stringBuilder.append("\t-  blocked on " + object + "\n");
                            break;
                        }
                        case WAITING: 
                        case TIMED_WAITING: {
                            stringBuilder.append("\t-  waiting on " + object + "\n");
                            break;
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                LOG.trace("Error calling getLockInfo", throwable);
            }
        }
    }

    private static long[] findDeadlockedThreads(ThreadMXBean threadMXBean) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method method = ThreadMXBean.class.getMethod("findDeadlockedThreads", new Class[0]);
                Object object = method.invoke((Object)threadMXBean, new Object[0]);
                if (object instanceof long[] || object == null) {
                    return (long[])object;
                }
            }
            catch (Throwable throwable) {
                LOG.error("Error calling findDeadlockedthreads", throwable);
            }
        }
        return threadMXBean.findMonitorDeadlockedThreads();
    }

    private static ThreadInfo[] getThreadInfo(long[] lArray) {
        if (VersionUtils.isJava16OrAbove()) {
            try {
                Method method = ThreadMXBean.class.getDeclaredMethod("getThreadInfo", long[].class, Boolean.TYPE, Boolean.TYPE);
                Object object = method.invoke((Object)ManagementFactory.getThreadMXBean(), lArray, true, true);
                return (ThreadInfo[])object;
            }
            catch (Throwable throwable) {
                LOG.trace("Error retrieving detailed thread info", throwable);
            }
        }
        return ManagementFactory.getThreadMXBean().getThreadInfo(lArray, Integer.MAX_VALUE);
    }
}

