/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.bugs.BugManager;
import org.limewire.service.ErrorCallback;

public final class ErrorHandler
implements ErrorCallback {
    @Override
    public void error(Throwable throwable) {
        this.error(throwable, null);
    }

    @Override
    public void error(Throwable throwable, String string) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        Error error = new Error(throwable, string);
        GUIMediator.safeInvokeLater(error);
    }

    private static class Error
    implements Runnable {
        private final Throwable PROBLEM;
        private final String MESSAGE;
        private final String CURRENT_THREAD_NAME;

        private Error(Throwable throwable, String string) {
            this.PROBLEM = throwable;
            this.MESSAGE = string;
            this.CURRENT_THREAD_NAME = Thread.currentThread().getName();
        }

        @Override
        public void run() {
            try {
                GUIMediator.closeStartupDialogs();
                BugManager.instance().handleBug(this.PROBLEM, this.CURRENT_THREAD_NAME, this.MESSAGE);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

