/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MacUtils;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public final class FileChooserHandler {
    private FileChooserHandler() {
    }

    public static File getLastInputDirectory() {
        File file = ApplicationSettings.LAST_FILECHOOSER_DIRECTORY.getValue();
        if (file == null || file.getPath().equals("") || !file.exists() || !file.isDirectory()) {
            return CommonUtils.getCurrentDirectory();
        }
        return file;
    }

    public static void setLastInputDirectory(File file) {
        if (file != null) {
            if (!file.exists() || !file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null && file.exists() && file.isDirectory()) {
                ApplicationSettings.LAST_FILECHOOSER_DIRECTORY.setValue(file);
            }
        }
    }

    public static File getInputDirectory() {
        return FileChooserHandler.getInputDirectory(GUIMediator.getAppFrame());
    }

    public static File getInputDirectory(Component component) {
        return FileChooserHandler.getInputDirectory(component, I18nMarker.marktr("Select Folder"), FileChooserHandler.getLastInputDirectory());
    }

    public static File getInputDirectory(Component component, File file) {
        return FileChooserHandler.getInputDirectory(component, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), file);
    }

    public static File getInputDirectory(Component component, File file, FileFilter fileFilter) {
        return FileChooserHandler.getInputDirectory(component, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), file, fileFilter);
    }

    public static File getInputDirectory(Component component, String string, File file) {
        return FileChooserHandler.getInputDirectory(component, string, I18nMarker.marktr("Select"), file);
    }

    public static File getInputDirectory(Component component, String string, File file, FileFilter fileFilter) {
        return FileChooserHandler.getInputDirectory(component, string, I18nMarker.marktr("Select"), file, fileFilter);
    }

    public static File getInputDirectory(Component component, String string, String string2, File file) {
        return FileChooserHandler.getInputDirectory(component, string, string2, file, null);
    }

    public static File getInputDirectory(Component component, String string, String string2, File file, FileFilter fileFilter) {
        List<File> list = FileChooserHandler.getInput(component, string, string2, file, 1, 0, false, fileFilter);
        assert (list == null || list.size() <= 1) : "selected more than one folder: " + list;
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public static File getInputFile() {
        return FileChooserHandler.getInputFile(GUIMediator.getAppFrame());
    }

    public static File getInputFile(Component component) {
        return FileChooserHandler.getInputFile(component, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory());
    }

    public static File getInputFile(Component component, FileFilter fileFilter) {
        return FileChooserHandler.getInputFile(component, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory(), fileFilter);
    }

    public static File getInputFile(Component component, String string, File file) {
        return FileChooserHandler.getInputFile(component, string, I18nMarker.marktr("Select"), file);
    }

    public static File getInputFile(Component component, String string, File file, FileFilter fileFilter) {
        return FileChooserHandler.getInputFile(component, string, I18nMarker.marktr("Select"), file, fileFilter);
    }

    public static File getInputFile(Component component, String string, String string2, File file) {
        return FileChooserHandler.getInput(component, string, string2, file, 0, 0);
    }

    public static File getInputFile(Component component, String string, String string2, File file, FileFilter fileFilter) {
        List<File> list = FileChooserHandler.getInput(component, string, string2, file, 0, 0, false, fileFilter);
        assert (list == null || list.size() <= 1) : "selected more than one folder: " + list;
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public static File getInput(Component component, String string, String string2, File file, int n, int n2) {
        List<File> list = FileChooserHandler.getInput(component, string, string2, file, n, n2, false, null);
        assert (list == null || list.size() <= 1) : "selected more than one folder: " + list;
        if (list != null && list.size() == 1) {
            return list.get(0);
        }
        return null;
    }

    public static List<File> getMultiInputFile() {
        return FileChooserHandler.getMultiInputFile(GUIMediator.getAppFrame());
    }

    public static List<File> getMultiInputFile(Component component) {
        return FileChooserHandler.getMultiInputFile(component, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory());
    }

    public static List<File> getMultiInputFile(Component component, FileFilter fileFilter) {
        return FileChooserHandler.getMultiInputFile(component, I18nMarker.marktr("Select Folder"), I18nMarker.marktr("Select"), FileChooserHandler.getLastInputDirectory(), fileFilter);
    }

    public static List<File> getMultiInputFile(Component component, String string, File file) {
        return FileChooserHandler.getMultiInputFile(component, string, I18nMarker.marktr("Select"), file);
    }

    public static List<File> getMultiInputFile(Component component, String string, File file, FileFilter fileFilter) {
        return FileChooserHandler.getMultiInputFile(component, string, I18nMarker.marktr("Select"), file, fileFilter);
    }

    public static List<File> getMultiInputFile(Component component, String string, String string2, File file) {
        return FileChooserHandler.getMultiInput(component, string, string2, file, 0, 0);
    }

    public static List<File> getMultiInputFile(Component component, String string, String string2, File file, FileFilter fileFilter) {
        return FileChooserHandler.getInput(component, string, string2, file, 0, 0, true, fileFilter);
    }

    public static List<File> getMultiInput(Component component, String string, String string2, File file, int n, int n2) {
        return FileChooserHandler.getInput(component, string, string2, file, n, n2, true, null);
    }

    public static File getSaveAsFile(Component component, String string, File file) {
        return FileChooserHandler.getSaveAsFile(component, string, file, null);
    }

    public static File getSaveAsFile(Component component, String string, File file, final FileFilter fileFilter) {
        if (OSUtils.isAnyMac()) {
            Object object;
            FileDialog fileDialog = new FileDialog((Frame)GUIMediator.getAppFrame(), I18n.tr(string), 1);
            fileDialog.setDirectory(file.getParent());
            fileDialog.setFile(file.getName());
            if (fileFilter != null) {
                object = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return fileFilter.accept(new File(file, string));
                    }
                };
                fileDialog.setFilenameFilter((FilenameFilter)object);
            }
            fileDialog.setVisible(true);
            object = fileDialog.getDirectory();
            FileChooserHandler.setLastInputDirectory(new File((String)object));
            String string2 = fileDialog.getFile();
            if (object != null && string2 != null) {
                Object object2;
                if (file != null) {
                    object2 = FileUtils.getFileExtension(file);
                    String string3 = FileUtils.getFileExtension(string2);
                    if (string3 == null && object2 != null) {
                        string2 = string2 + "." + (String)object2;
                    }
                }
                object2 = new File((String)object, string2);
                if (fileFilter != null && !fileFilter.accept((File)object2)) {
                    return null;
                }
                return object2;
            }
            return null;
        }
        JFileChooser jFileChooser = FileChooserHandler.getDirectoryChooser(string, null, null, 0, fileFilter);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(component);
        File file2 = jFileChooser.getSelectedFile();
        FileChooserHandler.setLastInputDirectory(file2);
        return n != 0 ? null : file2;
    }

    public static File getSaveAsDir(Component component, String string, File file) {
        return FileChooserHandler.getSaveAsDir(component, string, file, null);
    }

    public static File getSaveAsDir(Component component, String string, File file, final FileFilter fileFilter) {
        if (OSUtils.isAnyMac()) {
            Object object;
            FileDialog fileDialog = new FileDialog((Frame)GUIMediator.getAppFrame(), I18n.tr(string), 1);
            fileDialog.setDirectory(file.getParent());
            fileDialog.setFile(file.getName());
            if (fileFilter != null) {
                object = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        return fileFilter.accept(new File(file, string));
                    }
                };
                fileDialog.setFilenameFilter((FilenameFilter)object);
            }
            fileDialog.setVisible(true);
            object = fileDialog.getDirectory();
            FileChooserHandler.setLastInputDirectory(new File((String)object));
            String string2 = fileDialog.getFile();
            if (object != null && string2 != null) {
                File file2 = new File((String)object, string2);
                if (fileFilter != null && !fileFilter.accept(file2)) {
                    return null;
                }
                return file2;
            }
            return null;
        }
        JFileChooser jFileChooser = FileChooserHandler.getDirectoryChooser(string, null, null, 1, fileFilter);
        jFileChooser.setSelectedFile(file);
        int n = jFileChooser.showSaveDialog(component);
        File file3 = jFileChooser.getSelectedFile();
        FileChooserHandler.setLastInputDirectory(file3);
        return n != 0 ? null : file3;
    }

    public static List<File> getInput(Component component, String string, String string2, File file, int n, int n2, boolean bl, final FileFilter fileFilter) {
        Object object;
        if (!OSUtils.isAnyMac()) {
            JFileChooser jFileChooser = FileChooserHandler.getDirectoryChooser(string, string2, file, n, fileFilter);
            jFileChooser.setMultiSelectionEnabled(bl);
            try {
                if (jFileChooser.showOpenDialog(component) != n2) {
                    return null;
                }
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            if (bl) {
                File[] fileArray = jFileChooser.getSelectedFiles();
                if (fileArray.length > 0) {
                    FileChooserHandler.setLastInputDirectory(fileArray[0]);
                }
                return Arrays.asList(fileArray);
            }
            File file2 = jFileChooser.getSelectedFile();
            FileChooserHandler.setLastInputDirectory(file2);
            return Collections.singletonList(file2);
        }
        FileDialog fileDialog = n == 1 ? MacUtils.getFolderDialog() : new FileDialog((Frame)GUIMediator.getAppFrame(), "");
        fileDialog.setTitle(I18n.tr(string));
        if (fileFilter != null) {
            object = new FilenameFilter(){

                @Override
                public boolean accept(File file, String string) {
                    return fileFilter.accept(new File(file, string));
                }
            };
            fileDialog.setFilenameFilter((FilenameFilter)object);
        }
        fileDialog.setVisible(true);
        object = fileDialog.getDirectory();
        String string3 = fileDialog.getFile();
        if (object == null || string3 == null) {
            return null;
        }
        FileChooserHandler.setLastInputDirectory(new File((String)object));
        File file3 = new File((String)object, string3);
        if (fileFilter != null && !fileFilter.accept(file3)) {
            return null;
        }
        return Collections.singletonList(file3);
    }

    private static JFileChooser getDirectoryChooser(String string, String string2, File file, int n, FileFilter fileFilter) {
        JFileChooser jFileChooser = null;
        if (file == null) {
            file = FileChooserHandler.getLastInputDirectory();
        }
        if (file == null) {
            jFileChooser = new JFileChooser();
        } else {
            try {
                jFileChooser = new JFileChooser(file);
            }
            catch (NullPointerException nullPointerException) {
                try {
                    jFileChooser = new JFileChooser(file);
                }
                catch (NullPointerException nullPointerException2) {
                    UIManager.getDefaults().put("FileChooserUI", "javax.swing.plaf.metal.MetalFileChooserUI");
                    jFileChooser = new JFileChooser(file);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                jFileChooser = new JFileChooser(file);
            }
        }
        if (fileFilter != null) {
            jFileChooser.setFileFilter(fileFilter);
        } else if (n == 1) {
            jFileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return true;
                }

                @Override
                public String getDescription() {
                    return I18n.tr("All Folders");
                }
            });
        }
        jFileChooser.setFileSelectionMode(n);
        String string3 = I18n.tr(string);
        jFileChooser.setDialogTitle(string3);
        if (string2 != null) {
            String string4 = I18n.tr(string2);
            jFileChooser.setApproveButtonText(string4);
        }
        return jFileChooser;
    }
}

