/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.player.AudioPlayer;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.ShutdownWindow;
import com.limegroup.gnutella.gui.bugs.BugManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.search.LocalSearchEngine;

final class Finalizer {
    private static boolean _shutdownImminent;
    private static boolean _uploadsComplete;
    private static boolean _downloadsComplete;
    private static volatile String _updateCommand;

    private Finalizer() {
    }

    static boolean isShutdownImminent() {
        return _shutdownImminent;
    }

    static void shutdown() {
        LocalSearchEngine.instance().shutdown();
        AudioPlayer.instance().stop();
        GUIMediator.applyWindowSettings();
        GUIMediator.setAppVisible(false);
        ShutdownWindow shutdownWindow = new ShutdownWindow();
        GUIUtils.centerOnScreen(shutdownWindow);
        shutdownWindow.setVisible(true);
        NotifyUserProxy.instance().hideTrayIcon();
        final String string = _updateCommand;
        Thread thread = new Thread("Shutdown Thread"){

            @Override
            public void run() {
                try {
                    BugManager.instance().shutdown();
                    GuiCoreMediator.getLifecycleManager().shutdown(string);
                    System.exit(0);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    System.exit(0);
                }
            }
        };
        thread.start();
    }

    static void flagUpdate(String string) {
        _updateCommand = string;
    }

    static void setDownloadsComplete() {
        _downloadsComplete = true;
        Finalizer.checkForShutdown();
    }

    static void setUploadsComplete() {
        _uploadsComplete = true;
        Finalizer.checkForShutdown();
    }

    private static void checkForShutdown() {
        if (_shutdownImminent && _uploadsComplete && _downloadsComplete) {
            GUIMediator.shutdown();
        }
    }

    static void addFinalizeListener(final FinalizeListener finalizeListener) {
        Thread thread = new Thread("FinalizeItem"){

            @Override
            public void run() {
                finalizeListener.doFinalize();
            }
        };
        GuiCoreMediator.getLifecycleManager().addShutdownItem(thread);
    }
}

