/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class FirewallUtils {
    private static String name = "FrostWire";

    public static boolean addToFirewall() {
        if (!OSUtils.isWindows()) {
            return false;
        }
        String string = SystemUtils.getRunningPath();
        if (string == null) {
            return false;
        }
        if (!string.equalsIgnoreCase(GUIConstants.FROSTWIRE_EXE_FILE.getAbsolutePath())) {
            return false;
        }
        if (SystemUtils.isProgramListedOnFirewall(string)) {
            return true;
        }
        if (SystemUtils.addProgramToFirewall(string, name)) {
            FirewallUtils.scheduleRemovalOnShutdown();
            return true;
        }
        return false;
    }

    public static void removeFromFirewall() {
        if (!OSUtils.isWindows()) {
            return;
        }
        String string = SystemUtils.getRunningPath();
        if (string == null || !string.equalsIgnoreCase(GUIConstants.FROSTWIRE_EXE_FILE.getPath())) {
            return;
        }
        if (SystemUtils.isProgramListedOnFirewall(string)) {
            SystemUtils.removeProgramFromFirewall(string);
        }
    }

    public static boolean isStatuschangeCapable() {
        if (!(OSUtils.isWindows() && SystemUtils.isFirewallPresent() && SystemUtils.isFirewallEnabled())) {
            return false;
        }
        String string = SystemUtils.getRunningPath();
        return string != null && string.equalsIgnoreCase(GUIConstants.FROSTWIRE_EXE_FILE.getPath());
    }

    private static void scheduleRemovalOnShutdown() {
        Thread thread = new Thread("Platform Firewall Waiter"){

            @Override
            public void run() {
                FirewallUtils.removeFromFirewall();
            }
        };
        GuiCoreMediator.getLifecycleManager().addShutdownItem(thread);
    }
}

