/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.Initializer;
import com.limegroup.gnutella.gui.JavaVersionNotice;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.bugs.FatalBugManager;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.limewire.util.VersionUtils;

public class GUILoader {
    public static void load(String[] stringArray, Frame frame) {
        try {
            if (JavaVersionNotice.upgradeRequired(VersionUtils.getJavaVersion())) {
                GUILoader.hideSplash(frame);
                JavaVersionNotice.showUpgradeRequiredDialog();
            }
            Initializer initializer = new Initializer();
            initializer.initialize(stringArray, frame);
        }
        catch (Throwable throwable) {
            GUILoader.hideSplash(frame);
            try {
                FatalBugManager.handleFatalBug(throwable);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable;
                try {
                    throwable2.initCause(throwable);
                    throwable3 = throwable2;
                }
                catch (Throwable throwable4) {
                    // empty catch block
                }
                GUILoader.showCorruptionError(throwable3);
                System.exit(1);
            }
        }
    }

    private static void hideSplash(Frame frame) {
        try {
            if (frame != null) {
                frame.dispose();
            }
            if (SplashWindow.isSplashConstructed()) {
                SplashWindow.instance().setVisible(false);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final void showCorruptionError(Throwable throwable) {
        throwable.printStackTrace();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("FrostWire version " + FrostWireUtils.getFrostWireVersion());
        printWriter.print("Java version ");
        printWriter.print(System.getProperty("java.version", "?"));
        printWriter.print(" from ");
        printWriter.println(System.getProperty("java.vendor", "?"));
        printWriter.print(System.getProperty("os.name", "?"));
        printWriter.print(" v. ");
        printWriter.print(System.getProperty("os.version", "?"));
        printWriter.print(" on ");
        printWriter.println(System.getProperty("os.arch", "?"));
        Runtime runtime = Runtime.getRuntime();
        printWriter.println("Free/total memory: " + runtime.freeMemory() + "/" + runtime.totalMemory());
        printWriter.println();
        throwable.printStackTrace(printWriter);
        printWriter.println();
        printWriter.println("STARTUP ERROR!");
        printWriter.println();
        File file = new File(GUILoader.getUserSettingsDir(), "frostwire.props");
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
            fileInputStream.close();
            properties.list(printWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        printWriter.flush();
        GUILoader.displayError(stringWriter.toString());
    }

    private static File getUserSettingsDir() {
        File file = new File(System.getProperty("user.home"));
        String string = System.getProperty("os.name").toLowerCase();
        if (string.startsWith("mac os") && string.endsWith("x")) {
            return new File(file, "/Library/Preferences/FrostWire");
        }
        return new File(file, ".frostwire");
    }

    private static final void displayError(String string) {
        System.out.println("Error: " + string);
        final JDialog jDialog = new JDialog();
        jDialog.setModal(true);
        Dimension dimension = new Dimension(350, 200);
        Dimension dimension2 = new Dimension(300, 150);
        jDialog.setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BorderLayout());
        String string2 = "One or more necessary files appear to be invalid.";
        String string3 = "This is generally caused by a corrupted installation.";
        String string4 = "Please try downloading and installing FrostWire again.";
        String string5 = "If the problem persists, please visit www.frostwire.com ";
        String string6 = "and click the 'Support' link.  ";
        String string7 = "Thank you.";
        JLabel jLabel = new JLabel(string2);
        JLabel jLabel2 = new JLabel(string3);
        JLabel jLabel3 = new JLabel(string4);
        JLabel jLabel4 = new JLabel(string5);
        JLabel jLabel5 = new JLabel(string6);
        JLabel jLabel6 = new JLabel(string7);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(jLabel);
        jPanel3.add(jLabel2);
        jPanel3.add(jLabel3);
        jPanel3.add(jLabel4);
        jPanel3.add(jLabel5);
        jPanel3.add(jLabel6);
        jPanel3.add(Box.createVerticalStrut(6));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalGlue());
        final JTextArea jTextArea = new JTextArea(string);
        jTextArea.selectAll();
        jTextArea.copy();
        jTextArea.setColumns(50);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(dimension2);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton("Copy Report");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.selectAll();
                jTextArea.copy();
            }
        });
        JButton jButton2 = new JButton("Ok");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jScrollPane, "Center");
        jPanel.add((Component)jPanel4, "South");
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension4 = jDialog.getSize();
        jDialog.setLocation((dimension3.width - dimension4.width) / 2, (dimension3.height - dimension4.height) / 2);
        jDialog.setVisible(true);
    }
}

