/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.bittorrent.websearch.WebSearchResult;
import com.frostwire.gui.ChatMediator;
import com.frostwire.gui.HideExitDialog;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.player.AudioPlayer;
import com.frostwire.gui.player.AudioSource;
import com.frostwire.gui.player.InternetRadioAudioSource;
import com.frostwire.gui.tabs.Tab;
import com.limegroup.gnutella.UpdateInformation;
import com.limegroup.gnutella.gui.AboutWindow;
import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.FinalizeListener;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.JavaVersionNotice;
import com.limegroup.gnutella.gui.LanguageUtils;
import com.limegroup.gnutella.gui.LimeJFrame;
import com.limegroup.gnutella.gui.MacEventHandler;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.RefreshTimer;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.TipOfTheDayMediator;
import com.limegroup.gnutella.gui.TipOfTheDayMessages;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.bugs.FatalBugManager;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.shell.FrostAssociations;
import com.limegroup.gnutella.gui.shell.ShellAssociationManager;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.QuestionsHandler;
import com.limegroup.gnutella.settings.StartupSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import com.limegroup.gnutella.util.LaunchException;
import com.limegroup.gnutella.util.Launcher;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.NetworkInterface;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import jd.plugins.FilePackage;
import org.limewire.concurrent.ThreadExecutor;
import org.limewire.i18n.I18nMarker;
import org.limewire.service.ErrorService;
import org.limewire.service.Switch;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringSetting;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.VersionUtils;

public final class GUIMediator {
    private static boolean _displayedMessage;
    private static final String DISCONNECTED_MESSAGE;
    private static GUIMediator _instance;
    private boolean _remoteDownloadsAllowed;
    private static JFrame FRAME;
    private static PopupMenu TRAY_MENU;
    private static final List<RefreshListener> REFRESH_LIST;
    private static final String APP_TITLE;
    private static OptionsMediator OPTIONS_MEDIATOR;
    private static ShellAssociationManager ASSOCIATION_MANAGER;
    private MainFrame MAIN_FRAME = new MainFrame(GUIMediator.getAppFrame());
    private BTDownloadMediator BT_DOWNLOAD_MEDIATOR;
    private LibraryMediator LIBRARY_MEDIATOR;
    private ChatMediator CHAT_MEDIATOR;
    private StatusLine STATUS_LINE;
    private long _lastConnectivityCheckTimestamp;
    private long _internetConnectivityInterval = 5000L;
    private boolean _wasInternetReachable;
    private static boolean _visibleOnce;
    private static boolean _allowVisible;

    private GUIMediator() {
        OPTIONS_MEDIATOR = this.MAIN_FRAME.getOptionsMediator();
        this._remoteDownloadsAllowed = true;
    }

    public static synchronized GUIMediator instance() {
        if (_instance == null) {
            _instance = new GUIMediator();
        }
        return _instance;
    }

    public static boolean isConstructed() {
        return _instance != null;
    }

    public void coreInitialized() {
        this.startTimer();
    }

    private final void startTimer() {
        RefreshTimer refreshTimer = new RefreshTimer();
        refreshTimer.startTimer();
    }

    public static final boolean isAppVisible() {
        return GUIMediator.getAppFrame().isShowing();
    }

    public static final void setAppVisible(final boolean bl) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                block17: {
                    try {
                        if (bl) {
                            GUIMediator.getAppFrame().toFront();
                        }
                        GUIMediator.getAppFrame().setVisible(bl);
                    }
                    catch (NullPointerException nullPointerException) {
                        System.out.println("GUIMediator - NULL POINTER EXCEPTION HAPPENED");
                        if (OSUtils.isNativeThemeWindows()) {
                            try {
                                if (ThemeSettings.isWindowsTheme()) {
                                    try {
                                        if (bl) {
                                            GUIMediator.getAppFrame().toFront();
                                        }
                                        GUIMediator.getAppFrame().setVisible(bl);
                                    }
                                    catch (NullPointerException nullPointerException2) {
                                        GUIMediator.showError(I18n.tr("FrostWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing FrostWire's Windows Compatibility. Right-click on the FrostWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart FrostWire."));
                                        System.exit(0);
                                    }
                                }
                                GUIMediator.showError(I18n.tr("FrostWire has encountered a problem during startup and cannot proceed. You may be able to fix this problem by changing FrostWire's Windows Compatibility. Right-click on the FrostWire icon on your Desktop and select 'Properties' from the popup menu. Click the 'Compatibility' tab at the top, then click the 'Run this program in compatibility mode for' check box, and then select 'Windows 2000' in the box below the check box. Then click the 'OK' button at the bottom and restart FrostWire."));
                                System.exit(0);
                            }
                            catch (Throwable throwable) {
                                if (bl) {
                                    FatalBugManager.handleFatalBug(nullPointerException);
                                    break block17;
                                }
                                ErrorService.error(nullPointerException);
                            }
                        }
                        if (bl) {
                            FatalBugManager.handleFatalBug(nullPointerException);
                        } else {
                            ErrorService.error(nullPointerException);
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            FatalBugManager.handleFatalBug(throwable);
                        }
                        ErrorService.error(throwable);
                    }
                }
                if (bl) {
                    SearchMediator.requestSearchFocus();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GUIMediator.getAppFrame().getContentPane().invalidate();
                            GUIMediator.getAppFrame().getContentPane().validate();
                        }
                    });
                }
                if (bl && !_visibleOnce) {
                    GUIMediator.showDialogsForFirstVisibility();
                    _visibleOnce = true;
                }
            }
        });
    }

    private static final void showDialogsForFirstVisibility() {
        JDialog jDialog;
        if (_displayedMessage) {
            return;
        }
        _displayedMessage = true;
        GUIMediator.getAssociationManager().checkAndGrab(true);
        if (TipOfTheDayMessages.hasLocalizedMessages() && StartupSettings.SHOW_TOTD.getValue()) {
            TipOfTheDayMediator.instance();
            ThreadExecutor.startThread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            TipOfTheDayMediator.instance().displayTipWindow();
                        }
                    });
                }
            }, "TOTD");
        }
        if ((jDialog = JavaVersionNotice.getUpgradeRecommendedDialog(VersionUtils.getJavaVersion())) != null) {
            jDialog.setVisible(true);
        }
    }

    public static void closeStartupDialogs() {
        if (SplashWindow.instance().isShowing()) {
            SplashWindow.instance().toBack();
        }
        if (TipOfTheDayMediator.isConstructed()) {
            TipOfTheDayMediator.instance().hide();
        }
    }

    public static final Dimension getAppSize() {
        return GUIMediator.getAppFrame().getSize();
    }

    public static final Point getAppLocation() {
        return GUIMediator.getAppFrame().getLocation();
    }

    public final MainFrame getMainFrame() {
        return this.MAIN_FRAME;
    }

    public static final JFrame getAppFrame() {
        if (FRAME == null) {
            FRAME = new LimeJFrame();
            FRAME.setTitle(APP_TITLE);
        }
        return FRAME;
    }

    public static final PopupMenu getTrayMenu() {
        if (TRAY_MENU == null) {
            TRAY_MENU = new PopupMenu();
        }
        return TRAY_MENU;
    }

    public StatusLine getStatusLine() {
        if (this.STATUS_LINE == null) {
            this.STATUS_LINE = this.getMainFrame().getStatusLine();
        }
        return this.STATUS_LINE;
    }

    public final void refreshGUI() {
        int n;
        for (n = 0; n < REFRESH_LIST.size(); ++n) {
            try {
                REFRESH_LIST.get(n).refresh();
                continue;
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
            }
        }
        n = this.getConnectionQuality();
        if (n != 0) {
            GUIMediator.hideDisposableMessage(DISCONNECTED_MESSAGE);
        }
        this.updateConnectionUI(n);
    }

    public int getConnectionQuality() {
        if (this.isInternetReachable()) {
            return 1;
        }
        return 0;
    }

    public void setOptionsVisible(boolean bl) {
        if (OPTIONS_MEDIATOR == null) {
            return;
        }
        OPTIONS_MEDIATOR.setOptionsVisible(bl);
    }

    public void setOptionsVisible(boolean bl, String string) {
        if (OPTIONS_MEDIATOR == null) {
            return;
        }
        OPTIONS_MEDIATOR.setOptionsVisible(bl, string);
    }

    public static boolean isOptionsVisible() {
        if (OPTIONS_MEDIATOR == null) {
            return false;
        }
        return OPTIONS_MEDIATOR.isOptionsVisible();
    }

    public static Component getMainOptionsComponent() {
        if (OPTIONS_MEDIATOR == null) {
            return null;
        }
        return OPTIONS_MEDIATOR.getMainOptionsComponent();
    }

    public static ShellAssociationManager getAssociationManager() {
        if (ASSOCIATION_MANAGER == null) {
            ASSOCIATION_MANAGER = new ShellAssociationManager(FrostAssociations.getSupportedAssociations());
        }
        return ASSOCIATION_MANAGER;
    }

    public void setWindow(Tabs tabs) {
        this.getMainFrame().setSelectedTab(tabs);
        this.selectFinishedDownloadsOnLibraryFirstTime(tabs);
    }

    private void selectFinishedDownloadsOnLibraryFirstTime(Tabs tabs) {
        if (!tabs.navigatedTo && tabs.equals((Object)Tabs.LIBRARY)) {
            LibraryMediator.instance().getLibraryExplorer().selectFinishedDownloads();
            tabs.navigatedTo = true;
        }
    }

    public Tabs getSelectedTab() {
        return this.getMainFrame().getSelectedTab();
    }

    private void updateConnectionUI(int n) {
        boolean bl;
        this.getStatusLine().setConnectionQuality(n);
        boolean bl2 = bl = n != 0;
        if (!bl) {
            this.setSearching(false);
        }
    }

    public int getCurrentUploads() {
        return this.getBTDownloadMediator().getActiveUploads();
    }

    public final int getTotalDownloads() {
        return this.getBTDownloadMediator().getTotalDownloads();
    }

    public final int getCurrentDownloads() {
        return this.getBTDownloadMediator().getActiveDownloads();
    }

    public final void openTorrentSearchResult(WebSearchResult webSearchResult, boolean bl) {
        this.openTorrentSearchResult(webSearchResult, bl, null);
    }

    public final void openTorrentSearchResult(WebSearchResult webSearchResult, boolean bl, ActionListener actionListener2) {
        this.getBTDownloadMediator().openTorrentSearchResult(webSearchResult, bl, actionListener2);
        this.setWindow(Tabs.SEARCH);
    }

    public final void openTorrentFile(File file, boolean bl) {
        this.getBTDownloadMediator().openTorrentFile(file, bl);
        this.setWindow(Tabs.SEARCH);
    }

    public void openTorrentForSeed(File file, File file2) {
        this.getBTDownloadMediator().openTorrentFileForSeed(file, file2);
        this.setWindow(Tabs.SEARCH);
    }

    public final void openTorrentURI(String string, boolean bl) {
        this.getBTDownloadMediator().openTorrentURI(string, bl, null);
        this.setWindow(Tabs.SEARCH);
    }

    public static boolean isPlaylistVisible() {
        return true;
    }

    public static void startupHidden() {
        GUIMediator.showTrayIcon();
        if (OSUtils.isMacOSX()) {
            GUIMediator.hideView();
        }
    }

    public static void allowVisibility() {
        if (!_allowVisible && OSUtils.isAnyMac()) {
            MacEventHandler.instance().enablePreferences();
        }
        _allowVisible = true;
    }

    public void loadFinished() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Thread thread = Thread.currentThread();
                thread.setPriority(thread.getPriority() + 1);
                GUIMediator.this.getStatusLine().loadFinished();
            }
        });
    }

    public static void handleReopen() {
        if (_allowVisible) {
            if (!_visibleOnce) {
                GUIMediator.restoreView();
            }
            GUIMediator.setAppVisible(true);
        }
    }

    public static void hideView() {
        GUIMediator.getAppFrame().setState(1);
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            GUIMediator.setAppVisible(false);
        }
    }

    public static void restoreView() {
        if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
            boolean bl = false;
            if (!_visibleOnce) {
                bl = true;
            }
            GUIMediator.setAppVisible(true);
            if (ApplicationSettings.DISPLAY_TRAY_ICON.getValue()) {
                GUIMediator.showTrayIcon();
            } else {
                GUIMediator.hideTrayIcon();
            }
            if (bl) {
                GUIMediator.restoreView();
            }
        }
        GUIMediator.getAppFrame().setState(0);
    }

    public static void close(boolean bl) {
        boolean bl2 = ApplicationSettings.MINIMIZE_TO_TRAY.getValue();
        if (!OSUtils.isMacOSX() && ApplicationSettings.SHOW_HIDE_EXIT_DIALOG.getValue()) {
            HideExitDialog hideExitDialog = new HideExitDialog(GUIMediator.getAppFrame());
            hideExitDialog.setVisible(true);
            int n = hideExitDialog.getResult();
            if (n == 0) {
                return;
            }
            boolean bl3 = bl2 = n == 1;
        }
        if (bl2) {
            if (OSUtils.supportsTray() && ResourceManager.instance().isTrayIconAvailable()) {
                GUIMediator.applyWindowSettings();
                GUIMediator.showTrayIcon();
                GUIMediator.hideView();
            }
        } else if (OSUtils.isMacOSX() && bl) {
            GUIMediator.setAppVisible(false);
        } else {
            GUIMediator.shutdown();
        }
    }

    public static void shutdown() {
        Finalizer.shutdown();
    }

    public static void flagUpdate(String string) {
        Finalizer.flagUpdate(string);
    }

    public static final void showAboutWindow() {
        new AboutWindow().showDialog();
    }

    public static void showTrayIcon() {
        NotifyUserProxy.instance().showTrayIcon();
    }

    public static void hideTrayIcon() {
        NotifyUserProxy.instance().hideTrayIcon();
    }

    public static void applyWindowSettings() {
        ApplicationSettings.RUN_ONCE.setValue(true);
        if (GUIMediator.isAppVisible()) {
            if ((GUIMediator.getAppFrame().getExtendedState() & 6) == 6) {
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            } else {
                Dimension dimension = GUIMediator.getAppSize();
                if (dimension.height > 100 && dimension.width > 100) {
                    Point point = GUIMediator.getAppLocation();
                    ApplicationSettings.APP_WIDTH.setValue(dimension.width);
                    ApplicationSettings.APP_HEIGHT.setValue(dimension.height);
                    ApplicationSettings.WINDOW_X.setValue(point.x);
                    ApplicationSettings.WINDOW_Y.setValue(point.y);
                }
            }
        }
    }

    public Tab getTab(Tabs tabs) {
        return this.MAIN_FRAME.getTab(tabs);
    }

    public static final ImageIcon getThemeImage(String string) {
        return ResourceManager.getThemeImage(string);
    }

    public static final ImageIcon getImageFromResourcePath(String string) {
        return ResourceManager.getImageFromResourcePath(string);
    }

    public static URL getURLResource(String string) {
        return ResourceManager.getURLResource(string);
    }

    public static void resetLocale() {
        ResourceManager.resetLocaleOptions();
        GUIUtils.resetLocale();
    }

    public static final ResourceBundle getXMLResourceBundle(String string) {
        return ResourceManager.getXMLResourceBundle(string);
    }

    public static final String showInputMessage(String string, String string2) {
        return MessageService.instance().showInputMessage(string, string2);
    }

    public static final DialogOption showYesNoMessage(String string, DialogOption dialogOption) {
        return MessageService.instance().showYesNoMessage(string, dialogOption);
    }

    public static final DialogOption showYesNoMessage(String string, IntSetting intSetting, DialogOption dialogOption) {
        return MessageService.instance().showYesNoMessage(string, intSetting, dialogOption);
    }

    public static final DialogOption showYesNoTitledMessage(String string, String string2, DialogOption dialogOption) {
        return MessageService.instance().showYesNoMessage(string, string2, dialogOption);
    }

    public static final int showConfirmListMessage(String string, Object[] objectArray, int n, ListCellRenderer listCellRenderer) {
        return MessageService.instance().showConfirmListMessage(string, objectArray, n, listCellRenderer);
    }

    public static final DialogOption showYesNoOtherMessage(String string, IntSetting intSetting, String string2) {
        return MessageService.instance().showYesNoOtherMessage(string, intSetting, string2);
    }

    public static final DialogOption showYesNoCancelMessage(String string) {
        return MessageService.instance().showYesNoCancelMessage(string);
    }

    public static final DialogOption showYesNoCancelMessage(String string, IntSetting intSetting) {
        return MessageService.instance().showYesNoCancelMessage(string, intSetting);
    }

    public static final void showMessage(String string) {
        MessageService.instance().showMessage(string);
    }

    public static final void showMessage(String string, Switch switch_) {
        MessageService.instance().showMessage(string, switch_);
    }

    public static final void showDisposableMessage(String string, String string2, Switch switch_, int n) {
        MessageService.instance().showDisposableMessage(string, string2, switch_, n);
    }

    public static final void hideDisposableMessage(String string) {
        MessageService.instance().hideDisposableMessage(string);
    }

    public static final void showConfirmMessage(String string) {
        MessageService.instance().showConfirmMessage(string);
    }

    public static final void showConfirmMessage(String string, Switch switch_) {
        MessageService.instance().showConfirmMessage(string, switch_);
    }

    public static final void showError(String string) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(string);
    }

    public static final void showError(String string, Switch switch_) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showError(string, switch_);
    }

    public static final void showWarning(String string, Switch switch_) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(string, switch_);
    }

    public static final void showWarning(String string) {
        GUIMediator.closeStartupDialogs();
        MessageService.instance().showWarning(string);
    }

    public static final int openURL(String string) {
        try {
            return Launcher.openURL(string);
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("FrostWire could not locate your web browser to display the following webpage: {0}.", string));
            return -1;
        }
    }

    public static final void launchFile(File file) {
        try {
            Launcher.launchFile(file);
        }
        catch (SecurityException securityException) {
            GUIMediator.showError(I18n.tr("FrostWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException launchException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(launchException.getCommand(), " ")));
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file."));
        }
    }

    public static final void launchExplorer(File file) {
        try {
            Launcher.launchExplorer(file);
        }
        catch (SecurityException securityException) {
            GUIMediator.showError(I18n.tr("FrostWire will not launch the specified file for security reasons."));
        }
        catch (LaunchException launchException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file.\n\nExecuted command: {0}.", StringUtils.explode(launchException.getCommand(), " ")));
        }
        catch (IOException iOException) {
            GUIMediator.showError(I18n.tr("FrostWire could not launch the specified file."));
        }
    }

    public static final Component getHorizontalSeparator() {
        return Box.createRigidArea(new Dimension(6, 0));
    }

    public static final Component getVerticalSeparator() {
        return Box.createRigidArea(new Dimension(0, 6));
    }

    public void connect() {
    }

    public void disconnect() {
    }

    public static void disconnected() {
        GUIMediator.showDisposableMessage(DISCONNECTED_MESSAGE, I18n.tr("Your machine does not appear to have an active Internet connection or a firewall is blocking FrostWire from accessing the internet. FrostWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu."), QuestionsHandler.NO_INTERNET_RETRYING, 0);
    }

    public static void setSplashScreenString(String string) {
        if (!_allowVisible) {
            SplashWindow.instance().setStatusText(string);
        } else if (GUIMediator.isConstructed()) {
            GUIMediator.instance().getStatusLine().setStatusText(string);
        }
    }

    public static Point getScreenCenterPoint(Component component) {
        Dimension dimension = component.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        int n = Math.min(dimension2.width, dimension.width);
        int n2 = Math.min(dimension2.height - 40, dimension.height);
        return new Point((dimension2.width - n) / 2, (dimension2.height - n2) / 2);
    }

    public static void addFinalizeListener(FinalizeListener finalizeListener) {
        Finalizer.addFinalizeListener(finalizeListener);
    }

    public void setSearching(boolean bl) {
        this.getMainFrame().setSearching(bl);
    }

    public static void addRefreshListener(RefreshListener refreshListener) {
        if (!REFRESH_LIST.contains(refreshListener)) {
            REFRESH_LIST.add(refreshListener);
        }
    }

    public static void removeRefreshListener(RefreshListener refreshListener) {
        REFRESH_LIST.remove(refreshListener);
    }

    public static Locale getLocale() {
        return ResourceManager.getLocale();
    }

    public static boolean isEnglishLocale() {
        return LanguageUtils.isEnglishLocale(GUIMediator.getLocale());
    }

    public void launchAudio(AudioSource audioSource) {
        if (AudioPlayer.instance().getCurrentSong() != null) {
            try {
                AudioPlayer.instance().stop();
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        AudioPlayer.instance().asyncLoadSong(audioSource, true, !audioSource.getClass().equals(InternetRadioAudioSource.class));
    }

    public boolean attemptStopAudio() {
        AudioPlayer audioPlayer = AudioPlayer.instance();
        audioPlayer.stop();
        return true;
    }

    public void showUpdateNotification(final UpdateInformation updateInformation) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                GUIMediator.this.getStatusLine().showUpdatePanel(true, updateInformation);
            }
        });
    }

    public byte[] triggerSearch(String string) {
        this.getMainFrame().setSelectedTab(Tabs.SEARCH);
        return SearchMediator.triggerSearch(string);
    }

    public void buttonViewChanged() {
        IconManager.instance().wipeButtonIconCache();
        this.updateButtonView(GUIMediator.getAppFrame());
    }

    public void smileysChanged(boolean bl) {
        ChatMediator.instance().changesmileys(bl);
        this.updateButtonView(GUIMediator.getAppFrame());
    }

    private void updateButtonView(Component component) {
        if (component instanceof IconButton) {
            ((IconButton)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                this.updateButtonView(componentArray[i]);
            }
        }
    }

    public static void safeInvokeAndWait(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getTargetException();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                ErrorService.error(throwable);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public static void safeInvokeLater(Runnable runnable) {
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    public void tryToStartAndAddChat() {
        this.getChatMediator().tryToStartAndAddChat();
    }

    public void setIRCNick(String string) {
        this.getChatMediator().nick(string);
    }

    public void setFrameCursor(Cursor cursor) {
        GUIMediator.getAppFrame().setCursor(cursor);
    }

    public static void openURL(final String string, final long l) {
        if (l > 0L) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(l);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    GUIMediator.openURL(string);
                }
            }).start();
        } else {
            GUIMediator.openURL(string);
        }
    }

    public BTDownloadMediator getBTDownloadMediator() {
        if (this.BT_DOWNLOAD_MEDIATOR == null) {
            this.BT_DOWNLOAD_MEDIATOR = this.getMainFrame().getBTDownloadMediator();
        }
        return this.BT_DOWNLOAD_MEDIATOR;
    }

    public LibraryMediator getLibraryMediator() {
        if (this.LIBRARY_MEDIATOR == null) {
            this.LIBRARY_MEDIATOR = this.getMainFrame().getLibraryMediator();
        }
        return this.LIBRARY_MEDIATOR;
    }

    private ChatMediator getChatMediator() {
        if (this.CHAT_MEDIATOR == null) {
            this.CHAT_MEDIATOR = this.getMainFrame().getChatMediator();
        }
        return this.CHAT_MEDIATOR;
    }

    public static void setClipboardContent(String string) {
        try {
            StringSelection stringSelection = new StringSelection(string);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, stringSelection);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private boolean isInternetReachable() {
        long l = System.currentTimeMillis();
        if (l - this._lastConnectivityCheckTimestamp < this._internetConnectivityInterval) {
            return this._wasInternetReachable;
        }
        this._lastConnectivityCheckTimestamp = l;
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            if (enumeration == null) {
                this._wasInternetReachable = false;
                return false;
            }
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                if (!networkInterface.isUp() || networkInterface.isLoopback()) continue;
                this._wasInternetReachable = true;
                return true;
            }
        }
        catch (Exception exception) {
            this._wasInternetReachable = false;
            return false;
        }
        this._wasInternetReachable = false;
        return false;
    }

    public boolean isRemoteDownloadsAllowed() {
        return this._remoteDownloadsAllowed;
    }

    public void setRemoteDownloadsAllowed(boolean bl) {
        this._remoteDownloadsAllowed = bl;
    }

    public void openTorrentSearchResult(WebSearchResult webSearchResult, String string) {
        this.getBTDownloadMediator().openTorrentURI(webSearchResult.getTorrentURI(), webSearchResult.getDetailsUrl(), string, webSearchResult.getHash(), null);
        this.setWindow(Tabs.SEARCH);
    }

    public void openYouTubeVideoUrl(String string) {
        this.getBTDownloadMediator().openYouTubeVideoUrl(string);
        this.setWindow(Tabs.SEARCH);
    }

    public void openSoundcloudTrackUrl(String string, String string2) {
        this.getBTDownloadMediator().openSoundcloudTrackUrl(string, string2);
        this.setWindow(Tabs.SEARCH);
    }

    public void openYouTubeItem(FilePackage filePackage) {
        this.getBTDownloadMediator().openYouTubeItem(filePackage);
        this.setWindow(Tabs.SEARCH);
    }

    static {
        DISCONNECTED_MESSAGE = I18nMarker.marktr("Your machine does not appear to have an active Internet connection or a firewall is blocking FrostWire from accessing the internet. FrostWire will automatically keep trying to connect you to the network unless you select \"Disconnect\" from the File menu.");
        REFRESH_LIST = new ArrayList<RefreshListener>();
        APP_TITLE = I18n.tr("FrostWire: Share Big Files");
        _visibleOnce = false;
        _allowVisible = false;
    }

    public static enum Tabs {
        SEARCH(I18n.tr("&Search")),
        LIBRARY(I18n.tr("&Library")),
        CHAT(I18n.tr("C&hat"));

        private Action navAction;
        private String name;
        public boolean navigatedTo;
        private final PropertyChangeSupport propertyChangeSupport;
        private static Tabs[] OPTIONAL_TABS;

        private Tabs(String string2) {
            this.name = GUIUtils.stripAmpersand(string2);
            this.navAction = new NavigationAction(string2, I18n.tr("Display the {0} Screen", this.name));
            this.propertyChangeSupport = new PropertyChangeSupport((Object)this);
        }

        private Tabs(StringSetting stringSetting) {
            this(stringSetting.getValue());
            stringSetting.addSettingListener(new SettingListener(){

                @Override
                public void settingChanged(final SettingEvent settingEvent) {
                    if (settingEvent.getEventType() == SettingEvent.EventType.VALUE_CHANGED) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                Tabs.this.setName(settingEvent.getSetting().getValueAsString());
                            }
                        });
                    }
                }
            });
        }

        private Tabs(String string2, String string3) {
            this(string2);
            this.navAction = new BrowseAction(string2, string3);
        }

        void setName(String string) {
            String string2 = this.name;
            this.name = GUIUtils.stripAmpersand(string);
            this.navAction.putValue("Name", string);
            this.navAction.putValue("LongDescription", I18n.tr("Display the {0} Screen", this.name));
            this.propertyChangeSupport.firePropertyChange("name", string2, this.name);
        }

        void setEnabled(boolean bl) {
            this.navAction.setEnabled(bl);
        }

        public Action getNavigationAction() {
            return this.navAction;
        }

        public String getName() {
            return this.name;
        }

        public static Tabs[] getOptionalTabs() {
            if (OPTIONAL_TABS == null) {
                OPTIONAL_TABS = new Tabs[]{LIBRARY, CHAT};
            }
            return OPTIONAL_TABS;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }

        static {
            OPTIONAL_TABS = null;
        }

        private class BrowseAction
        extends AbstractAction {
            private static final long serialVersionUID = -6546640610645484649L;
            private String url;

            public BrowseAction(String string, String string2) {
                super(string);
                this.url = string2;
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.openURL(FrostWireUtils.addLWInfoToUrl(this.url, new byte[0]));
            }
        }

        private class NavigationAction
        extends AbstractAction {
            private static final long serialVersionUID = -575503118703093157L;

            public NavigationAction(String string, String string2) {
                super(string);
                this.putValue("LongDescription", string2);
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().setWindow(Tabs.this);
            }
        }
    }
}

