/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ExternalControl;
import javax.swing.SwingUtilities;
import org.limewire.service.ErrorService;

public final class GURLHandler {
    private static GURLHandler instance;
    private volatile boolean registered = false;
    private volatile boolean enabled = false;
    private volatile String url;
    private volatile ExternalControl externalControl;

    public static synchronized GURLHandler getInstance() {
        if (instance == null) {
            instance = new GURLHandler();
        }
        return instance;
    }

    private void callback(final String string) {
        if (this.enabled && this.externalControl.isInitialized()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        GURLHandler.this.externalControl.handleMagnetRequest(string);
                    }
                    catch (Throwable throwable) {
                        ErrorService.error(throwable);
                    }
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else {
            this.url = string;
        }
    }

    public void enable(ExternalControl externalControl) {
        this.externalControl = externalControl;
        externalControl.enqueueControlRequest(this.url);
        this.url = null;
        this.enabled = true;
    }

    public void register() {
        if (!this.registered && this.InstallEventHandler() == 0) {
            this.registered = true;
        }
    }

    protected void finalize() throws Throwable {
        if (this.registered) {
            this.RemoveEventHandler();
        }
    }

    private final synchronized native int InstallEventHandler();

    private final synchronized native int RemoveEventHandler();

    static {
        try {
            System.loadLibrary("GURLLeopard");
            System.out.println("GURLLeopard loadded.");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            ErrorService.error(unsatisfiedLinkError);
        }
    }
}

