/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.settings.UISettings;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;

public class IconButton
extends JButton {
    private static final long serialVersionUID = -1721737190332501987L;
    private String message;
    private String iconName;
    private boolean horizontalText;
    private boolean initialized;
    private PropertyChangeListener listener = null;
    private boolean iconOnly;

    public IconButton(String string, String string2, boolean bl) {
        this(string, string2);
        this.horizontalText = bl;
    }

    public IconButton(String string, String string2) {
        this.setRolloverEnabled(true);
        this.iconName = string2;
        this.message = string;
        this.initialized = true;
        this.updateButton();
    }

    public IconButton(String string) {
        this.setRolloverEnabled(true);
        this.iconName = string;
        this.message = "";
        this.iconOnly = true;
        this.initialized = true;
        this.updateButton();
    }

    public IconButton(Action action) {
        super(action);
        this.setRolloverEnabled(true);
        this.initialized = true;
        this.updateButton();
    }

    @Override
    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (action2 != null) {
            action2.removePropertyChangeListener(this.getListener());
        }
        super.setAction(action);
        this.setButtonFromAction(action);
        action.addPropertyChangeListener(this.getListener());
    }

    private void setButtonFromAction(Action action) {
        this.iconName = (String)action.getValue("LimeIconName");
        this.message = (String)action.getValue("LimeShortName");
        if (this.message == null) {
            this.message = (String)action.getValue("Name");
        }
        this.updateButton();
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    IconButton.this.setButtonFromAction((Action)propertyChangeEvent.getSource());
                }
            };
        }
        return this.listener;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateButton();
    }

    @Override
    public void setText(String string) {
        this.message = string;
        this.updateButton();
    }

    private void updateButton() {
        if (!this.initialized) {
            return;
        }
        Icon icon = IconManager.instance().getIconForButton(this.iconName);
        if (icon == null) {
            super.setText(this.message);
            this.setVerticalTextPosition(0);
            this.setHorizontalTextPosition(0);
            this.setContentAreaFilled(true);
            this.setBorderPainted(true);
            this.setOpaque(true);
        } else {
            this.setIcon(icon);
            Icon icon2 = IconManager.instance().getRolloverIconForButton(this.iconName);
            this.setRolloverIcon(icon2);
            if (!this.horizontalText) {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
            } else {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(11);
            }
            this.setContentAreaFilled(false);
            this.setBorderPainted(false);
            this.setOpaque(false);
            if (!this.iconOnly && UISettings.TEXT_WITH_ICONS.getValue() && this.message != null && this.message.length() > 0) {
                super.setText(this.message);
                this.setPreferredSize(null);
            } else {
                super.setText(null);
                int n = icon.getIconHeight();
                int n2 = icon.getIconWidth();
                if (this.message == null || this.message.length() > 0) {
                    n += 15;
                    n2 += 15;
                }
                this.setPreferredSize(new Dimension(n, n2));
            }
        }
    }
}

