/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BasicFileIconController;
import com.limegroup.gnutella.gui.ButtonIconController;
import com.limegroup.gnutella.gui.FileIconController;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.NativeFileIconController;
import java.io.File;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;

public class IconManager {
    private static volatile IconManager INSTANCE;
    private FileIconController fileController;
    private ButtonIconController buttonController = new ButtonIconController();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IconManager instance() {
        if (INSTANCE != null) return INSTANCE;
        Class<IconManager> clazz = IconManager.class;
        synchronized (IconManager.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new IconManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    private IconManager() {
        this.fileController = new BasicFileIconController();
        if (OSUtils.isMacOSX() || OSUtils.isWindows()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NativeFileIconController nativeFileIconController = new NativeFileIconController();
                    if (nativeFileIconController.isValid()) {
                        IconManager.this.fileController = nativeFileIconController;
                    }
                }
            });
        }
    }

    public Icon getIconForFile(File file) {
        this.validate();
        if (file != null && FileUtils.getFileExtension(file) != null && FileUtils.getFileExtension(file).toLowerCase().endsWith("torrent")) {
            return GUIMediator.getThemeImage("frosthires");
        }
        if (file != null && FileUtils.getFileExtension(file) != null && FileUtils.getFileExtension(file).toLowerCase().endsWith("youtube")) {
            return GUIMediator.getThemeImage("youtube");
        }
        return this.fileController.getIconForFile(file);
    }

    public Icon getIconForExtension(String string) {
        this.validate();
        if (string != null && string.toLowerCase().endsWith("torrent")) {
            return GUIMediator.getThemeImage("frosthires");
        }
        if (string != null && string.toLowerCase().endsWith("youtube")) {
            return GUIMediator.getThemeImage("youtube");
        }
        return this.fileController.getIconForExtension(string);
    }

    public boolean isIconForFileAvailable(File file) {
        this.validate();
        return this.fileController.isIconForFileAvailable(file);
    }

    public void wipeButtonIconCache() {
        this.buttonController.wipeButtonIconCache();
    }

    public Icon getIconForButton(String string) {
        return this.buttonController.getIconForButton(string);
    }

    public Icon getRolloverIconForButton(String string) {
        return this.buttonController.getRolloverIconForButton(string);
    }

    private void validate() {
        if (!this.fileController.isValid()) {
            this.fileController = new BasicFileIconController();
        }
    }

    public Icon getSmallIconForButton(String string) {
        return this.buttonController.getSmallIconForButton(string);
    }
}

