/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.LanguageFlagFactory;
import com.limegroup.gnutella.gui.LanguageWindow;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class LanguageButton
extends JPanel {
    private static final long serialVersionUID = 1795381168007012403L;
    private JButton bheader = new JButton();

    public LanguageButton() {
        this.updateLanguageFlag();
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageWindow languageWindow = new LanguageWindow();
                GUIUtils.centerOnScreen(languageWindow);
                languageWindow.setVisible(true);
            }
        };
        this.bheader.addActionListener(actionListener2);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
            }
        };
        this.bheader.addMouseListener(mouseAdapter);
        LanguageButton.zeroInsets(this);
        this.setBorder(null);
        this.adjustSizes(this.bheader, 28, 16);
        this.add(this.bheader);
    }

    public void updateLanguageFlag() {
        this.bheader.setContentAreaFilled(false);
        this.bheader.setBorderPainted(false);
        this.bheader.setOpaque(false);
        this.bheader.setIcon(LanguageFlagFactory.getFlag(ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LANGUAGE.getValue(), true));
        String string = GUIMediator.getLocale().getDisplayName();
        this.bheader.setToolTipText(string);
        this.setToolTipText(string);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.bheader.addMouseListener(mouseListener);
    }

    private void adjustSizes(JComponent jComponent, int n, int n2) {
        LanguageButton.zeroInsets(jComponent);
        LanguageButton.setSizes((JButton)jComponent, n, n2);
    }

    private static void setSizes(JButton jButton, int n, int n2) {
        Dimension dimension = new Dimension(n, n2);
        jButton.setMaximumSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
    }

    private static void zeroInsets(JComponent jComponent) {
        Insets insets = jComponent.getInsets();
        insets.left = 0;
        insets.right = 0;
        insets.top = 0;
        insets.bottom = 0;
    }
}

