/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIConstants;
import com.limegroup.gnutella.gui.GUIMediator;
import java.awt.GraphicsConfiguration;
import java.awt.HeadlessException;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class LimeJFrame
extends JFrame {
    private static final long serialVersionUID = -8237193535978264490L;

    public LimeJFrame() throws HeadlessException {
        this.initialize();
    }

    public LimeJFrame(GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        this.initialize();
    }

    public LimeJFrame(String string, GraphicsConfiguration graphicsConfiguration) {
        super(string, graphicsConfiguration);
        this.initialize();
    }

    public LimeJFrame(String string) throws HeadlessException {
        super(string);
        this.initialize();
    }

    private void initialize() {
        ImageIcon imageIcon = GUIMediator.getThemeImage("frostwire64x64");
        this.setIconImage(imageIcon.getImage());
        if (OSUtils.isMacOSX()) {
            this.setupPopupHide();
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        SystemUtils.setWindowIcon(this, GUIConstants.FROSTWIRE_EXE_FILE);
    }

    private void setupPopupHide() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                for (JPopupMenu jPopupMenu : LimeJFrame.getPopups()) {
                    jPopupMenu.setVisible(false);
                }
            }
        });
    }

    private static List<JPopupMenu> getPopups() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        ArrayList<JPopupMenu> arrayList = new ArrayList<JPopupMenu>(menuElementArray.length);
        for (MenuElement menuElement : menuElementArray) {
            if (!(menuElement instanceof JPopupMenu)) continue;
            arrayList.add((JPopupMenu)menuElement);
        }
        return arrayList;
    }
}

