/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class Line
extends JComponent {
    private static final long serialVersionUID = 3079143371460914806L;
    private Color color;
    private Color uiColor;

    public Line(Color color) {
        this.setColor(color);
        this.initSize();
    }

    public Line() {
        this.uiColor = UIManager.getColor("controlShadow");
        this.initSize();
    }

    private void initSize() {
        this.setPreferredSize(new Dimension(1, 1));
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 1));
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Color color = graphics.getColor();
        if (this.uiColor != null) {
            graphics.setColor(this.uiColor);
        } else if (this.color != null) {
            graphics.setColor(this.color);
        }
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(color);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.uiColor != null) {
            this.uiColor = UIManager.getColor("controlShadow");
        }
    }
}

