/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

final class LogoPanel
extends BoxPanel {
    private static final long serialVersionUID = 222666494852328516L;
    private ImageIcon _searchingIcon;
    private ImageIcon _notSearchingIcon;
    private final JLabel ICON_LABEL = new JLabel();
    private final JLabel LOGO_LABEL = new JLabel();
    private boolean _searching;

    LogoPanel() {
        super(0);
        this.updateTheme();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                GUIMediator.openURL("http://www.frostwire.com");
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                LogoPanel.this.setCursor(new Cursor(12));
            }
        });
    }

    public void updateTheme() {
        this._searchingIcon = GUIMediator.getThemeImage("searching");
        this._notSearchingIcon = GUIMediator.getThemeImage("notsearching");
        if (this._searching) {
            this.ICON_LABEL.setIcon(this._searchingIcon);
        } else {
            this.ICON_LABEL.setIcon(this._notSearchingIcon);
        }
        ImageIcon imageIcon = GUIMediator.getThemeImage("logo");
        this.LOGO_LABEL.setIcon(imageIcon);
        this.LOGO_LABEL.setSize(imageIcon.getIconWidth(), imageIcon.getIconHeight());
        this.ICON_LABEL.setSize(this._searchingIcon.getIconWidth(), this._searchingIcon.getIconHeight());
        GUIUtils.setOpaque(false, this);
        this.buildPanel();
    }

    private void buildPanel() {
        this.removeAll();
        this.add(Box.createHorizontalGlue());
        this.add(this.ICON_LABEL);
        this.add(this.LOGO_LABEL);
        this.add(Box.createHorizontalGlue());
    }

    void setSearching(boolean bl) {
        this._searching = bl;
        if (bl) {
            this.ICON_LABEL.setIcon(this._searchingIcon);
        } else {
            this.ICON_LABEL.setIcon(this._notSearchingIcon);
        }
    }
}

