/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.ExternalControl;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GuiCoreMediator;
import com.limegroup.gnutella.gui.Initializer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import net.roydesign.event.ApplicationEvent;
import net.roydesign.mac.MRJAdapter;

public class MacEventHandler {
    private static MacEventHandler INSTANCE;
    private volatile File lastFileOpened = null;
    private volatile boolean enabled;
    private volatile ExternalControl externalControl = null;
    private volatile Initializer initializer = null;

    public static synchronized MacEventHandler instance() {
        if (INSTANCE == null) {
            INSTANCE = new MacEventHandler();
        }
        return INSTANCE;
    }

    private MacEventHandler() {
        MRJAdapter.addAboutListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacEventHandler.this.handleAbout();
            }
        });
        MRJAdapter.addQuitApplicationListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacEventHandler.this.handleQuit();
            }
        });
        MRJAdapter.addOpenDocumentListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = ((ApplicationEvent)actionEvent).getFile();
                MacEventHandler.this.handleOpenFile(file);
            }
        });
        MRJAdapter.addReopenApplicationListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacEventHandler.this.handleReopen();
            }
        });
    }

    public void enable(ExternalControl externalControl, Initializer initializer) {
        this.externalControl = externalControl;
        this.initializer = initializer;
        this.enabled = true;
        if (this.lastFileOpened != null) {
            this.runFileOpen(this.lastFileOpened);
        }
    }

    public void enablePreferences() {
        MRJAdapter.setPreferencesEnabled(true);
        MRJAdapter.addPreferencesListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacEventHandler.this.handlePreferences();
            }
        });
    }

    private void handleAbout() {
        GUIMediator.showAboutWindow();
    }

    private void handleQuit() {
        GUIMediator.applyWindowSettings();
        GUIMediator.close(false);
    }

    private void handleOpenFile(File file) {
        if (!this.enabled) {
            this.lastFileOpened = file;
        } else {
            this.runFileOpen(file);
        }
    }

    private void runFileOpen(File file) {
        String string = file.getPath();
        if (string.endsWith("limestart")) {
            this.initializer.setStartup();
        } else if (string.startsWith("magnet")) {
            if (!GUIMediator.isConstructed() || !GuiCoreMediator.getLifecycleManager().isStarted()) {
                this.externalControl.enqueueControlRequest(file.getAbsolutePath());
            } else if (file.getAbsolutePath().startsWith("magnet:?xt=urn:btih")) {
                GUIMediator.instance().openTorrentURI(file.getAbsolutePath(), false);
            }
        } else if (string.endsWith("torrent")) {
            if (!GUIMediator.isConstructed() || !GuiCoreMediator.getLifecycleManager().isStarted()) {
                this.externalControl.enqueueControlRequest(file.getAbsolutePath());
            } else {
                GUIMediator.instance().openTorrentFile(file, false);
            }
        }
    }

    private void handleReopen() {
        GUIMediator.handleReopen();
    }

    private void handlePreferences() {
        GUIMediator.instance().setOptionsVisible(true);
    }
}

