/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.ChatMediator;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.frostwire.gui.library.LibraryMediator;
import com.frostwire.gui.tabs.ChatTab;
import com.frostwire.gui.tabs.LibraryTab;
import com.frostwire.gui.tabs.SearchDownloadTab;
import com.frostwire.gui.tabs.Tab;
import com.frostwire.gui.tabs.TabRightClickAdapter;
import com.frostwire.gui.updates.UpdateManager;
import com.limegroup.gnutella.gui.ApplicationHeader;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LogoPanel;
import com.limegroup.gnutella.gui.PowerManager;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.ResourceManager;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.dnd.DNDUtils;
import com.limegroup.gnutella.gui.dnd.TransferHandlerDropTargetListener;
import com.limegroup.gnutella.gui.menu.MenuMediator;
import com.limegroup.gnutella.gui.options.OptionsMediator;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.limewire.setting.SettingsGroupManager;
import org.limewire.util.OSUtils;

public final class MainFrame
implements RefreshListener,
ThemeObserver {
    private JPanel TABBED_PANE;
    private SearchMediator SEARCH_MEDIATOR;
    private BTDownloadMediator BT_DOWNLOAD_MEDIATOR;
    private LibraryMediator LIBRARY_MEDIATOR;
    private ChatMediator CHAT_MEDIATOR;
    private OptionsMediator OPTIONS_MEDIATOR;
    private StatusLine STATUS_LINE;
    private MenuMediator MENU_MEDIATOR;
    private final JFrame FRAME;
    private LogoPanel LOGO_PANEL;
    private Map<GUIMediator.Tabs, Tab> TABS = new HashMap<GUIMediator.Tabs, Tab>(7);
    private WindowState lastState = null;
    private ApplicationHeader APPLICATION_HEADER;

    MainFrame(JFrame jFrame) {
        UpdateManager.scheduleUpdateCheckTask(0);
        this.FRAME = jFrame;
        Dimension dimension = null;
        dimension = OSUtils.isMacOSX() ? new Dimension(875, 97) : new Dimension(875, 134);
        this.FRAME.setMinimumSize(dimension);
        new DropTarget(this.FRAME, new TransferHandlerDropTargetListener(DNDUtils.DEFAULT_TRANSFER_HANDLER));
        this.TABBED_PANE = new JPanel(new CardLayout());
        this.TABBED_PANE.putClientProperty("CLIENT_PROPERTY_LIGHT_NOISE", true);
        this.FRAME.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                MainFrame.this.lastState = new WindowState();
                MainFrame.this.saveWindowState();
            }

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                MainFrame.this.saveWindowState();
            }
        });
        this.FRAME.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent windowEvent) {
                MainFrame.this.saveWindowState();
            }
        });
        this.FRAME.addWindowListener(new WindowAdapter(){

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
                if (!OSUtils.supportsTray() || !ResourceManager.instance().isTrayIconAvailable()) {
                    GUIMediator.restoreView();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.saveWindowState();
                SettingsGroupManager.instance().save();
                GUIMediator.close(true);
            }
        });
        this.FRAME.setDefaultCloseOperation(0);
        this.setFrameDimensions();
        this.FRAME.setJMenuBar(this.getMenuMediator().getMenuBar());
        JPanel jPanel = new JPanel();
        this.FRAME.setContentPane(jPanel);
        jPanel.setLayout(new BorderLayout());
        this.buildTabs();
        this.APPLICATION_HEADER = new ApplicationHeader(this.TABS);
        this.LOGO_PANEL = this.APPLICATION_HEADER.getLogoPanel();
        jPanel.add((Component)this.APPLICATION_HEADER, "First");
        jPanel.add((Component)this.TABBED_PANE, "Center");
        jPanel.add((Component)this.getStatusLine().getComponent(), "Last");
        ThemeMediator.addThemeObserver(this);
        GUIMediator.addRefreshListener(this);
        if (ApplicationSettings.MAGNET_CLIPBOARD_LISTENER.getValue()) {
            this.FRAME.addWindowListener(MagnetClipboardListener.getInstance());
        }
        PowerManager powerManager = new PowerManager();
        this.FRAME.addWindowListener(powerManager);
        GUIMediator.addRefreshListener(powerManager);
    }

    public ApplicationHeader getApplicationHeader() {
        return this.APPLICATION_HEADER;
    }

    void saveWindowState() {
        int n = this.FRAME.getExtendedState();
        if (n == 0) {
            Dimension dimension = GUIMediator.getAppSize();
            if (dimension.height > 100 && dimension.width > 100) {
                Point point = GUIMediator.getAppLocation();
                ApplicationSettings.APP_WIDTH.setValue(dimension.width);
                ApplicationSettings.APP_HEIGHT.setValue(dimension.height);
                ApplicationSettings.WINDOW_X.setValue(point.x);
                ApplicationSettings.WINDOW_Y.setValue(point.y);
                ApplicationSettings.MAXIMIZE_WINDOW.setValue(false);
            }
        } else if ((n & 6) == 6) {
            ApplicationSettings.MAXIMIZE_WINDOW.setValue(true);
            if (this.lastState != null && this.lastState.time == System.currentTimeMillis()) {
                ApplicationSettings.WINDOW_X.setValue(this.lastState.x);
                ApplicationSettings.WINDOW_Y.setValue(this.lastState.y);
                this.lastState = null;
            }
        }
    }

    @Override
    public void updateTheme() {
        this.FRAME.setJMenuBar(this.getMenuMediator().getMenuBar());
    }

    private void buildTabs() {
        this.TABBED_PANE.addMouseListener(TabRightClickAdapter.getInstance());
        this.SEARCH_MEDIATOR = new SearchMediator();
        this.TABS.put(GUIMediator.Tabs.SEARCH, new SearchDownloadTab(this.SEARCH_MEDIATOR, this.getBTDownloadMediator()));
        this.TABS.put(GUIMediator.Tabs.LIBRARY, new LibraryTab(this.getLibraryMediator()));
        this.TABS.put(GUIMediator.Tabs.CHAT, new ChatTab(this.getChatMediator()));
        this.TABBED_PANE.setPreferredSize(new Dimension(10000, 10000));
        for (GUIMediator.Tabs tabs : GUIMediator.Tabs.values()) {
            Tab tab = this.TABS.get((Object)tabs);
            if (tab == null) continue;
            this.addTab(tab);
        }
        this.TABBED_PANE.setRequestFocusEnabled(false);
    }

    private void addTab(Tab tab) {
        this.TABBED_PANE.add((Component)tab.getComponent(), tab.getTitle());
    }

    public final void setSelectedTab(GUIMediator.Tabs tabs) {
        CardLayout cardLayout = (CardLayout)this.TABBED_PANE.getLayout();
        Tab tab = this.TABS.get((Object)tabs);
        cardLayout.show(this.TABBED_PANE, tab.getTitle());
        this.APPLICATION_HEADER.selectTab(tab);
    }

    private final void setFrameDimensions() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = 0;
        int n2 = 0;
        int n3 = Math.min(dimension.width - insets.left - insets.right, ApplicationSettings.APP_WIDTH.getValue());
        int n4 = Math.min(dimension.height - insets.top - insets.bottom, ApplicationSettings.APP_HEIGHT.getValue());
        if (ApplicationSettings.RUN_ONCE.getValue()) {
            n = Math.max(insets.left, ApplicationSettings.WINDOW_X.getValue());
            n2 = Math.max(insets.top, ApplicationSettings.WINDOW_Y.getValue());
        } else {
            n = (dimension.width - n3) / 2;
            n2 = (dimension.height - n4) / 2;
        }
        if (n + n3 > dimension.width) {
            n = Math.max(insets.left, dimension.width - insets.left - insets.right - n3);
        }
        if (n2 + n4 > dimension.height) {
            n2 = Math.max(insets.top, dimension.height - insets.top - insets.bottom - n4);
        }
        this.FRAME.setLocation(n, n2);
        this.FRAME.setSize(new Dimension(n3, n4));
        this.FRAME.getContentPane().setSize(new Dimension(n3, n4));
        ((JComponent)this.FRAME.getContentPane()).setPreferredSize(new Dimension(n3, n4));
        if (ApplicationSettings.MAXIMIZE_WINDOW.getValue() && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            this.FRAME.setExtendedState(6);
        }
    }

    @Override
    public void refresh() {
    }

    final BTDownloadMediator getBTDownloadMediator() {
        if (this.BT_DOWNLOAD_MEDIATOR == null) {
            this.BT_DOWNLOAD_MEDIATOR = BTDownloadMediator.instance();
        }
        return this.BT_DOWNLOAD_MEDIATOR;
    }

    final LibraryMediator getLibraryMediator() {
        if (this.LIBRARY_MEDIATOR == null) {
            this.LIBRARY_MEDIATOR = LibraryMediator.instance();
        }
        return this.LIBRARY_MEDIATOR;
    }

    final ChatMediator getChatMediator() {
        if (this.CHAT_MEDIATOR == null) {
            this.CHAT_MEDIATOR = ChatMediator.instance();
        }
        return this.CHAT_MEDIATOR;
    }

    final StatusLine getStatusLine() {
        if (this.STATUS_LINE == null) {
            this.STATUS_LINE = new StatusLine();
        }
        return this.STATUS_LINE;
    }

    public final MenuMediator getMenuMediator() {
        if (this.MENU_MEDIATOR == null) {
            this.MENU_MEDIATOR = MenuMediator.instance();
        }
        return this.MENU_MEDIATOR;
    }

    final OptionsMediator getOptionsMediator() {
        if (this.OPTIONS_MEDIATOR == null) {
            this.OPTIONS_MEDIATOR = OptionsMediator.instance();
        }
        return this.OPTIONS_MEDIATOR;
    }

    public final void setSearching(boolean bl) {
        this.LOGO_PANEL.setSearching(bl);
        this.refresh();
    }

    public GUIMediator.Tabs getSelectedTab() {
        Component component = this.getCurrentTabComponent();
        if (component != null) {
            for (GUIMediator.Tabs tabs : this.TABS.keySet()) {
                if (!this.TABS.get((Object)tabs).getComponent().equals(component)) continue;
                return tabs;
            }
        }
        return null;
    }

    private Component getCurrentTabComponent() {
        Component component = null;
        for (Component component2 : this.TABBED_PANE.getComponents()) {
            if (!component2.isVisible()) continue;
            if (component2 instanceof JPanel) {
                component = component2;
                continue;
            }
            if (!(component2 instanceof JScrollPane)) continue;
            component = ((JScrollPane)component2).getViewport().getComponent(0);
        }
        return component;
    }

    public Tab getTab(GUIMediator.Tabs tabs) {
        return this.TABS.get((Object)tabs);
    }

    private static class WindowState {
        private final int x = ApplicationSettings.WINDOW_X.getValue();
        private final int y = ApplicationSettings.WINDOW_Y.getValue();
        private final long time = System.currentTimeMillis();

        WindowState() {
        }
    }
}

