/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.DialogOption;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.HTMLLabel;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MultiLineLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.limewire.service.Switch;
import org.limewire.setting.IntSetting;

public final class MessageService {
    public static final int REMEMBER_ANSWER = 1;
    public static final int FORGET_ANSWER = 0;
    private final Map<String, JDialog> _disposableMessageMap = new HashMap<String, JDialog>();
    private static final MessageService INSTANCE = new MessageService();

    public static MessageService instance() {
        return INSTANCE;
    }

    MessageService() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Messages..."));
    }

    public final void showError(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane jOptionPane = new JOptionPane();
                jOptionPane.setMessageType(0);
                JEditorPane jEditorPane = new JEditorPane();
                jEditorPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                jEditorPane.setEditable(false);
                jEditorPane.setOpaque(false);
                jEditorPane.setFont(new Font("Arial", 0, 12));
                jEditorPane.setContentType("text/html");
                jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                    @Override
                    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                        if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                            GUIMediator.openURL(hyperlinkEvent.getURL().toString());
                        }
                    }
                });
                jEditorPane.setText(string);
                jOptionPane.setMessage(jEditorPane);
                jOptionPane.setOpaque(true);
                JDialog jDialog = jOptionPane.createDialog(MessageService.getParentComponent(), I18n.tr("Error"));
                jDialog.setVisible(true);
            }
        });
    }

    final void showError(final String string, final Switch switch_) {
        if (!switch_.getValue()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MessageService.getParentComponent(), MessageService.this.doNotDisplayAgainLabel(string, switch_), I18n.tr("Error"), 0);
                }
            });
        }
    }

    final void showWarning(final String string, final Switch switch_) {
        if (!switch_.getValue()) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MessageService.getParentComponent(), MessageService.this.doNotDisplayAgainLabel(string, switch_), I18n.tr("Warning"), 2);
                }
            });
        }
    }

    final void showWarning(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(MessageService.getParentComponent(), MessageService.this.getLabel(string), I18n.tr("Warning"), 2);
            }
        });
    }

    public final void showMessage(final Component component) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(MessageService.getParentComponent(), component, I18n.tr("Message"), 1);
            }
        });
    }

    final void showMessage(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(MessageService.getParentComponent(), MessageService.this.getLabel(string), I18n.tr("Message"), 1);
            }
        });
    }

    final void showMessage(final String string, final Switch switch_) {
        if (!switch_.getValue()) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog(MessageService.getParentComponent(), MessageService.this.doNotDisplayAgainLabel(string, switch_), I18n.tr("Message"), 1);
                }
            });
        }
    }

    final void showDisposableMessage(String string, String string2, int n) {
        this.showDisposableMessage(string, string2, null, n);
    }

    final void showDisposableMessage(final String string, final String string2, final Switch switch_, final int n) {
        String string3;
        switch (n) {
            case 0: {
                string3 = I18n.tr("Error");
                break;
            }
            case 2: {
                string3 = I18n.tr("Warning");
                break;
            }
            case -1: 
            case 1: {
                string3 = I18n.tr("Message");
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported Message Type: " + n);
            }
        }
        final String string4 = string3;
        if (switch_ == null || !switch_.getValue()) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    if (MessageService.this._disposableMessageMap.containsKey(string)) {
                        JDialog jDialog = (JDialog)MessageService.this._disposableMessageMap.get(string);
                        jDialog.toFront();
                        jDialog.setVisible(true);
                    } else {
                        Object object = string2;
                        if (switch_ != null) {
                            object = MessageService.this.doNotDisplayAgainLabel(string2, switch_);
                        }
                        JOptionPane jOptionPane = new JOptionPane(object, n);
                        JDialog jDialog = jOptionPane.createDialog(MessageService.getParentComponent(), string4);
                        jDialog.setModal(true);
                        MessageService.this._disposableMessageMap.put(string, jDialog);
                        jDialog.setVisible(true);
                        MessageService.this._disposableMessageMap.remove(string);
                    }
                }
            });
        }
    }

    final void hideDisposableMessage(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                JDialog jDialog = (JDialog)MessageService.this._disposableMessageMap.get(string);
                if (jDialog != null) {
                    jDialog.setVisible(false);
                    jDialog.dispose();
                }
            }
        });
    }

    final void showConfirmMessage(final String string) {
        GUIMediator.safeInvokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showConfirmDialog(MessageService.getParentComponent(), MessageService.this.getLabel(string), I18n.tr("Message"), 1);
            }
        });
    }

    final void showConfirmMessage(final String string, final Switch switch_) {
        if (!switch_.getValue()) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showConfirmDialog(MessageService.getParentComponent(), MessageService.this.doNotDisplayAgainLabel(string, switch_), I18n.tr("Message"), 1);
                }
            });
        }
    }

    final DialogOption showYesNoMessage(String string, DialogOption dialogOption) {
        return this.showYesNoMessage(string, I18n.tr("Message"), dialogOption);
    }

    final DialogOption showYesNoMessage(String string) {
        return this.showYesNoMessage(string, I18n.tr("Message"));
    }

    final int showConfirmListMessage(String string, Object[] objectArray, int n, ListCellRenderer listCellRenderer) {
        return this.showConfirmListMessage(string, objectArray, n, listCellRenderer, I18n.tr("Message"));
    }

    final int showConfirmListMessage(String string, Object[] objectArray, int n, ListCellRenderer listCellRenderer, String string2) {
        JList<Object> jList = new JList<Object>(objectArray);
        jList.setVisibleRowCount(5);
        jList.setSelectionForeground(jList.getForeground());
        jList.setSelectionBackground(jList.getBackground());
        jList.setFocusable(false);
        if (listCellRenderer != null) {
            jList.setCellRenderer(listCellRenderer);
        }
        Object[] objectArray2 = new Object[]{new MultiLineLabel(string, 400), Box.createVerticalStrut(6), new JScrollPane(jList)};
        return JOptionPane.showConfirmDialog(MessageService.getParentComponent(), objectArray2, string2, n);
    }

    final DialogOption showYesNoMessage(String string, String string2) {
        return this.showYesNoMessage(string, string2, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String string, String string2, DialogOption dialogOption) {
        int n;
        Object[] objectArray = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText()};
        try {
            n = JOptionPane.showOptionDialog(MessageService.getParentComponent(), this.getLabel(string), string2, 0, 2, null, objectArray, dialogOption.getText());
        }
        catch (InternalError internalError) {
            n = 1;
        }
        if (n == 0) {
            return DialogOption.YES;
        }
        return DialogOption.NO;
    }

    final DialogOption showYesNoMessage(String string, IntSetting intSetting) {
        return this.showYesNoMessage(string, intSetting, DialogOption.YES);
    }

    final DialogOption showYesNoMessage(String string, IntSetting intSetting, DialogOption dialogOption) {
        int n;
        Object[] objectArray = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText()};
        DialogOption dialogOption2 = DialogOption.parseInt(intSetting.getValue());
        if (dialogOption2 == DialogOption.YES || dialogOption2 == DialogOption.NO) {
            return dialogOption2;
        }
        try {
            n = JOptionPane.showOptionDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(string, intSetting), I18n.tr("Message"), 0, 2, null, objectArray, dialogOption.getText());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = 1;
        }
        catch (InternalError internalError) {
            n = 1;
        }
        dialogOption2 = n == 0 ? DialogOption.YES : DialogOption.NO;
        if (intSetting.getValue() == 1) {
            intSetting.setValue(dialogOption2.toInt());
        } else {
            intSetting.setValue(0);
        }
        return dialogOption2;
    }

    final DialogOption showYesNoCancelMessage(String string) {
        int n;
        try {
            n = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.getLabel(string), I18n.tr("Message"), 1);
        }
        catch (InternalError internalError) {
            n = 1;
        }
        if (n == 0) {
            return DialogOption.YES;
        }
        if (n == 1) {
            return DialogOption.NO;
        }
        return DialogOption.CANCEL;
    }

    final DialogOption showYesNoCancelMessage(String string, IntSetting intSetting) {
        int n;
        DialogOption dialogOption = DialogOption.parseInt(intSetting.getValue());
        if (dialogOption == DialogOption.YES || dialogOption == DialogOption.NO) {
            return dialogOption;
        }
        try {
            n = JOptionPane.showConfirmDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(string, intSetting), I18n.tr("Message"), 1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = 2;
        }
        catch (InternalError internalError) {
            n = 2;
        }
        dialogOption = n == 0 ? DialogOption.YES : (n == 1 ? DialogOption.NO : DialogOption.CANCEL);
        if (intSetting.getValue() == 1 && dialogOption != DialogOption.CANCEL) {
            intSetting.setValue(dialogOption.toInt());
        } else {
            intSetting.setValue(0);
        }
        return dialogOption;
    }

    final DialogOption showYesNoOtherMessage(String string, IntSetting intSetting, String string2) {
        int n;
        Object[] objectArray = new String[]{DialogOption.YES.getText(), DialogOption.NO.getText(), string2};
        DialogOption dialogOption = DialogOption.parseInt(intSetting.getValue());
        if (dialogOption == DialogOption.YES || dialogOption == DialogOption.NO) {
            return dialogOption;
        }
        try {
            n = JOptionPane.showOptionDialog(MessageService.getParentComponent(), this.alwaysUseThisAnswerLabel(string, intSetting), I18n.tr("Message"), 0, 2, null, objectArray, DialogOption.YES.getText());
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            n = -1;
        }
        catch (InternalError internalError) {
            n = -1;
        }
        dialogOption = n == 0 ? DialogOption.YES : (n == 1 ? DialogOption.NO : (n == 2 ? DialogOption.OTHER : DialogOption.CANCEL));
        if (intSetting.getValue() == 1 && dialogOption != DialogOption.OTHER && dialogOption != DialogOption.CANCEL) {
            intSetting.setValue(dialogOption.toInt());
        } else {
            intSetting.setValue(0);
        }
        return dialogOption;
    }

    final String showInputMessage(String string, String string2) {
        if (string2 == null) {
            return JOptionPane.showInputDialog(MessageService.getParentComponent(), (Object)string);
        }
        return JOptionPane.showInputDialog(MessageService.getParentComponent(), string, string2);
    }

    public static Component getParentComponent() {
        if (GUIMediator.isOptionsVisible()) {
            return GUIMediator.getMainOptionsComponent();
        }
        return GUIMediator.getAppFrame();
    }

    private JComponent getLabel(String string) {
        if (string.startsWith("<html")) {
            return new HTMLLabel(string);
        }
        return new MultiLineLabel(string, 400);
    }

    private final JComponent doNotDisplayAgainLabel(String string, final Switch switch_) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Do not display this message again"));
        JComponent jComponent = this.getLabel(string);
        jPanel.add((Component)jComponent, "North");
        jPanel.add((Component)jCheckBox, "West");
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                switch_.setValue(itemEvent.getStateChange() == 1);
            }
        });
        return jPanel;
    }

    private final JComponent alwaysUseThisAnswerLabel(String string, final IntSetting intSetting) {
        JPanel jPanel = new JPanel(new BorderLayout(0, 15));
        JCheckBox jCheckBox = new JCheckBox(I18n.tr("Always use this answer"));
        JComponent jComponent = this.getLabel(string);
        jPanel.add((Component)jComponent, "North");
        jPanel.add((Component)jCheckBox, "West");
        jCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    intSetting.setValue(1);
                } else {
                    intSetting.setValue(0);
                }
            }
        });
        return jPanel;
    }
}

