/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.StringTokenizer;
import javax.swing.JTextArea;
import javax.swing.LookAndFeel;

public class MultiLineLabel
extends JTextArea {
    private static final long serialVersionUID = -7407493522099115196L;
    private static final int DEFAULT_LABEL_WIDTH = 200;
    private String _theText;
    private ResizeHandler resizeHandler = null;
    private boolean resizable = false;

    public MultiLineLabel(String string) {
        this(string, false);
    }

    public MultiLineLabel(String string, boolean bl) {
        if (string == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(string);
        this.resizable = bl;
    }

    public MultiLineLabel(String string, int n) {
        this(string, n, false);
    }

    public MultiLineLabel(String string, int n, boolean bl) {
        if (string == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(string, n);
        this.resizable = bl;
    }

    public MultiLineLabel(String[] stringArray) {
        this.setOpaque(false);
        this._theText = this.createSizedString(stringArray);
        super.setText(this._theText);
    }

    public MultiLineLabel(String string, int n, int n2, int n3) {
        super(n2, n3);
        if (string == null) {
            throw new NullPointerException("null string in multilinelabel");
        }
        this.setOpaque(false);
        this.setText(string, n);
    }

    public void setText(String string, int n) {
        this._theText = string;
        super.setText(this.createSizedString(string, n));
    }

    @Override
    public void setText(String string) {
        this._theText = string;
        super.setText(this.createSizedString(string, 200));
    }

    @Override
    public String getText() {
        return this._theText;
    }

    @Override
    public void updateUI() {
        GUIUtils.SizePolicy sizePolicy;
        super.updateUI();
        this.setWrapStyleWord(true);
        this.setHighlighter(null);
        this.setEditable(false);
        LookAndFeel.installBorder(this, "Label.border");
        LookAndFeel.installColorsAndFont(this, "Label.background", "Label.foreground", "Label.font");
        if (this.resizeHandler != null) {
            this.resizeHandler.componentResized(null);
        }
        if ((sizePolicy = (GUIUtils.SizePolicy)((Object)this.getClientProperty(GUIUtils.SizePolicy.class))) != null) {
            GUIUtils.restrictSize(this, sizePolicy);
        }
    }

    private String createSizedString(String string, int n) {
        String string2;
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        int n2 = n;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            n2 = Math.max(n2, fontMetrics.stringWidth(string2));
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringTokenizer = new StringTokenizer(string, " \n", true);
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals(" ")) continue;
            boolean bl = string2.equals("\n");
            if (bl || fontMetrics.stringWidth(stringBuilder2.toString() + string2) > n2) {
                stringBuilder.append(stringBuilder2.toString());
                stringBuilder.append("\n");
                stringBuilder2 = new StringBuilder();
            }
            if (bl) continue;
            stringBuilder2.append(string2);
            stringBuilder2.append(" ");
        }
        stringBuilder.append(stringBuilder2.toString());
        return stringBuilder.toString();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.checkAndAddResizeHandler();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        Container container = this.getParent();
        if (this.resizeHandler != null && container != null) {
            container.removeComponentListener(this.resizeHandler);
            this.resizeHandler = null;
        }
    }

    private void checkAndAddResizeHandler() {
        Container container = this.getParent();
        if (container != null && this.resizable && this.resizeHandler == null) {
            this.resizeHandler = new ResizeHandler();
            container.addComponentListener(this.resizeHandler);
        }
    }

    private String createSizedString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuilder.append(stringArray[i]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private class ResizeHandler
    extends ComponentAdapter {
        private int lastWidth = -1;

        private ResizeHandler() {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            int n = MultiLineLabel.this.getSize().width;
            if (n != this.lastWidth) {
                this.lastWidth = n;
                MultiLineLabel.this.setText(MultiLineLabel.this.getText(), MultiLineLabel.this.getSize().width);
            }
        }
    }
}

