/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.JMultilineToolTip;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.plaf.basic.BasicToolTipUI;

public class MultilineToolTipUI
extends BasicToolTipUI {
    private static final int MAX_WIDTH = 400;
    private static final int BLANK_SPACE = 4;
    private static final MultilineToolTipUI instance = new MultilineToolTipUI();
    private boolean extendedWidth = false;
    private final JTextArea TEXT = new JTextArea();
    private final CellRendererPane PANE = new CellRendererPane();

    public static MultilineToolTipUI instance() {
        return instance;
    }

    private MultilineToolTipUI() {
        this.TEXT.setLineWrap(true);
        this.TEXT.setWrapStyleWord(true);
        this.TEXT.setEditable(false);
        this.TEXT.setOpaque(false);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        int n;
        this.extendedWidth = false;
        Font font = jComponent.getFont();
        FontMetrics fontMetrics = jComponent.getFontMetrics(font);
        int n2 = fontMetrics.getHeight();
        String[] stringArray = ((JMultilineToolTip)jComponent).getTipArray();
        if (stringArray == null) {
            return new Dimension(0, 0);
        }
        int n3 = stringArray.length;
        int n4 = n3 * n2;
        if (n4 == 0) {
            return new Dimension(0, 0);
        }
        int n5 = 0;
        for (n = 0; n < n3; ++n) {
            int n6 = fontMetrics.stringWidth(stringArray[n]);
            n5 = Math.max(n6, n5);
            if (n5 <= 400) continue;
            this.extendedWidth = true;
            break;
        }
        if (this.extendedWidth) {
            this.TEXT.setFont(font);
            this.TEXT.setText(stringArray[0]);
            for (n = 1; n < n3; ++n) {
                this.TEXT.append("\n" + stringArray[n]);
            }
            Dimension dimension = this.preferredSize(fontMetrics, this.TEXT);
            n5 = dimension.width;
            n4 = dimension.height;
        }
        return new Dimension(n5 + 8, n4 + 8);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private Dimension preferredSize(FontMetrics fontMetrics, JTextArea jTextArea) {
        String string;
        int n = 0;
        int n2 = 1;
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        String string2 = jTextArea.getText();
        n4 = string2.indexOf("\n");
        while (n4 != -1) {
            string = string2.substring(n3 + 1, n4);
            n5 = fontMetrics.stringWidth(string);
            if (n5 > 400) {
                n2 += (int)Math.ceil((double)n5 / 400.0);
                n = 400;
            } else {
                n = Math.max(n5, n);
                ++n2;
            }
            n3 = n4;
            n4 = string2.indexOf("\n", n3 + 1);
        }
        string = string2.substring(n3 + 1);
        n5 = fontMetrics.stringWidth(string);
        if (n5 > 400) {
            n2 += (int)Math.ceil((double)n5 / 400.0);
            n = 400;
        } else {
            n = Math.max(n5, n);
            ++n2;
        }
        return new Dimension(n, n2 * fontMetrics.getHeight());
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Dimension dimension = jComponent.getSize();
        Font font = jComponent.getFont();
        if (this.extendedWidth) {
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            this.TEXT.setForeground(jComponent.getForeground());
            this.PANE.paintComponent(graphics, this.TEXT, jComponent, 4, 4, dimension.width - 8, dimension.height - 8, true);
            return;
        }
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getAscent();
        String[] stringArray = ((JMultilineToolTip)jComponent).getTipArray();
        if (stringArray == null) {
            return;
        }
        int n3 = stringArray.length;
        graphics.setColor(jComponent.getBackground());
        graphics.fillRect(0, 0, dimension.width, dimension.height);
        graphics.setColor(jComponent.getForeground());
        int n4 = 0;
        int n5 = 4 + n2;
        while (n4 < n3) {
            graphics.drawString(stringArray[n4], 4, n5);
            ++n4;
            n5 += n;
        }
    }
}

