/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.notify.NotifyUserProxy;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeSettings;
import com.limegroup.gnutella.settings.ApplicationSettings;
import java.awt.Font;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.limewire.util.OSUtils;
import org.limewire.util.StringUtils;

public final class ResourceManager {
    private static ResourceManager _instance;
    private static final String GUI_PATH = "org/limewire/gui/";
    private static final String RESOURCES_PATH = "org/limewire/gui/resources/";
    private static final String IMAGES_PATH = "org/limewire/gui/images/";
    private static boolean _localeOptionsSet;
    private static Locale _locale;
    private final boolean BRUSHED_METAL;
    private static final Map<String, ImageIcon> THEME_IMAGES;
    private static boolean loadFailureEncountered;

    static void resetLocaleOptions() {
        _localeOptionsSet = false;
        ResourceManager.setLocaleOptions();
    }

    static void setLocaleOptions() {
        if (!_localeOptionsSet) {
            if (ApplicationSettings.LANGUAGE.getValue().equals("")) {
                ApplicationSettings.LANGUAGE.setValue("en");
            }
            _locale = new Locale(ApplicationSettings.LANGUAGE.getValue(), ApplicationSettings.COUNTRY.getValue(), ApplicationSettings.LOCALE_VARIANT.getValue());
            StringUtils.setLocale(_locale);
            I18n.setLocale(_locale);
            _localeOptionsSet = true;
        }
    }

    static Locale getLocale() {
        return _locale;
    }

    public static boolean hasLoadFailure() {
        return loadFailureEncountered;
    }

    public static void resetLoadFailure() {
        loadFailureEncountered = false;
    }

    static ResourceBundle getXMLResourceBundle(String string) {
        return ResourceBundle.getBundle("xml.display." + string, _locale);
    }

    static final ImageIcon getThemeImage(String string) {
        if (string == null) {
            throw new NullPointerException("null image name");
        }
        ImageIcon imageIcon = null;
        imageIcon = THEME_IMAGES.get(string);
        if (imageIcon != null) {
            return imageIcon;
        }
        File file = ThemeSettings.THEME_DIR.getValue();
        imageIcon = ResourceManager.getImageFromURL(new File(file, string).getPath(), true);
        if (imageIcon != null && imageIcon.getImage() != null) {
            THEME_IMAGES.put(string, imageIcon);
            return imageIcon;
        }
        imageIcon = ResourceManager.getImageFromURL(IMAGES_PATH + string, false);
        if (imageIcon != null && imageIcon.getImage() != null) {
            THEME_IMAGES.put(string, imageIcon);
            return imageIcon;
        }
        throw new MissingResourceException("image: " + string + " doesn't exist.", null, null);
    }

    static final ImageIcon getImageFromResourcePath(String string) {
        return ResourceManager.getImageFromURL(string, false);
    }

    private static final ImageIcon getImageFromURL(String string, boolean bl) {
        URL uRL = ResourceManager.toURL(string, bl);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        uRL = ResourceManager.toURL(string + ".png", bl);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        uRL = ResourceManager.toURL(string + ".gif", bl);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    private static final URL toURL(String string, boolean bl) {
        if (bl) {
            File file = new File(string);
            if (file.exists()) {
                try {
                    return file.toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    return null;
                }
            }
            return null;
        }
        return ResourceManager.getURL(string);
    }

    static URL getURLResource(String string) {
        return ResourceManager.getURL(RESOURCES_PATH + string);
    }

    private static URL getURL(String string) {
        ClassLoader classLoader = ResourceManager.class.getClassLoader();
        if (classLoader == null) {
            return ClassLoader.getSystemResource(string);
        }
        URL uRL = classLoader.getResource(string);
        if (uRL == null) {
            return ClassLoader.getSystemResource(string);
        }
        return uRL;
    }

    public static final synchronized ResourceManager instance() {
        if (_instance == null) {
            _instance = new ResourceManager();
        }
        return _instance;
    }

    private ResourceManager() {
        String string = System.getProperty("apple.awt.brushMetalLook");
        this.BRUSHED_METAL = string != null && string.equalsIgnoreCase("true");
        ThemeMediator.setFontSizeDelta(ThemeSettings.FONT_SIZE_INCREMENT.getValue());
        try {
            ResourceManager.validateLocaleAndFonts(Locale.getDefault());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static void validateLocaleAndFonts(Locale locale) {
    }

    private static boolean checkUIFonts(String string, String string2) {
        String[] stringArray = new String[]{"TextField.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "FormattedTextField.font", "Button.font", "CheckBox.font", "RadioButton.font", "ToggleButton.font", "ProgressBar.font", "ComboBox.font", "InternalFrame.titleFont", "DesktopIcon.font", "TitledBorder.font", "Label.font", "List.font", "TabbedPane.font", "Table.font", "TableHeader.font", "MenuBar.font", "Menu.font", "Menu.acceleratorFont", "MenuItem.font", "MenuItem.acceleratorFont", "PopupMenu.font", "CheckBoxMenuItem.font", "CheckBoxMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "RadioButtonMenuItem.acceleratorFont", "Spinner.font", "Tree.font", "ToolBar.font", "OptionPane.messageFont", "OptionPane.buttonFont", "ToolTip.font"};
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            bl |= ResourceManager.checkFont(stringArray[i], string, string2, false);
        }
        for (Map.Entry entry : UIManager.getDefaults().entrySet()) {
            Font font;
            if (!(entry.getValue() instanceof Font) || (font = (Font)entry.getValue()) == null || string.equalsIgnoreCase(font.getName()) || GUIUtils.canDisplay(font, string2) || !GUIUtils.canDisplay(font = new Font(string, font.getStyle(), font.getSize()), string2)) continue;
            entry.setValue(font);
            bl = true;
        }
        return bl;
    }

    private static boolean checkFont(String string, String string2, String string3, boolean bl) {
        boolean bl2 = true;
        Font font = UIManager.getFont(string);
        if (font != null && !string2.equalsIgnoreCase(font.getName())) {
            if (!GUIUtils.canDisplay(font, string3) || bl) {
                if (GUIUtils.canDisplay(font = new Font(string2, font.getStyle(), font.getSize()), string3)) {
                    UIManager.put(string, font);
                } else {
                    bl2 = false;
                }
            }
        } else {
            bl2 = font != null ? GUIUtils.canDisplay(font, string3) : false;
        }
        return bl2;
    }

    public boolean isTrayIconAvailable() {
        return (OSUtils.isWindows() || OSUtils.isLinux()) && NotifyUserProxy.instance().supportsSystemTray();
    }

    public boolean isBrushedMetalSet() {
        return this.BRUSHED_METAL;
    }

    public void themeChanged() {
        THEME_IMAGES.clear();
        if (ThemeSettings.isOtherTheme() || ThemeSettings.isNativeTheme()) {
            // empty if block
        }
    }

    static ComponentUI getNativeUI(JComponent jComponent) {
        ComponentUI componentUI = null;
        String string = UIManager.getSystemLookAndFeelClassName();
        if (string != null) {
            try {
                Class<?> clazz = Class.forName(string);
                LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
                lookAndFeel.initialize();
                UIDefaults uIDefaults = lookAndFeel.getDefaults();
                componentUI = uIDefaults.getUI(jComponent);
            }
            catch (ExceptionInInitializerError exceptionInInitializerError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (SecurityException securityException) {
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        if (componentUI == null) {
            componentUI = UIManager.getUI(jComponent);
        }
        return componentUI;
    }

    static {
        THEME_IMAGES = new HashMap<String, ImageIcon>();
        loadFailureEncountered = false;
        ResourceManager.resetLocaleOptions();
    }
}

