/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.event.HyperlinkListener;

public final class ScrollingTextPane
extends JScrollPane {
    private static final long serialVersionUID = 1706678462639869854L;
    private final JEditorPane EDITOR_PANE;
    protected Timer _timer;

    public ScrollingTextPane(String string) {
        if (string == null) {
            throw new NullPointerException("null html");
        }
        this.EDITOR_PANE = new JEditorPane("text/html", string);
        this.EDITOR_PANE.setMargin(new Insets(5, 5, 5, 5));
        this.EDITOR_PANE.setEditable(false);
        this.getViewport().add(this.EDITOR_PANE);
        this.setDoubleBuffered(true);
        AbstractAction abstractAction = new AbstractAction(){
            private static final long serialVersionUID = 1486050927440198480L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScrollingTextPane.this.scroll();
            }
        };
        this._timer = new Timer(50, abstractAction);
        this.EDITOR_PANE.setCaretPosition(0);
    }

    public void startScroll() {
        this._timer.start();
    }

    public void stopScroll() {
        this._timer.stop();
    }

    protected void scroll() {
        Rectangle rectangle = this.EDITOR_PANE.getVisibleRect();
        int n = rectangle.x;
        int n2 = this.getVerticalScrollBar().getValue();
        if (n2 + rectangle.height >= this.EDITOR_PANE.getHeight()) {
            return;
        }
        Rectangle rectangle2 = new Rectangle(n, ++n2, n + rectangle.width, n2 + rectangle.height);
        this.EDITOR_PANE.scrollRectToVisible(rectangle2);
    }

    public void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.EDITOR_PANE.addHyperlinkListener(hyperlinkListener);
    }
}

