/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.Main;
import com.limegroup.gnutella.gui.StatusComponent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JWindow;

public final class SplashWindow {
    private static SplashWindow INSTANCE;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private volatile StatusComponent glassPane;
    private volatile JLabel splashLabel;
    private volatile JWindow splashWindow;

    public static synchronized SplashWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new SplashWindow();
        }
        return INSTANCE;
    }

    public static synchronized boolean isSplashConstructed() {
        return INSTANCE != null;
    }

    private void initialize() {
        int n;
        this.glassPane = new StatusComponent(15);
        this.splashLabel = new JLabel();
        this.splashWindow = new JWindow();
        this.glassPane.add(Box.createVerticalGlue(), 0);
        this.glassPane.add(Box.createVerticalStrut(8));
        this.glassPane.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        URL uRL = null;
        try {
            uRL = Main.getChosenSplashURL();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        assert (uRL != null);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(uRL);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        assert (bufferedImage != null);
        int n2 = ((Image)bufferedImage).getWidth(null);
        if (n2 < 1) {
            n2 = 1;
        }
        if ((n = ((Image)bufferedImage).getHeight(null)) < 1) {
            n = 1;
        }
        Dimension dimension = new Dimension(n2 + 2, n + 2);
        this.splashWindow.setSize(dimension);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.splashWindow.setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        this.splashLabel.setIcon(new ImageIcon(bufferedImage));
        this.splashWindow.getContentPane().add((Component)this.splashLabel, "Center");
        this.splashWindow.setGlassPane(this.glassPane);
        this.splashWindow.pack();
    }

    public void begin() {
        if (this.initialized.getAndSet(true)) {
            return;
        }
        this.runLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.initialize();
                SplashWindow.this.splashWindow.toFront();
                SplashWindow.this.splashWindow.setVisible(true);
                SplashWindow.this.glassPane.setVisible(true);
                SplashWindow.this.setStatusText(I18n.tr("Loading FrostWire..."));
            }
        });
    }

    public void setStatusText(final String string) {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.glassPane.setText(string);
                SplashWindow.this.glassPane.paintImmediately(0, 0, SplashWindow.this.glassPane.getWidth(), SplashWindow.this.glassPane.getHeight());
            }
        });
    }

    public void refreshImage() {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.splashLabel.setIcon(new ImageIcon(Toolkit.getDefaultToolkit().createImage(Main.getChosenSplashURL())));
                SplashWindow.this.glassPane.setVisible(false);
                SplashWindow.this.splashWindow.pack();
                SplashWindow.this.splashLabel.paintImmediately(0, 0, SplashWindow.this.splashLabel.getWidth(), SplashWindow.this.splashLabel.getHeight());
            }
        });
    }

    private void runLater(Runnable runnable) {
        if (this.initialized.get()) {
            GUIMediator.safeInvokeAndWait(runnable);
        }
    }

    public void dispose() {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.splashWindow.dispose();
            }
        });
    }

    public boolean isShowing() {
        return this.splashWindow != null && this.splashWindow.isShowing();
    }

    public void setVisible(final boolean bl) {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.splashWindow.setVisible(bl);
            }
        });
    }

    public void toBack() {
        this.runLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.splashWindow.toBack();
            }
        });
    }
}

