/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.aelitis.azureus.core.AzureusCore;
import com.frostwire.AzureusStarter;
import com.frostwire.gui.bittorrent.BTDownloadMediator;
import com.limegroup.gnutella.UpdateInformation;
import com.limegroup.gnutella.gui.CurrentAudioStatusComponent;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconButton;
import com.limegroup.gnutella.gui.LanguageButton;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.StatusComponent;
import com.limegroup.gnutella.gui.UpdatePanel;
import com.limegroup.gnutella.gui.themes.SkinCheckBoxMenuItem;
import com.limegroup.gnutella.gui.themes.SkinPopupMenu;
import com.limegroup.gnutella.gui.themes.ThemeMediator;
import com.limegroup.gnutella.gui.themes.ThemeObserver;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.settings.SharingSettings;
import com.limegroup.gnutella.settings.StatusBarSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ToolTipManager;
import org.limewire.setting.BooleanSetting;

public final class StatusLine
implements ThemeObserver {
    public static final int STATUS_DISCONNECTED = 0;
    public static final int STATUS_TURBOCHARGED = 1;
    private JPanel BAR;
    private JLabel _connectionQualityMeter;
    private final ImageIcon[] _connectionQualityMeterIcons = new ImageIcon[7];
    private LanguageButton _languageButton;
    private JLabel _firewallStatus;
    private JLabel _bandwidthUsageDown;
    private JLabel _bandwidthUsageUp;
    private IconButton _twitterButton;
    private IconButton _facebookButton;
    private IconButton _googlePlusButton;
    private IconButton seedingStatusButton;
    private StatusComponent STATUS_COMPONENT;
    private UpdatePanel _updatePanel;
    private JPanel _centerPanel;
    private Component _centerComponent;
    private CurrentAudioStatusComponent _audioStatusComponent;
    private long _nextUpdateTime = System.currentTimeMillis();
    private final RefreshListener REFRESH_LISTENER = new RefreshListener(){

        @Override
        public void refresh() {
            if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue()) {
                StatusLine.this.updateBandwidth();
            }
            StatusLine.this.updateCenterPanel();
        }
    };
    private final MouseAdapter STATUS_BAR_LISTENER = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.processMouseEvent(mouseEvent);
        }

        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SkinPopupMenu skinPopupMenu = new SkinPopupMenu();
                SkinCheckBoxMenuItem skinCheckBoxMenuItem = new SkinCheckBoxMenuItem(new ShowConnectionQualityAction());
                skinCheckBoxMenuItem.setState(StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue());
                skinPopupMenu.add(skinCheckBoxMenuItem);
                skinCheckBoxMenuItem = new SkinCheckBoxMenuItem(new ShowLanguageStatusAction());
                skinCheckBoxMenuItem.setState(StatusLine.this.getLanguageSetting().getValue());
                skinPopupMenu.add(skinCheckBoxMenuItem);
                skinCheckBoxMenuItem = new SkinCheckBoxMenuItem(new ShowFirewallStatusAction());
                skinCheckBoxMenuItem.setState(StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue());
                skinPopupMenu.add(skinCheckBoxMenuItem);
                skinCheckBoxMenuItem = new SkinCheckBoxMenuItem(new ShowBandwidthConsumptionAction());
                skinCheckBoxMenuItem.setState(StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue());
                skinPopupMenu.add(skinCheckBoxMenuItem);
                skinPopupMenu.pack();
                skinPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    };

    public StatusLine() {
        GUIMediator.setSplashScreenString(I18n.tr("Loading Status Window..."));
        this.getComponent().addMouseListener(this.STATUS_BAR_LISTENER);
        GUIMediator.getAppFrame().addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                StatusLine.this.refresh();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
        GUIMediator.setSplashScreenString(I18n.tr("Creating Audio Status Component..."));
        this._audioStatusComponent = new CurrentAudioStatusComponent();
        GUIMediator.setSplashScreenString(I18n.tr("Creating Connection Quality Indicator..."));
        this.createConnectionQualityPanel();
        GUIMediator.setSplashScreenString(I18n.tr("Adding flags here and there..."));
        this.createLanguageButton();
        GUIMediator.setSplashScreenString(I18n.tr("Playing with pixels for the Firewall indicator..."));
        this.createFirewallLabel();
        this.createBandwidthLabel();
        GUIMediator.setSplashScreenString(I18n.tr("Learning to socialize on Facebook..."));
        this.createFacebookButton();
        GUIMediator.setSplashScreenString(I18n.tr("Learning to socialize on Twitter..."));
        this.createTwitterButton();
        GUIMediator.setSplashScreenString(I18n.tr("Learning to socialize on G+..."));
        this.createGooglePlusButton();
        GUIMediator.setSplashScreenString(I18n.tr("Painting seeding sign..."));
        this.createSeedingStatusLabel();
        GUIMediator.setSplashScreenString(I18n.tr("Creating center panel..."));
        this.createCenterPanel();
        this.setConnectionQuality(0);
        GUIMediator.addRefreshListener(this.REFRESH_LISTENER);
        ThemeMediator.addThemeObserver(this);
        this.refresh();
    }

    private void createTwitterButton() {
        this._twitterButton = new IconButton("TWITTER");
        this.initSocialButton(this._twitterButton, I18n.tr("Follow us @frostwire"), "https://twitter.com/#!/frostwire");
    }

    private void createFacebookButton() {
        this._facebookButton = new IconButton("FACEBOOK");
        this.initSocialButton(this._facebookButton, I18n.tr("Like FrostWire on Facebook and stay in touch with the community. Get Help and Help Others."), "http://www.facebook.com/pages/FrostWire/110265295669948");
    }

    private void createGooglePlusButton() {
        this._googlePlusButton = new IconButton("GOOGLEPLUS");
        this._googlePlusButton.setPreferredSize(new Dimension(19, 16));
        this.initSocialButton(this._googlePlusButton, I18n.tr("Circle FrostWire on G+"), "https://plus.google.com/b/101138154526002646407/");
    }

    private void initSocialButton(IconButton iconButton, String string, final String string2) {
        iconButton.setToolTipText(I18n.tr(string));
        iconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.openURL(string2);
            }
        });
    }

    private void createSeedingStatusLabel() {
        this.seedingStatusButton = new IconButton("", "SEEDING", true){
            private static final long serialVersionUID = -8985154093868645203L;

            @Override
            public String getToolTipText() {
                boolean bl = SharingSettings.SEED_FINISHED_TORRENTS.getValue();
                String string = bl ? I18n.tr("<html><b>Seeding</b><p>completed torrent downloads.</html>") : I18n.tr("<html><b>Not Seeding</b>.<p>File chunks might be shared only during<p>a torrent download.</html>");
                return string;
            }
        };
        this.seedingStatusButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIMediator.instance().setOptionsVisible(true, I18n.tr("Options"));
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this.seedingStatusButton);
    }

    public void refresh() {
        if (this._audioStatusComponent == null || this._centerComponent == null) {
            return;
        }
        this.getComponent().removeAll();
        int n = Math.max(2, this.createSeparator().getWidth());
        int n2 = this.BAR.getWidth();
        if (n2 <= 0) {
            n2 = ApplicationSettings.APP_WIDTH.getValue();
        }
        n2 -= n;
        n2 -= 3;
        n2 -= this._audioStatusComponent.getWidth();
        n2 -= 6;
        int n3 = this._centerComponent.getWidth();
        if (n3 <= 0 && this._updatePanel.shouldBeShown()) {
            n3 = 190;
        }
        n2 -= n3;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = -1;
        n3 = 6 + Math.max((int)this._connectionQualityMeter.getMinimumSize().getWidth(), this._connectionQualityMeter.getWidth()) + n;
        if (StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.getValue() && n2 > n3) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._connectionQualityMeter, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n2 -= n3;
        }
        n3 = 6 + Math.max((int)this._languageButton.getMinimumSize().getWidth(), this._languageButton.getWidth()) + n;
        BooleanSetting booleanSetting = this.getLanguageSetting();
        if (booleanSetting.getValue() && n2 > n3) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._languageButton, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n2 -= n3;
        }
        n3 = 6 + Math.max((int)this._firewallStatus.getMinimumSize().getWidth(), this._firewallStatus.getWidth()) + n;
        if (StatusBarSettings.FIREWALL_DISPLAY_ENABLED.getValue() && n2 > n3) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._firewallStatus, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n2 -= n3;
            this.updateFirewall();
        }
        n3 = 9 + n + Math.max((int)this._bandwidthUsageDown.getMinimumSize().getWidth(), this._bandwidthUsageDown.getWidth()) + Math.max((int)this._bandwidthUsageUp.getMinimumSize().getWidth(), this._bandwidthUsageUp.getWidth());
        if (StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.getValue() && n2 > n3) {
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add((Component)this._bandwidthUsageDown, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(6), gridBagConstraints);
            this.BAR.add((Component)this._bandwidthUsageUp, gridBagConstraints);
            this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
            this.BAR.add(this.createSeparator(), gridBagConstraints);
            n2 -= n3;
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        this.BAR.add((Component)this.seedingStatusButton, gridBagConstraints);
        this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
        this.BAR.add(this.createSeparator(), gridBagConstraints);
        this.updateSeedingStatus();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = -1;
        this.BAR.add((Component)this._facebookButton, gridBagConstraints);
        this.BAR.add((Component)this._twitterButton, gridBagConstraints);
        this.BAR.add((Component)this._googlePlusButton, gridBagConstraints);
        this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        this.BAR.add((Component)this._centerPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
        this.BAR.add(Box.createHorizontalStrut(3), gridBagConstraints);
        this.BAR.add((Component)this._audioStatusComponent, gridBagConstraints);
        this.BAR.add(Box.createHorizontalStrut(10));
        this.BAR.add(Box.createHorizontalStrut(6), gridBagConstraints);
        this.BAR.validate();
        this.BAR.repaint();
    }

    private Component createSeparator() {
        JSeparator jSeparator = new JSeparator(1);
        jSeparator.setPreferredSize(new Dimension(2, 20));
        jSeparator.setMinimumSize(new Dimension(2, 20));
        return jSeparator;
    }

    private void createConnectionQualityPanel() {
        this.updateTheme();
        this._connectionQualityMeter = new JLabel();
        this._connectionQualityMeter.setOpaque(false);
        this._connectionQualityMeter.setMinimumSize(new Dimension(34, 20));
        this._connectionQualityMeter.setMaximumSize(new Dimension(90, 30));
        this._connectionQualityMeter.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createLanguageButton() {
        this._languageButton = new LanguageButton();
        this._languageButton.addMouseListener(this.STATUS_BAR_LISTENER);
        this.updateLanguage();
    }

    private void createFirewallLabel() {
        this._firewallStatus = new JLabel();
        this.updateFirewall();
        this._firewallStatus.setMinimumSize(new Dimension(20, 20));
        this._firewallStatus.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createBandwidthLabel() {
        this._bandwidthUsageDown = new LazyTooltip(GUIMediator.getThemeImage("downloading_small"));
        this._bandwidthUsageUp = new LazyTooltip(GUIMediator.getThemeImage("uploading_small"));
        this._bandwidthUsageDown.setMinimumSize(new Dimension(60, 20));
        this._bandwidthUsageUp.setMinimumSize(new Dimension(60, 20));
        this._bandwidthUsageDown.addMouseListener(this.STATUS_BAR_LISTENER);
        this._bandwidthUsageUp.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void createCenterPanel() {
        this.STATUS_COMPONENT = new StatusComponent();
        this._updatePanel = new UpdatePanel();
        this._centerComponent = this._updatePanel;
        this._centerPanel = new JPanel(new GridBagLayout());
        this._centerPanel.setOpaque(false);
        this._updatePanel.setOpaque(false);
        this.STATUS_COMPONENT.setProgressPreferredSize(new Dimension(250, 20));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this._centerPanel.add((Component)this.STATUS_COMPONENT, gridBagConstraints);
        this._centerPanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this._updatePanel.addMouseListener(this.STATUS_BAR_LISTENER);
        this.STATUS_COMPONENT.addMouseListener(this.STATUS_BAR_LISTENER);
    }

    private void updateCenterPanel() {
        long l = System.currentTimeMillis();
        if (this._nextUpdateTime > l) {
            return;
        }
        this._nextUpdateTime = l + 5000L;
        this._centerPanel.removeAll();
        this._centerComponent = this._updatePanel.shouldBeShown() ? this._updatePanel : new JLabel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        this._centerPanel.add(this._centerComponent, gridBagConstraints);
        this.refresh();
    }

    private void updateSeedingStatus() {
        boolean bl = SharingSettings.SEED_FINISHED_TORRENTS.getValue();
        this.seedingStatusButton.setText(bl ? I18n.tr("<html><b>Seeding</b></html>") : I18n.tr("<html><b>Not Seeding</b></html>"));
        this.seedingStatusButton.setIcon(bl ? GUIMediator.getThemeImage("seeding_small") : GUIMediator.getThemeImage("not_seeding_small"));
    }

    public void showUpdatePanel(boolean bl, UpdateInformation updateInformation) {
        this._updatePanel.makeVisible(bl, updateInformation);
    }

    public void setStatusText(final String string) {
        GUIMediator.safeInvokeAndWait(new Runnable(){

            @Override
            public void run() {
                StatusLine.this.STATUS_COMPONENT.setText(string);
            }
        });
    }

    public void updateFirewallLabel(boolean bl) {
        if (bl) {
            this._firewallStatus.setIcon(GUIMediator.getThemeImage("firewall_no"));
            this._firewallStatus.setToolTipText(I18n.tr("FrostWire has not detected a firewall"));
        } else {
            this._firewallStatus.setIcon(GUIMediator.getThemeImage("firewall"));
            this._firewallStatus.setToolTipText(I18n.tr("FrostWire has detected a firewall"));
        }
    }

    public void updateLanguage() {
        this._languageButton.updateLanguageFlag();
    }

    public void updateFirewall() {
        if (AzureusStarter.isAzureusCoreStarted()) {
            AzureusCore azureusCore = AzureusStarter.getAzureusCore();
            int n = azureusCore.getGlobalManager().getNATStatus();
            this.updateFirewallLabel(n == 1 || n == 2);
        } else {
            this.updateFirewallLabel(false);
        }
    }

    public void updateBandwidth() {
        if (AzureusStarter.isAzureusCoreStarted()) {
            String string = GUIUtils.rate2speed(GUIMediator.instance().getBTDownloadMediator().getDownloadsBandwidth());
            String string2 = GUIUtils.rate2speed(GUIMediator.instance().getBTDownloadMediator().getUploadsBandwidth());
            int n = GUIMediator.instance().getCurrentDownloads();
            int n2 = GUIMediator.instance().getCurrentUploads();
            this._bandwidthUsageDown.setText(n + " @ " + string);
            this._bandwidthUsageUp.setText(n2 + " @ " + string2);
        }
    }

    void loadFinished() {
        this.updateCenterPanel();
        this._centerPanel.revalidate();
        this._centerPanel.repaint();
        this.refresh();
    }

    @Override
    public void updateTheme() {
        this._connectionQualityMeterIcons[0] = GUIMediator.getThemeImage("connect_small_0");
        this._connectionQualityMeterIcons[1] = GUIMediator.getThemeImage("connect_small_6");
    }

    public void setConnectionQuality(int n) {
        if (n >= this._connectionQualityMeterIcons.length) {
            n = this._connectionQualityMeterIcons.length - 1;
        }
        this._connectionQualityMeter.setIcon(this._connectionQualityMeterIcons[n]);
        String string = null;
        String string2 = null;
        switch (n) {
            case 0: {
                string = I18n.tr("Disconnected");
                string2 = I18n.tr("Check your internet connection, FrostWire can't connect.");
                break;
            }
            case 1: {
                string = I18n.tr("Turbo-Charged");
                string2 = I18n.tr("Your connection to the network is extremely strong");
            }
        }
        this._connectionQualityMeter.setToolTipText(string2);
        this._connectionQualityMeter.setText(string);
    }

    public JComponent getComponent() {
        if (this.BAR == null) {
            this.BAR = new JPanel(new GridBagLayout());
        }
        return this.BAR;
    }

    private BooleanSetting getLanguageSetting() {
        if (GUIMediator.isEnglishLocale()) {
            return StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED;
        }
        return StatusBarSettings.LANGUAGE_DISPLAY_ENABLED;
    }

    private class LazyTooltip
    extends JLabel {
        private static final long serialVersionUID = -5759748801999410032L;

        LazyTooltip(ImageIcon imageIcon) {
            super(imageIcon);
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText() {
            BTDownloadMediator bTDownloadMediator = GUIMediator.instance().getBTDownloadMediator();
            String string = GUIUtils.rate2speed(bTDownloadMediator.getDownloadsBandwidth());
            String string2 = GUIUtils.rate2speed(bTDownloadMediator.getUploadsBandwidth());
            String string3 = GUIUtils.toUnitbytes(bTDownloadMediator.getTotalBytesDownloaded());
            String string4 = GUIUtils.toUnitbytes(bTDownloadMediator.getTotalBytesUploaded());
            int n = GUIMediator.instance().getCurrentDownloads();
            int n2 = GUIMediator.instance().getCurrentUploads();
            StringBuilder stringBuilder = new StringBuilder(100);
            stringBuilder.append("<html><table>").append("<tr><td>").append(I18n.tr("Downloads:")).append("</td><td>").append(n).append("</td><td>@</td><td align=right>").append(string).append("</td></tr>").append("<tr><td>").append(I18n.tr("Uploads:")).append("</td><td>").append(n2).append("</td><td>@</td><td align=right>").append(string2).append("</td></tr>").append("<tr><td>").append(I18n.tr("Total Downstream:")).append("</td><td>").append(string3).append("</td></tr>").append("<tr><td>").append(I18n.tr("Total Upstream:")).append("</td><td>").append(string4).append("</td></tr>").append("</table></html>");
            return stringBuilder.toString();
        }
    }

    private class ShowBandwidthConsumptionAction
    extends AbstractAction {
        private static final long serialVersionUID = 1455679943975682049L;

        public ShowBandwidthConsumptionAction() {
            this.putValue("Name", I18n.tr("Show Bandwidth Consumption"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.BANDWIDTH_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowFirewallStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = -8489901794229005217L;

        public ShowFirewallStatusAction() {
            this.putValue("Name", I18n.tr("Show Firewall Status"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.FIREWALL_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }

    private class ShowLanguageStatusAction
    extends AbstractAction {
        private static final long serialVersionUID = 726208491122581283L;

        public ShowLanguageStatusAction() {
            this.putValue("Name", I18n.tr("Show Language Status"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BooleanSetting booleanSetting = StatusLine.this.getLanguageSetting();
            booleanSetting.invert();
            StatusBarSettings.LANGUAGE_DISPLAY_ENABLED.setValue(booleanSetting.getValue());
            StatusBarSettings.LANGUAGE_DISPLAY_ENGLISH_ENABLED.setValue(booleanSetting.getValue());
            StatusLine.this.refresh();
        }
    }

    private class ShowConnectionQualityAction
    extends AbstractAction {
        private static final long serialVersionUID = 7922422377962473634L;

        public ShowConnectionQualityAction() {
            this.putValue("Name", I18n.tr("Show Connection Quality"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            StatusBarSettings.CONNECTION_QUALITY_DISPLAY_ENABLED.invert();
            StatusLine.this.refresh();
        }
    }
}

