/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.gui.GUIUtils;
import java.awt.Color;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.net.URL;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class URLLabel
extends JLabel {
    private static final long serialVersionUID = 6031824310075568242L;
    private MouseListener urlListener;
    private PropertyChangeListener listener = null;
    private Action currentAction;
    private String url = "";
    private String text;
    private Color linkColor = UIManager.getColor("Label.foreground");

    public URLLabel(URL uRL, String string) {
        this(uRL.toExternalForm(), string);
    }

    public URLLabel(URI uRI, String string) {
        this(uRI.toString(), string);
    }

    public URLLabel(String string) {
        this(string, string);
    }

    public URLLabel(String string, String string2) {
        this.url = string;
        this.setText(string2);
        this.setToolTipText(string);
        this.installListener(GUIUtils.getURLInputListener(string));
    }

    public URLLabel(String string, Icon icon) {
        this.url = string;
        this.setText(null);
        this.setIcon(icon);
        this.setToolTipText(string);
        this.installListener(GUIUtils.getURLInputListener(string));
    }

    public URLLabel(Action action) {
        this.setAction(action);
    }

    @Override
    public void setText(String string) {
        this.text = string;
        String string2 = null;
        if (string != null) {
            string2 = "<html><a href=\"" + this.url + "\"" + (this.linkColor != null ? "color=\"#" + GUIUtils.colorToHex(this.linkColor) + "\"" : "") + ">" + string + "</a></html>";
        }
        super.setText(string2);
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (action2 != null) {
            action2.removePropertyChangeListener(this.getListener());
        }
        this.currentAction = action;
        this.currentAction.addPropertyChangeListener(this.getListener());
        this.installListener(GUIUtils.getURLInputListener(action));
        this.updateLabel();
    }

    public void setColor(Color color) {
        this.linkColor = color;
        this.setText(this.text);
    }

    public Action getAction() {
        return this.currentAction;
    }

    private PropertyChangeListener getListener() {
        if (this.listener == null) {
            this.listener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    URLLabel.this.updateLabel();
                }
            };
        }
        return this.listener;
    }

    public void updateLabel() {
        if (this.currentAction != null) {
            String string = (String)this.currentAction.getValue("Name");
            Color color = (Color)this.currentAction.getValue("LimeColor");
            if (color != null) {
                this.setColor(color);
            }
            this.setIcon((Icon)this.currentAction.getValue("SmallIcon"));
            this.setToolTipText((String)this.currentAction.getValue("ShortDescription"));
            this.setText(string);
        } else {
            this.setText(this.text);
            this.setToolTipText(this.url);
        }
    }

    private void installListener(MouseListener mouseListener) {
        if (this.urlListener != null) {
            this.removeMouseListener(this.urlListener);
        }
        this.urlListener = mouseListener;
        this.addMouseListener(this.urlListener);
    }
}

