/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.UpdateInformation;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.RefreshListener;
import com.limegroup.gnutella.gui.UpdateDialog;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.plaf.metal.MetalLabelUI;

final class UpdatePanel
extends JLabel
implements RefreshListener {
    private static final long serialVersionUID = -3560119738968252710L;
    private final String labelString = I18n.tr("A newer version is available, update?");
    private volatile boolean _updateAvailable;
    private UpdateInformation _info;
    private UpdateDialog _dialog;

    UpdatePanel() {
        super(I18n.tr("A newer version is available, update?"), 0);
        this.setUI(new LinkLabelUI());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.labelString);
        Dimension dimension = new Dimension(n, fontMetrics.getHeight());
        this.setForeground(Color.red);
        this.setPreferredSize(dimension);
        this.setMaximumSize(dimension);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                UpdatePanel.this.handleClick();
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                if (UpdatePanel.this._updateAvailable) {
                    mouseEvent.getComponent().setCursor(Cursor.getPredefinedCursor(12));
                }
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                if (UpdatePanel.this._updateAvailable) {
                    mouseEvent.getComponent().setCursor(Cursor.getDefaultCursor());
                }
            }
        });
        GUIMediator.addRefreshListener(this);
        this.setVisible(false);
        this._updateAvailable = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeVisible(boolean bl, UpdateInformation updateInformation) {
        Runnable runnable = null;
        UpdatePanel updatePanel = this;
        synchronized (updatePanel) {
            this._updateAvailable = true;
            this._info = updateInformation;
            final UpdateDialog updateDialog = this._dialog;
            if (this._info != null) {
                this._dialog = new UpdateDialog(this._info);
            }
            if (updateDialog != null) {
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        updateDialog.setVisible(false);
                        updateDialog.dispose();
                    }
                };
            }
        }
        if (runnable != null) {
            GUIMediator.safeInvokeLater(runnable);
        }
        super.setVisible(true);
        if (bl) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdatePanel.this.handleClick();
                }
            });
        }
    }

    public boolean shouldBeShown() {
        return this._updateAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClick() {
        if (!this._updateAvailable) {
            return;
        }
        UpdatePanel updatePanel = this;
        synchronized (updatePanel) {
            if (this._info != null) {
                GUIUtils.centerOnScreen(this._dialog);
                this._dialog.setVisible(true);
            }
        }
    }

    @Override
    public void refresh() {
        if (!this._updateAvailable) {
            return;
        }
        Color color = this.getForeground();
        if (color.equals(Color.red)) {
            this.setForeground(Color.black);
        }
        if (color.equals(Color.black)) {
            this.setForeground(Color.red);
        }
    }

    private class LinkLabelUI
    extends MetalLabelUI {
        private LinkLabelUI() {
        }

        @Override
        protected void paintEnabledText(JLabel jLabel, Graphics graphics, String string, int n, int n2) {
            super.paintEnabledText(jLabel, graphics, string, n, n2);
            if (UpdatePanel.this.getText() == null) {
                return;
            }
            FontMetrics fontMetrics = graphics.getFontMetrics();
            graphics.fillRect(n, fontMetrics.getAscent() + 2, fontMetrics.stringWidth(UpdatePanel.this.getText()) - UpdatePanel.this.getInsets().right, 1);
        }
    }
}

