/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.frostwire.gui.bittorrent.BTDownload;
import com.limegroup.gnutella.ActivityCallback;
import com.limegroup.gnutella.MagnetOptions;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.UpdateInformation;
import com.limegroup.gnutella.gui.Finalizer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.MainFrame;
import com.limegroup.gnutella.gui.search.SearchInformation;
import com.limegroup.gnutella.gui.search.SearchMediator;
import com.limegroup.gnutella.util.QueryUtils;
import java.io.File;
import javax.swing.SwingUtilities;
import org.gudy.azureus2.core3.download.DownloadManager;

public final class VisualConnectionCallback
implements ActivityCallback {
    private static VisualConnectionCallback INSTANCE;

    public static VisualConnectionCallback instance() {
        if (INSTANCE == null) {
            INSTANCE = new VisualConnectionCallback();
        }
        return INSTANCE;
    }

    private VisualConnectionCallback() {
    }

    @Override
    public void fileManagerLoading() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    public void addDownload(BTDownload bTDownload) {
        AddDownload addDownload = new AddDownload(bTDownload);
        SwingUtilities.invokeLater(addDownload);
    }

    @Override
    public void downloadsComplete() {
        Finalizer.setDownloadsComplete();
    }

    @Override
    public void showDownloads() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
            }
        });
    }

    @Override
    public void uploadsComplete() {
        Finalizer.setUploadsComplete();
    }

    @Override
    public void handleAddressStateChanged() {
    }

    public void handleNoInternetConnection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (GUIMediator.isConstructed()) {
                    GUIMediator.disconnected();
                }
            }
        });
    }

    @Override
    public void updateAvailable(final UpdateInformation updateInformation) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.instance().showUpdateNotification(updateInformation);
            }
        });
    }

    @Override
    public void restoreApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.restoreView();
            }
        });
    }

    @Override
    public void componentLoading(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.setSplashScreenString(I18n.tr(string));
            }
        });
    }

    private MainFrame mf() {
        return GUIMediator.instance().getMainFrame();
    }

    @Override
    public boolean handleMagnets(final MagnetOptions[] magnetOptionsArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                for (int i = 0; i < magnetOptionsArray.length; ++i) {
                    String string;
                    SearchInformation searchInformation;
                    if (!magnetOptionsArray[i].isKeywordTopicOnly() || bl || SearchMediator.validateInfo(searchInformation = SearchInformation.createKeywordSearch(string = QueryUtils.createQueryString(magnetOptionsArray[i].getKeywordTopic()), null, MediaType.getAnyTypeMediaType())) != 0) continue;
                    bl = true;
                    SearchMediator.triggerSearch(searchInformation);
                }
                if (magnetOptionsArray.length > 0) {
                    GUIMediator.instance().setWindow(GUIMediator.Tabs.SEARCH);
                }
            }
        });
        return true;
    }

    @Override
    public void handleTorrent(final File file) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.instance().openTorrentFile(file, false);
            }
        });
    }

    @Override
    public void handleTorrentMagnet(final String string, final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUIMediator.instance().setRemoteDownloadsAllowed(bl);
                System.out.println("VisualConnectionCallback about to call openTorrentURI of request.");
                System.out.println(string);
                GUIMediator.instance().openTorrentURI(string, bl);
            }
        });
    }

    @Override
    public void addDownloadManager(DownloadManager downloadManager) {
        AddDownloadManager addDownloadManager = new AddDownloadManager(downloadManager);
        GUIMediator.safeInvokeAndWait(addDownloadManager);
    }

    @Override
    public boolean isRemoteDownloadsAllowed() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    GUIMediator.instance();
                }
            });
        }
        catch (Exception exception) {
            System.out.println("Failed to create GUIMediator");
            exception.printStackTrace();
        }
        return GUIMediator.instance().isRemoteDownloadsAllowed();
    }

    private class AddDownloadManager
    implements Runnable {
        private DownloadManager mgr;

        public AddDownloadManager(DownloadManager downloadManager) {
            this.mgr = downloadManager;
        }

        @Override
        public void run() {
            VisualConnectionCallback.this.mf().getBTDownloadMediator().addDownloadManager(this.mgr);
        }
    }

    private class AddDownload
    implements Runnable {
        private BTDownload mgr;

        public AddDownload(BTDownload bTDownload) {
            this.mgr = bTDownload;
        }

        @Override
        public void run() {
            VisualConnectionCallback.this.mf().getBTDownloadMediator().add(this.mgr);
        }
    }
}

