/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui;

import com.limegroup.gnutella.LimeXMLNames;
import com.limegroup.gnutella.LimeXMLSchema;
import com.limegroup.gnutella.SchemaFieldInfo;
import com.limegroup.gnutella.gui.I18n;
import java.util.Date;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLUtils {
    private static final Log LOG = LogFactory.getLog(XMLUtils.class);

    private XMLUtils() {
    }

    public static Comparable<?> getComparable(SchemaFieldInfo schemaFieldInfo, String string) {
        if (schemaFieldInfo == null || string == null) {
            return null;
        }
        if (schemaFieldInfo.getJavaType() == Integer.class || schemaFieldInfo.getJavaType() == Date.class) {
            try {
                return Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return string;
    }

    public static String getResource(String string) {
        String string2 = LimeXMLNames.getDisplayName(string);
        if (string2 != null) {
            return I18n.tr(string2);
        }
        if (LOG.isWarnEnabled()) {
            LOG.warn("Missing resource for '" + string + "', falling back to default");
        }
        return XMLUtils.fallbackResource(string, XMLUtils.getBundleForField(string));
    }

    public static String getTitleForSchemaFromField(String string) {
        if (!string.endsWith("__")) {
            return null;
        }
        int n = string.indexOf("__") + 2;
        int n2 = string.indexOf("__", n);
        return XMLUtils.getResource(string.substring(0, n2));
    }

    public static String getTitleForSchema(LimeXMLSchema limeXMLSchema) {
        return XMLUtils.getResource(limeXMLSchema.getRootXMLName() + "__" + limeXMLSchema.getInnerXMLName());
    }

    private static ResourceBundle getBundleForField(String string) {
        return null;
    }

    private static String fallbackResource(String string, ResourceBundle resourceBundle) {
        block3: {
            if (resourceBundle != null) {
                try {
                    return resourceBundle.getString(string);
                }
                catch (MissingResourceException missingResourceException) {
                    if (!LOG.isWarnEnabled()) break block3;
                    LOG.warn("Missing fallback resource for: " + string + ", capitalizing field name.", missingResourceException);
                }
            }
        }
        return XMLUtils.processField(string);
    }

    private static String formatFieldName(String string) {
        return string.substring(0, 1).toUpperCase(Locale.US) + string.substring(1).replace('_', ' ').trim();
    }

    private static String processField(String string) {
        int n = string.endsWith("__") ? string.length() - 2 : string.length();
        int n2 = string.lastIndexOf("__", n - 1) + 2;
        return XMLUtils.formatFieldName(string.substring(n2, n));
    }
}

