/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.actions;

import com.frostwire.gui.bittorrent.CreateTorrentDialog;
import com.frostwire.gui.bittorrent.SendFileProgressDialog;
import com.limegroup.gnutella.gui.AutoCompleteTextField;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.ClearableAutoCompleteTextField;
import com.limegroup.gnutella.gui.FileChooserHandler;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.IconManager;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.TorrentFileFilter;
import com.limegroup.gnutella.gui.actions.AbstractAction;
import com.limegroup.gnutella.gui.search.MagnetClipboardListener;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;

public class FileMenuActions {
    static final int SPACE = 6;

    public static boolean openMagnetOrTorrent(String string) {
        if (string.startsWith("magnet:?xt=urn:btih")) {
            GUIMediator.instance().openTorrentURI(string, true);
            return true;
        }
        if (string.matches(".*youtube.com.*")) {
            GUIMediator.instance().openYouTubeVideoUrl(string);
            return true;
        }
        if (string.matches(".*soundcloud.com.*")) {
            GUIMediator.instance().openSoundcloudTrackUrl(string, null);
            return true;
        }
        if (string.startsWith("http://")) {
            GUIMediator.instance().openTorrentURI(string, true);
            return true;
        }
        File file = new File(string);
        if (FileMenuActions.isFileSystemPath(file) && file.exists()) {
            GUIMediator.instance().openTorrentFile(file, true);
            return true;
        }
        return false;
    }

    private static boolean isFileSystemPath(File file) {
        return file.isAbsolute();
    }

    public static class SendFileAction
    extends AbstractAction {
        private static final long serialVersionUID = -313458189470318964L;

        public SendFileAction() {
            super(I18n.tr("Send File or Folder..."));
            this.putValue("LongDescription", I18n.tr("Send a file or a folder to a friend"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SendFileProgressDialog sendFileProgressDialog = new SendFileProgressDialog(GUIMediator.getAppFrame());
            sendFileProgressDialog.setVisible(true);
        }
    }

    public static class CreateTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 1494672346951877693L;

        public CreateTorrentAction() {
            super(I18n.tr("Create New Torrent"));
            this.putValue("LongDescription", I18n.tr("Create a new .torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CreateTorrentDialog createTorrentDialog = new CreateTorrentDialog(GUIMediator.getAppFrame());
            createTorrentDialog.setVisible(true);
        }
    }

    public static class ExitAction
    extends AbstractAction {
        private static final long serialVersionUID = 8000042651676530796L;

        public ExitAction() {
            super(I18n.tr("E&xit"));
            this.putValue("LongDescription", I18n.tr("Close and exit the program"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.shutdown();
        }
    }

    public static class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = -456007457702576349L;

        public CloseAction() {
            super(I18n.tr("&Close"));
            this.putValue("LongDescription", I18n.tr("Close the program's main window"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.close(false);
        }
    }

    public static class OpenMagnetTorrentAction
    extends AbstractAction {
        private static final long serialVersionUID = 7148824020273223391L;
        private JDialog dialog = null;
        private AutoCompleteTextField PATH_FIELD = new ClearableAutoCompleteTextField(34);

        public OpenMagnetTorrentAction() {
            super(I18n.tr("O&pen .Torrent or Magnet"));
            this.putValue("LongDescription", I18n.tr("Opens a magnet link or torrent file"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dialog == null) {
                this.createDialog();
            }
            this.PATH_FIELD.setText(MagnetClipboardListener.getMagnetOrTorrentURLFromClipboard());
            this.dialog.pack();
            GUIUtils.centerOnScreen(this.dialog);
            this.dialog.setVisible(true);
        }

        private void createDialog() {
            this.dialog = new JDialog(GUIMediator.getAppFrame(), I18n.tr("Download .Torrent or Magnet or YouTube video link"), true);
            this.dialog.addWindowListener(new OpenDialogWindowAdapter());
            JPanel jPanel = (JPanel)this.dialog.getContentPane();
            GUIUtils.addHideAction(jPanel);
            jPanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            jPanel.setBorder(new EmptyBorder(12, 6, 6, 6));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 10;
            gridBagConstraints.insets = new Insets(0, 0, 12, 0);
            jPanel.add((Component)new JLabel(IconManager.instance().getIconForButton("SEARCH_DOWNLOAD")), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 6, 12, 0);
            jPanel.add((Component)new MultiLineLabel(I18n.tr("Type a magnet link, the file path or web address of a torrent file and FrostWire will start downloading it for you."), true), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            jPanel.add((Component)new JLabel(I18n.tr("Open:")), gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(0, 6, 0, 0);
            jPanel.add((Component)this.PATH_FIELD, gridBagConstraints);
            ButtonRow buttonRow = new ButtonRow(new Action[]{new PasteAction(), new BrowseAction()}, 0, 12);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.insets = new Insets(6, 6, 0, 0);
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)buttonRow, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.weighty = 1.0;
            jPanel.add((Component)new Canvas(), gridBagConstraints);
            buttonRow = new ButtonRow(new Action[]{new OkAction(), new CancelAction()}, 0, 12);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.insets = new Insets(12, 0, 0, 0);
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)buttonRow, gridBagConstraints);
            this.dialog.getRootPane().setDefaultButton(buttonRow.getButtonAtIndex(0));
        }

        private class CancelAction
        extends AbstractAction {
            private static final long serialVersionUID = 3350673081539434959L;

            public CancelAction() {
                super(I18n.tr("Cancel"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUIUtils.getDisposeAction().actionPerformed(actionEvent);
            }
        }

        private class OkAction
        extends AbstractAction {
            private static final long serialVersionUID = -2129198631435809271L;

            public OkAction() {
                super(I18n.tr("OK"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileMenuActions.openMagnetOrTorrent(OpenMagnetTorrentAction.this.PATH_FIELD.getText())) {
                    OpenMagnetTorrentAction.this.dialog.setVisible(false);
                    OpenMagnetTorrentAction.this.dialog.dispose();
                } else {
                    GUIMediator.showError(I18n.tr("FrostWire cannot download this address. Make sure you typed it correctly, and then try again."));
                }
            }
        }

        private class BrowseAction
        extends AbstractAction {
            private static final long serialVersionUID = 3000234847843826596L;

            public BrowseAction() {
                super(I18n.tr("Browse..."));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FileChooserHandler.getInputFile(GUIMediator.getAppFrame(), TorrentFileFilter.INSTANCE);
                if (file != null) {
                    OpenMagnetTorrentAction.this.PATH_FIELD.setText(file.getAbsolutePath());
                }
            }
        }

        private class PasteAction
        extends AbstractAction {
            private static final long serialVersionUID = -3351075105994389491L;

            public PasteAction() {
                super(I18n.tr("Paste"));
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                OpenMagnetTorrentAction.this.PATH_FIELD.paste();
            }
        }

        private class OpenDialogWindowAdapter
        extends WindowAdapter {
            private OpenDialogWindowAdapter() {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                OpenMagnetTorrentAction.this.PATH_FIELD.requestFocusInWindow();
            }
        }
    }
}

