/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.frostwire.HttpFetcher;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.I18n;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.MessageService;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.bugs.LocalClientInfo;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.i18n.I18nMarker;
import org.limewire.util.FileUtils;
import org.limewire.util.IOUtils;
import org.limewire.util.StringUtils;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public final class BugManager {
    private static final Log LOG = LogFactory.getLog(BugManager.class);
    private final LocalClientInfoFactory localClientInfoFactory;
    private static BugManager INSTANCE;
    private final String TITLE = I18n.tr("Internal Error");
    private static final int DIALOG_BOX_WIDTH = 300;
    private static final int DIALOG_BOX_HEIGHT = 100;
    private final ExecutorService BUGS_QUEUE = ExecutorsHelper.newProcessingQueue(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "BugProcessor");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final Map<String, Long> BUG_TIMES = Collections.synchronizedMap(new HashMap());
    private final Object WRITE_LOCK = new Object();
    private final byte[] SEPARATOR = "-----------------\n".getBytes();
    private volatile long _nextAllowedTime = 0L;
    private volatile int _dialogsShowing = 0;
    private final int MAX_DIALOGS = 3;
    private static final EnumMap<ErrorType, EnumMap<DetailErrorType, String>> errorDescs;

    public static synchronized BugManager instance() {
        if (INSTANCE == null) {
            INSTANCE = new BugManager();
        }
        return INSTANCE;
    }

    private BugManager() {
        this.localClientInfoFactory = LimeWireModule.instance().getLimeWireGUIModule().getLimeWireGUI().getLocalClientInfoFactory();
    }

    public void shutdown() {
    }

    public void handleBug(Throwable throwable, String string, String string2) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        if (throwable instanceof IOException && BugManager.handleException((IOException)throwable, ErrorType.GENERIC)) {
            return;
        }
        String string3 = new String();
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        URL[] uRLArray = ((URLClassLoader)classLoader).getURLs();
        for (int i = 0; i < uRLArray.length; ++i) {
            string3 = string3 + "  " + uRLArray[i].getFile() + "\n";
        }
        string2 = string2 + "\nCLASSPATH:\n" + string3;
        throwable.printStackTrace();
        final LocalClientInfo localClientInfo = this.localClientInfoFactory.createLocalClientInfo(throwable, string, string2, false);
        if (BugSettings.LOG_BUGS_LOCALLY.getValue()) {
            this.logBugLocally(localClientInfo);
        }
        boolean bl = false;
        if (BugSettings.IGNORE_ALL_BUGS.getValue()) {
            return;
        }
        if (!this.shouldInform(localClientInfo)) {
            return;
        }
        if (this.isSendableVersion() && BugSettings.USE_AUTOMATIC_BUG.getValue()) {
            bl = true;
        }
        if (bl) {
            this.sendToServlet(localClientInfo);
        }
        if (!bl && this._dialogsShowing < 3) {
            GUIMediator.safeInvokeLater(new Runnable(){

                @Override
                public void run() {
                    BugManager.this.reviewBug(localClientInfo);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void logBugLocally(LocalClientInfo localClientInfo) {
        File file = BugSettings.BUG_LOG_FILE.getValue();
        FileUtils.setWriteable(file);
        BufferedOutputStream bufferedOutputStream = null;
        try {
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                if (file.length() > (long)BugSettings.MAX_BUGFILE_SIZE.getValue()) {
                    file.delete();
                }
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file.getPath(), true));
                ((OutputStream)bufferedOutputStream).write((new Date().toString() + "\n").getBytes());
                ((OutputStream)bufferedOutputStream).write(localClientInfo.toBugReport().getBytes());
                ((OutputStream)bufferedOutputStream).write(this.SEPARATOR);
                ((OutputStream)bufferedOutputStream).flush();
            }
        }
        catch (IOException iOException) {
            IOUtils.close(bufferedOutputStream);
            catch (Throwable throwable) {
                IOUtils.close(bufferedOutputStream);
                throw throwable;
            }
        }
        IOUtils.close(bufferedOutputStream);
    }

    private boolean shouldInform(LocalClientInfo localClientInfo) {
        long l = System.currentTimeMillis();
        if (l < this._nextAllowedTime) {
            return false;
        }
        Long l2 = this.BUG_TIMES.get(localClientInfo.getParsedBug());
        return l2 == null || l >= l2;
    }

    private boolean isSendableVersion() {
        Version version;
        Version version2;
        try {
            version2 = new Version(FrostWireUtils.getFrostWireVersion());
            version = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.getValue());
        }
        catch (VersionFormatException versionFormatException) {
            return false;
        }
        return version2.compareTo(version) >= 0;
    }

    private static String warning() {
        return "You are using FrostWire. www.frostwire.com";
    }

    private void reviewBug(final LocalClientInfo localClientInfo) {
        ++this._dialogsShowing;
        final JDialog jDialog = new JDialog(GUIMediator.getAppFrame(), this.TITLE, true);
        Dimension dimension = new Dimension(300, 100);
        jDialog.setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        boolean bl = this.isSendableVersion();
        String string = bl ? I18n.tr("FrostWire has encountered an internal error. It is possible for FrostWire to recover and continue running normally. To aid with debugging, please click 'Send' to notify FrostWire about the problem. If desired, you can click 'Review' to look at the information that will be sent. Thank you.") : I18n.tr("FrostWire has encountered an internal error. It is possible for FrostWire to recover and continue running normally. To continue using FrostWire, click 'Discard'. If desired, you can click 'Review' to look at the information about the error.");
        string = BugManager.warning() + "\n\n" + string;
        MultiLineLabel multiLineLabel = new MultiLineLabel(string, 400);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanel2.add((Component)multiLineLabel, gridBagConstraints);
        String string2 = bl ? I18n.tr("Please add any comments you may have (e.g what caused the error).\nThank you and please use English.") : " ";
        final JTextArea jTextArea = new JTextArea(string2);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                jTextArea.selectAll();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(new Dimension(400, 80));
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton(I18n.tr("Send"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                localClientInfo.addUserComments(jTextArea.getText());
                BugManager.this.sendToServlet(localClientInfo);
                jDialog.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        JButton jButton2 = new JButton(I18n.tr("Review"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                localClientInfo.addUserComments(jTextArea.getText());
                JTextArea jTextArea2 = new JTextArea(localClientInfo.toBugReport());
                jTextArea2.setColumns(50);
                jTextArea2.setEditable(false);
                jTextArea2.setCaretPosition(0);
                JScrollPane jScrollPane = new JScrollPane(jTextArea2);
                jScrollPane.setBorder(BorderFactory.createEtchedBorder());
                jScrollPane.setPreferredSize(new Dimension(500, 200));
                MessageService.instance().showMessage(jScrollPane);
            }
        });
        JButton jButton3 = new JButton(I18n.tr("Discard"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        if (bl) {
            jPanel3.add(jButton);
        }
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        ButtonGroup buttonGroup = new ButtonGroup();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel4.setLayout(new BorderLayout());
        final JRadioButton jRadioButton = new JRadioButton(I18n.tr("Always Send Immediately"));
        final JRadioButton jRadioButton2 = new JRadioButton(I18n.tr("Always Ask For Review"));
        final JRadioButton jRadioButton3 = new JRadioButton(I18n.tr("Always Discard All Errors"));
        jPanel5.add(Box.createVerticalStrut(6));
        if (bl) {
            jPanel5.add(jRadioButton);
        }
        jPanel5.add(jRadioButton2);
        jPanel5.add(jRadioButton3);
        jPanel5.add(Box.createVerticalStrut(6));
        jPanel4.add((Component)jPanel5, "West");
        buttonGroup.add(jRadioButton);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton3);
        buttonGroup.setSelected(jRadioButton2.getModel(), true);
        ActionListener actionListener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getSource() == jRadioButton) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(false);
                    BugSettings.USE_AUTOMATIC_BUG.setValue(true);
                } else if (actionEvent.getSource() == jRadioButton2) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(false);
                    BugSettings.USE_AUTOMATIC_BUG.setValue(false);
                } else if (actionEvent.getSource() == jRadioButton3) {
                    BugSettings.IGNORE_ALL_BUGS.setValue(true);
                }
            }
        };
        jRadioButton.addActionListener(actionListener2);
        jRadioButton2.addActionListener(actionListener2);
        jRadioButton3.addActionListener(actionListener2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        if (bl) {
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(20, 0, 6, 0);
            jPanel.add((Component)jScrollPane, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        jPanel.add((Component)jPanel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        if (GUIMediator.isAppVisible()) {
            jDialog.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension3 = jDialog.getSize();
            jDialog.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
        }
        try {
            jDialog.setVisible(true);
        }
        catch (InternalError internalError) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private void servletSendFailed(LocalClientInfo localClientInfo) {
        ++this._dialogsShowing;
        final JDialog jDialog = new JDialog(GUIMediator.getAppFrame(), this.TITLE, true);
        Dimension dimension = new Dimension(350, 300);
        Dimension dimension2 = new Dimension(300, 200);
        jDialog.setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MultiLineLabel multiLineLabel = new MultiLineLabel(I18n.tr("FrostWire was unable to connect to the bug server in order to send the below bug report. For further help and to aid with debugging, please visit www.frostwire.com and click 'Support'. Thank you."), 400);
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(multiLineLabel);
        jPanel3.add(Box.createVerticalStrut(6));
        jPanel2.add(jPanel3);
        jPanel2.add(Box.createHorizontalGlue());
        String string = localClientInfo.toBugReport().trim() + "\n\n" + "FILES IN CURRENT DIRECTORY NOT LISTED.\n" + "SIZE: 0";
        final JTextArea jTextArea = new JTextArea(string);
        jTextArea.selectAll();
        jTextArea.copy();
        jTextArea.setColumns(50);
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jScrollPane.setPreferredSize(dimension2);
        JPanel jPanel4 = new JPanel();
        JButton jButton = new JButton(I18n.tr("Copy Report"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jTextArea.selectAll();
                jTextArea.copy();
                jTextArea.setCaretPosition(0);
            }
        });
        JButton jButton2 = new JButton(I18n.tr("OK"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                BugManager.this._dialogsShowing--;
            }
        });
        jPanel4.add(jButton);
        jPanel4.add(jButton2);
        jPanel.add(jPanel2);
        jPanel.add(jScrollPane);
        jPanel.add(jPanel4);
        jDialog.getContentPane().add(jPanel);
        try {
            jDialog.pack();
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return;
        }
        if (GUIMediator.isAppVisible()) {
            jDialog.setLocationRelativeTo(MessageService.getParentComponent());
        } else {
            Dimension dimension3 = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimension4 = jDialog.getSize();
            jDialog.setLocation((dimension3.width - dimension4.width) / 2, (dimension3.height - dimension4.height) / 2);
        }
        jDialog.setVisible(true);
    }

    private void sendToServlet(LocalClientInfo localClientInfo) {
        this.BUGS_QUEUE.execute(new ServletSender(localClientInfo));
    }

    public static boolean handleException(IOException iOException, ErrorType errorType) {
        for (Throwable throwable = iOException; throwable != null; throwable = throwable.getCause()) {
            String string = throwable.getMessage();
            if (string == null) continue;
            string = string.toLowerCase();
            DetailErrorType detailErrorType = null;
            if (StringUtils.contains(string, "no space left") || StringUtils.contains(string, "not enough space")) {
                detailErrorType = DetailErrorType.DISK_FULL;
            } else if (StringUtils.contains(string, "being used by another process") || StringUtils.contains(string, "with a user-mapped section open")) {
                detailErrorType = DetailErrorType.FILE_LOCKED;
            } else if (StringUtils.contains(string, "access is denied") || StringUtils.contains(string, "permission denied")) {
                detailErrorType = DetailErrorType.NO_PRIVS;
            } else if (StringUtils.contains(string, "invalid argument")) {
                detailErrorType = DetailErrorType.BAD_CHARS;
            }
            if (detailErrorType == null) continue;
            MessageService.instance().showError(errorDescs.get((Object)errorType).get((Object)detailErrorType));
            return true;
        }
        return false;
    }

    static {
        errorDescs = new EnumMap(ErrorType.class);
        for (ErrorType errorType : ErrorType.values()) {
            errorDescs.put(errorType, new EnumMap(DetailErrorType.class));
        }
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.DISK_FULL, I18nMarker.marktr("FrostWire was unable to write a necessary file because your hard drive is full. To continue using FrostWire you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.FILE_LOCKED, I18nMarker.marktr("FrostWire was unable to open a necessary file because another program has locked the file. FrostWire may act unexpectedly until this file is released."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.NO_PRIVS, I18nMarker.marktr("FrostWire was unable to write a necessary file because you do not have the necessary permissions. Your preferences may not be maintained the next time you start FrostWire, or FrostWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.GENERIC).put(DetailErrorType.BAD_CHARS, I18nMarker.marktr("FrostWire cannot open a necessary file because the filename contains characters which are not supported by your operating system. FrostWire may behave in unexpected ways."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.DISK_FULL, I18nMarker.marktr("FrostWire cannot download the selected file because your hard drive is full. To download more files, you must free up space on your hard drive."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.FILE_LOCKED, I18nMarker.marktr("FrostWire was unable to download the selected file because another program is using the file. Please close the other program and retry the download."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.NO_PRIVS, I18nMarker.marktr("FrostWire was unable to create or continue writing an incomplete file for the selected download because you do not have permission to write files to the incomplete folder. To continue using FrostWire, please choose a different Save Folder."));
        errorDescs.get((Object)ErrorType.DOWNLOAD).put(DetailErrorType.BAD_CHARS, I18nMarker.marktr("FrostWire was unable to open the incomplete file for the selected download because the filename contains characters which are not supported by your operating system."));
        for (ErrorType errorType : ErrorType.values()) {
            assert (errorDescs.get((Object)errorType) != null);
            assert (errorDescs.get((Object)errorType).size() == DetailErrorType.values().length);
        }
    }

    private static enum DetailErrorType {
        DISK_FULL,
        FILE_LOCKED,
        NO_PRIVS,
        BAD_CHARS;

    }

    public static enum ErrorType {
        GENERIC,
        DOWNLOAD;

    }

    private class ServletSender
    implements Runnable {
        final LocalClientInfo INFO;

        ServletSender(LocalClientInfo localClientInfo) {
            this.INFO = localClientInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            byte[] byArray = null;
            try {
                byArray = new HttpFetcher(new URI(BugSettings.BUG_REPORT_SERVER.getValue())).post(this.INFO.toBugReport(), "text/plain");
            }
            catch (Exception exception) {
                LOG.error("Error sending bug report", exception);
            }
            if (byArray == null) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        BugManager.this.servletSendFailed(ServletSender.this.INFO);
                    }
                });
                return;
            }
            long l = System.currentTimeMillis();
            long l2 = 1000L;
            Object object = BugManager.this.WRITE_LOCK;
            synchronized (object) {
                BugManager.this._nextAllowedTime = l + l2;
                if (l2 != 0L) {
                    BugManager.this.BUG_TIMES.put(this.INFO.getParsedBug(), new Long(l + 10L * l2));
                }
            }
        }
    }
}

