/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.frostwire.HttpFetcher;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.bugs.DeadlockException;
import com.limegroup.gnutella.gui.bugs.LocalClientInfo;
import com.limegroup.gnutella.settings.BugSettings;
import com.limegroup.gnutella.util.FrostWireUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Version;
import org.limewire.util.VersionFormatException;

public class DeadlockBugManager {
    private static final Log LOG = LogFactory.getLog(DeadlockBugManager.class);

    private DeadlockBugManager() {
    }

    public static void handleDeadlock(DeadlockException deadlockException, String string, String string2) {
        deadlockException.printStackTrace();
        System.err.println("Detail: " + string2);
        LocalClientInfo localClientInfo = LimeWireModule.instance().getLimeWireGUIModule().getLimeWireGUI().getLocalClientInfoFactory().createLocalClientInfo(deadlockException, string, string2, false);
        if (DeadlockBugManager.isSendableVersion() && BugSettings.SEND_DEADLOCK_BUGS.getValue()) {
            DeadlockBugManager.sendToServlet(localClientInfo);
        }
    }

    private static boolean isSendableVersion() {
        Version version;
        Version version2;
        try {
            version2 = new Version(FrostWireUtils.getFrostWireVersion());
            version = new Version(BugSettings.LAST_ACCEPTABLE_VERSION.getValue());
        }
        catch (VersionFormatException versionFormatException) {
            return false;
        }
        return version2.compareTo(version) >= 0;
    }

    private static void sendToServlet(LocalClientInfo localClientInfo) {
        try {
            new HttpFetcher(new URI(BugSettings.BUG_REPORT_SERVER.getValue())).post(localClientInfo.toBugReport(), "text/plain");
        }
        catch (Exception exception) {
            LOG.error("Error sending bug report", exception);
        }
    }
}

