/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.bugs;

import com.frostwire.HttpFetcher;
import com.limegroup.gnutella.gui.LimeWireModule;
import com.limegroup.gnutella.gui.LocalClientInfoFactory;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.SplashWindow;
import com.limegroup.gnutella.gui.bugs.LocalClientInfo;
import com.limegroup.gnutella.settings.BugSettings;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class FatalBugManager {
    private static final Log LOG = LogFactory.getLog(FatalBugManager.class);

    private FatalBugManager() {
    }

    public static void handleFatalBug(Throwable throwable) {
        if (throwable instanceof ThreadDeath) {
            throw (ThreadDeath)throwable;
        }
        throwable.printStackTrace();
        LocalClientInfoFactory localClientInfoFactory = LimeWireModule.instance().getLimeWireGUIModule().getLimeWireGUI().getLocalClientInfoFactory();
        final LocalClientInfo localClientInfo = localClientInfoFactory.createLocalClientInfo(throwable, Thread.currentThread().getName(), null, true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FatalBugManager.reviewBug(localClientInfo);
            }
        });
    }

    private static String warning() {
        return "You are using FrostWire. www.frostwire.com";
    }

    public static void reviewBug(final LocalClientInfo localClientInfo) {
        final JDialog jDialog = new JDialog();
        jDialog.setTitle("Fatal Error");
        Dimension dimension = new Dimension(100, 300);
        jDialog.setSize(dimension);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        MultiLineLabel multiLineLabel = new MultiLineLabel(FatalBugManager.warning() + "\n\n" + "FrostWire has encountered a fatal internal error and will now exit. " + "This is generally caused by a corrupted installation.  Please try " + "downloading and installing FrostWire again.\n\n" + "To aid with debugging, please click 'Send' to notify FrostWire about the problem. " + "If desired, you can click 'Review' to look at the information that will be sent. " + "If the problem persists, please visit www.frostwire.com and click the 'Support' " + "link.\n\n" + "Thank You.", 400);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(multiLineLabel);
        JPanel jPanel3 = new JPanel();
        JButton jButton = new JButton("Send");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FatalBugManager.sendToServlet(localClientInfo);
                jDialog.dispose();
                System.exit(1);
            }
        });
        JButton jButton2 = new JButton("Review");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JTextArea jTextArea = new JTextArea(localClientInfo.toBugReport());
                jTextArea.setColumns(50);
                jTextArea.setEditable(false);
                jTextArea.selectAll();
                jTextArea.copy();
                jTextArea.setCaretPosition(0);
                JScrollPane jScrollPane = new JScrollPane(jTextArea);
                jScrollPane.setBorder(BorderFactory.createEtchedBorder());
                jScrollPane.setPreferredSize(new Dimension(500, 200));
                FatalBugManager.showMessage(jDialog, jScrollPane);
            }
        });
        JButton jButton3 = new JButton("Discard");
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                jDialog.dispose();
                System.exit(1);
            }
        });
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jDialog.getContentPane().add(jPanel);
        jDialog.pack();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension3 = jDialog.getSize();
        jDialog.setLocation((dimension2.width - dimension3.width) / 2, (dimension2.height - dimension3.height) / 2);
        jDialog.setVisible(true);
        try {
            SplashWindow.instance().setVisible(false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        jDialog.toFront();
    }

    private static void sendToServlet(LocalClientInfo localClientInfo) {
        try {
            new HttpFetcher(new URI(BugSettings.BUG_REPORT_SERVER.getValue())).post(localClientInfo.toBugReport(), "text/plain");
        }
        catch (Exception exception) {
            LOG.error("Error sending bug report", exception);
        }
    }

    private static void showMessage(Component component, Component component2) {
        JOptionPane.showMessageDialog(component, component2, "Fatal Error - Review", 1);
    }
}

