/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.dnd;

import com.limegroup.gnutella.gui.dnd.DropInfo;
import com.limegroup.gnutella.gui.dnd.LimeTransferHandler;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import javax.swing.JComponent;

public class BasicDropTargetListener
implements DropTargetListener {
    private boolean actionSupported(int n) {
        return (n & 3) != 0;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JComponent jComponent = (JComponent)dropTargetContext.getComponent();
        LimeTransferHandler limeTransferHandler = (LimeTransferHandler)jComponent.getTransferHandler();
        DropDragInfo dropDragInfo = new DropDragInfo(dropTargetDragEvent);
        if (limeTransferHandler != null && limeTransferHandler.canImport(jComponent, dataFlavorArray, dropDragInfo) && this.actionSupported(dropDragInfo.action)) {
            dropTargetDragEvent.acceptDrag(dropDragInfo.action);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JComponent jComponent = (JComponent)dropTargetContext.getComponent();
        LimeTransferHandler limeTransferHandler = (LimeTransferHandler)jComponent.getTransferHandler();
        DropDragInfo dropDragInfo = new DropDragInfo(dropTargetDragEvent);
        if (limeTransferHandler != null && limeTransferHandler.canImport(jComponent, dataFlavorArray, dropDragInfo) && this.actionSupported(dropDragInfo.action)) {
            dropTargetDragEvent.acceptDrag(dropDragInfo.action);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDragEvent.getCurrentDataFlavors();
        DropTargetContext dropTargetContext = dropTargetDragEvent.getDropTargetContext();
        JComponent jComponent = (JComponent)dropTargetContext.getComponent();
        LimeTransferHandler limeTransferHandler = (LimeTransferHandler)jComponent.getTransferHandler();
        DropDragInfo dropDragInfo = new DropDragInfo(dropTargetDragEvent);
        if (limeTransferHandler != null && limeTransferHandler.canImport(jComponent, dataFlavorArray, dropDragInfo) && this.actionSupported(dropDragInfo.action)) {
            dropTargetDragEvent.acceptDrag(dropDragInfo.action);
        } else {
            dropTargetDragEvent.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        DataFlavor[] dataFlavorArray = dropTargetDropEvent.getCurrentDataFlavors();
        DropTargetContext dropTargetContext = dropTargetDropEvent.getDropTargetContext();
        JComponent jComponent = (JComponent)dropTargetContext.getComponent();
        LimeTransferHandler limeTransferHandler = (LimeTransferHandler)jComponent.getTransferHandler();
        DropDropInfo dropDropInfo = new DropDropInfo(dropTargetDropEvent);
        if (limeTransferHandler != null && limeTransferHandler.canImport(jComponent, dataFlavorArray, dropDropInfo) && this.actionSupported(dropDropInfo.action)) {
            dropTargetDropEvent.acceptDrop(dropDropInfo.action);
            try {
                Transferable transferable = dropTargetDropEvent.getTransferable();
                dropTargetDropEvent.dropComplete(limeTransferHandler.importData(jComponent, transferable, dropDropInfo));
            }
            catch (RuntimeException runtimeException) {
                dropTargetDropEvent.dropComplete(false);
            }
        } else {
            dropTargetDropEvent.rejectDrop();
        }
    }

    static class DropDropInfo
    implements DropInfo {
        private final DropTargetDropEvent event;
        int action;

        DropDropInfo(DropTargetDropEvent dropTargetDropEvent) {
            this.event = dropTargetDropEvent;
            this.action = dropTargetDropEvent.getDropAction();
        }

        @Override
        public void setDropAction(int n) {
            this.action = n;
        }

        @Override
        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        @Override
        public int getDropAction() {
            return this.event.getDropAction();
        }

        @Override
        public Point getPoint() {
            return this.event.getLocation();
        }
    }

    static class DropDragInfo
    implements DropInfo {
        private final DropTargetDragEvent event;
        int action;

        DropDragInfo(DropTargetDragEvent dropTargetDragEvent) {
            this.event = dropTargetDragEvent;
            this.action = dropTargetDragEvent.getDropAction();
        }

        @Override
        public void setDropAction(int n) {
            this.action = n;
        }

        @Override
        public Transferable getTransferable() {
            return this.event.getTransferable();
        }

        @Override
        public int getDropAction() {
            return this.event.getDropAction();
        }

        @Override
        public Point getPoint() {
            return this.event.getLocation();
        }
    }
}

